/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.WitcheryConfig;
import dev.sterner.witchery.content.block.ritual.RitualHelper;
import dev.sterner.witchery.content.item.ChalkItem;
import dev.sterner.witchery.content.recipe.ritual.RitualRecipe;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.integration.jei.WitcheryJeiPlugin;
import dev.sterner.witchery.integration.jei.wrapper.RitualJeiRecipe;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J0\u0010 \u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016JJ\u0010#\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,H\u0002J7\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020&2\b\u00105\u001a\u0004\u0018\u00010,H\u0002\u00a2\u0006\u0002\u00106J0\u00107\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020:2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006;"}, d2={"Ldev/sterner/witchery/integration/jei/RitualJeiRecipeCategory;", "Lmezz/jei/api/recipe/category/IRecipeCategory;", "Ldev/sterner/witchery/integration/jei/wrapper/RitualJeiRecipe;", "guiHelper", "Lmezz/jei/api/helpers/IJeiHelpers;", "<init>", "(Lmezz/jei/api/helpers/IJeiHelpers;)V", "getGuiHelper", "()Lmezz/jei/api/helpers/IJeiHelpers;", "setGuiHelper", "getRecipeType", "Lmezz/jei/api/recipe/RecipeType;", "getTitle", "Lnet/minecraft/network/chat/Component;", "getBackground", "Lmezz/jei/api/gui/drawable/IDrawable;", "getIcon", "setRecipe", "", "builder", "Lmezz/jei/api/gui/builder/IRecipeLayoutBuilder;", "recipe", "focuses", "Lmezz/jei/api/recipe/IFocusGroup;", "getTooltip", "tooltip", "Lmezz/jei/api/gui/builder/ITooltipBuilder;", "recipeSlotsView", "Lmezz/jei/api/gui/ingredient/IRecipeSlotsView;", "mouseX", "", "mouseY", "draw", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "drawCirclePattern", "pattern", "", "", "blockMapping", "", "", "Lnet/minecraft/world/level/block/Block;", "squareX", "", "squareY", "squareSize", "drawChalk", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "x", "y", "texturePath", "color", "(Lcom/mojang/blaze3d/vertex/PoseStack;IILjava/lang/String;Ljava/lang/Integer;)V", "drawCelestial", "type", "enabled", "", "witchery"})
@SourceDebugExtension(value={"SMAP\nRitualJeiRecipeCategory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RitualJeiRecipeCategory.kt\ndev/sterner/witchery/integration/jei/RitualJeiRecipeCategory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,418:1\n1878#2,3:419\n1878#2,3:422\n*S KotlinDebug\n*F\n+ 1 RitualJeiRecipeCategory.kt\ndev/sterner/witchery/integration/jei/RitualJeiRecipeCategory\n*L\n55#1:419,3\n66#1:422,3\n*E\n"})
public final class RitualJeiRecipeCategory
implements IRecipeCategory<RitualJeiRecipe> {
    @NotNull
    private IJeiHelpers guiHelper;

    public RitualJeiRecipeCategory(@NotNull IJeiHelpers guiHelper) {
        Intrinsics.checkNotNullParameter((Object)guiHelper, (String)"guiHelper");
        this.guiHelper = guiHelper;
    }

    @NotNull
    public final IJeiHelpers getGuiHelper() {
        return this.guiHelper;
    }

    public final void setGuiHelper(@NotNull IJeiHelpers iJeiHelpers) {
        Intrinsics.checkNotNullParameter((Object)iJeiHelpers, (String)"<set-?>");
        this.guiHelper = iJeiHelpers;
    }

    @NotNull
    public RecipeType<RitualJeiRecipe> getRecipeType() {
        return WitcheryJeiPlugin.Companion.getRITUAL();
    }

    @NotNull
    public Component getTitle() {
        MutableComponent mutableComponent = Component.translatable((String)"witchery.ritual.category");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public IDrawable getBackground() {
        IDrawableStatic iDrawableStatic = this.guiHelper.getGuiHelper().createBlankDrawable(162, 144);
        Intrinsics.checkNotNullExpressionValue((Object)iDrawableStatic, (String)"createBlankDrawable(...)");
        return (IDrawable)iDrawableStatic;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((ChalkItem)((Object)WitcheryItems.INSTANCE.getGOLDEN_CHALK().get())).getDefaultInstance());
    }

    /*
     * WARNING - void declaration
     */
    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull RitualJeiRecipe recipe, @NotNull IFocusGroup focuses) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)focuses, (String)"focuses");
        List<ItemStack> inputItems = recipe.getRecipe().getInputItems();
        List<ItemStack> outputItems = recipe.getRecipe().getOutputItems();
        int itemsPerRow = 6;
        Iterable $this$forEachIndexed$iv = inputItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void stack;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack itemStack = (ItemStack)item$iv;
            int index = n;
            boolean bl = false;
            int row = index / itemsPerRow;
            int col = index % itemsPerRow;
            int x = 9 + col * 18;
            int y = 18 + row * 18 - 4;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStack((ItemStack)stack);
        }
        int outputX = this.getBackground().getWidth() - 18 - 9;
        Iterable $this$forEachIndexed$iv2 = outputItems;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void stack;
            int n;
            if ((n = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack index = (ItemStack)item$iv;
            int index2 = n;
            boolean bl = false;
            int y = this.getBackground().getHeight() - itemsPerRow * 18 - 18 - 4 + index2 * 18;
            builder.addSlot(RecipeIngredientRole.OUTPUT, outputX, y).addItemStack((ItemStack)stack);
        }
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull RitualJeiRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)recipeSlotsView, (String)"recipeSlotsView");
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        Font font = Minecraft.getInstance().font;
        MutableComponent text = Component.translatable((String)(recipe.getId() + ".tooltip"));
        int textWidth = font.width((FormattedText)text);
        int textX = this.getWidth() / 2 - textWidth / 2;
        double d = textX;
        boolean bl = mouseX <= (double)(textX + textWidth) ? d <= mouseX : false;
        if (bl) {
            boolean bl2 = 2.0 <= mouseY ? mouseY <= (double)(2 + font.lineHeight) : false;
            if (bl2) {
                tooltip.add((FormattedText)text);
            }
        }
    }

    public void draw(@NotNull RitualJeiRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        int size;
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)recipeSlotsView, (String)"recipeSlotsView");
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)String.valueOf(recipe.getId())), this.getWidth() / 2, 2, -1);
        if (RitualHelper.INSTANCE.usesCurseCommands(recipe.getRecipe()) && !((Boolean)WitcheryConfig.ENABLE_CURSES.get()).booleanValue()) {
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD};
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.literal((String)"Curses Disabled").withStyle(chatFormattingArray), this.getWidth() / 2, 14, 0xFF0000);
        }
        int squareX = 60;
        int squareY = this.getBackground().getHeight() - 144 + 9;
        int squareSize = 92;
        List<String> pattern = recipe.getRecipe().getPattern();
        Map<Character, Block> blockMapping = recipe.getRecipe().getBlockMapping();
        this.drawCirclePattern(graphics, pattern, blockMapping, squareX, squareY, squareSize);
        Set<RitualRecipe.Celestial> celestial = recipe.getRecipe().getCelestialConditions();
        boolean all = celestial.isEmpty();
        this.drawCelestial(graphics, "sun", celestial.contains((Object)RitualRecipe.Celestial.DAY) || all, 20, 64);
        this.drawCelestial(graphics, "full_moon", celestial.contains((Object)RitualRecipe.Celestial.FULL_MOON) || celestial.contains((Object)RitualRecipe.Celestial.NIGHT) || all, 20, 75);
        this.drawCelestial(graphics, "new_moon", celestial.contains((Object)RitualRecipe.Celestial.NEW_MOON) || celestial.contains((Object)RitualRecipe.Celestial.NIGHT) || all, 20, 86);
        this.drawCelestial(graphics, "waxing_moon", celestial.contains((Object)RitualRecipe.Celestial.WAXING) || celestial.contains((Object)RitualRecipe.Celestial.NIGHT) || all, 9, 81);
        this.drawCelestial(graphics, "waning_moon", celestial.contains((Object)RitualRecipe.Celestial.WANING) || celestial.contains((Object)RitualRecipe.Celestial.NIGHT) || all, 31, 81);
        if (recipe.getRecipe().getRequireCat()) {
            graphics.blit(Witchery.Companion.id("textures/gui/cat.png"), 20, 54, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (recipe.getRecipe().getWeather().contains((Object)RitualRecipe.Weather.RAIN)) {
            graphics.blit(Witchery.Companion.id("textures/gui/weather/rain.png"), 31, 67, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (recipe.getRecipe().getWeather().contains((Object)RitualRecipe.Weather.STORM)) {
            graphics.blit(Witchery.Companion.id("textures/gui/weather/storm.png"), 9, 67, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        int yOffset = this.getBackground().getHeight() - 40;
        if (recipe.getRecipe().getAltarPower() > 0) {
            graphics.drawCenteredString(Minecraft.getInstance().font, "Initial Cost", 24, yOffset, 0xFFFFFF);
            graphics.drawCenteredString(Minecraft.getInstance().font, String.valueOf(recipe.getRecipe().getAltarPower()), 24, yOffset += 10, 16766720);
            yOffset += 12;
        }
        if (recipe.getRecipe().getAltarPowerPerSecond() > 0) {
            graphics.drawCenteredString(Minecraft.getInstance().font, "Per Second", 24, yOffset, 0xFFFFFF);
            graphics.drawCenteredString(Minecraft.getInstance().font, String.valueOf(recipe.getRecipe().getAltarPowerPerSecond()), 24, yOffset += 10, 8900331);
            yOffset += 12;
        }
        if (recipe.getRecipe().getAltarPower() == 0 && recipe.getRecipe().getAltarPowerPerSecond() == 0) {
            graphics.drawCenteredString(Minecraft.getInstance().font, "Power", 24, yOffset, 0xFFFFFF);
            graphics.drawCenteredString(Minecraft.getInstance().font, "0", 24, yOffset += 10, 0xFFFFFF);
            yOffset += 12;
        }
        if ((size = recipe.getRecipe().getCovenCount()) > 0) {
            graphics.drawCenteredString(Minecraft.getInstance().font, "Coven Size: " + size, 24, yOffset, 0xFFFFFF);
        }
        if (!((Collection)recipe.getRecipe().getInputEntities()).isEmpty()) {
            Minecraft minecraft = Minecraft.getInstance();
            int entityX = this.getBackground().getWidth() / 2;
            int entityY = this.getBackground().getHeight() / 2;
            Iterator iterator = ((Iterable)recipe.getRecipe().getInputEntities()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                LivingEntity entity;
                ++n;
                EntityType entityType = (EntityType)iterator.next();
                Entity entity2 = entityType.create((Level)minecraft.level);
                if ((entity2 instanceof LivingEntity ? (LivingEntity)entity2 : null) == null) {
                    return;
                }
                entity = entity;
                double entityHeight = entity.getBoundingBox().getYsize() * (double)4;
                double entityWidth = entity.getBoundingBox().getXsize() * (double)4;
                int baseScale = entityHeight > 2.0 ? 15 : (entityHeight > 1.0 ? 25 : 30);
                float widthAdjustment = entityWidth > 1.0 ? 0.8f : 1.0f;
                float scale = (float)baseScale * widthAdjustment;
                float yOffset2 = entityHeight <= 1.0 ? 0.0f : -8.0f;
                RenderUtils.INSTANCE.renderEntityInInventoryFollowsMouse(graphics, entityX - 20, entityY + 20, entityX + 20, entityY - 20, (int)scale, yOffset2 + (float)9, (float)mouseX, (float)mouseY, entity);
                MutableComponent entityName = Component.translatable((String)entityType.getDescriptionId());
                int textWidth = minecraft.font.width((FormattedText)entityName);
                graphics.drawString(minecraft.font, (Component)entityName, entityX - textWidth / 2, entityY + 30, 0xFFFFFF);
            }
        }
    }

    private final void drawCirclePattern(GuiGraphics graphics, List<String> pattern, Map<Character, ? extends Block> blockMapping, int squareX, int squareY, int squareSize) {
        if (pattern.isEmpty()) {
            return;
        }
        int patternSize = pattern.size();
        int itemSize = 16;
        float scale = 7.0f / (float)patternSize;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int centerX = squareX + squareSize / 2;
        int centerY = squareY + squareSize / 2;
        float halfPatternPx = (float)(patternSize * itemSize) / 2.0f;
        double yOffsetCorrection = (double)(patternSize - 7) * 2.5;
        poseStack.translate((double)((float)centerX - halfPatternPx * scale), (double)((float)centerY - halfPatternPx * scale) + yOffsetCorrection, 0.0);
        poseStack.scale(scale, scale, scale);
        int n = ((Collection)pattern).size();
        for (int y = 0; y < n; ++y) {
            String row = pattern.get(y);
            int n2 = ((CharSequence)row).length();
            for (int x = 0; x < n2; ++x) {
                Block block;
                char c = row.charAt(x);
                if (blockMapping.get(Character.valueOf(c)) == null) continue;
                ItemStack stack = block.asItem().getDefaultInstance();
                int px = x * itemSize;
                int py = y * itemSize;
                if (stack.is((Item)WitcheryItems.INSTANCE.getGOLDEN_CHALK().get())) {
                    Intrinsics.checkNotNull((Object)poseStack);
                    this.drawChalk(poseStack, px, py, "textures/block/golden_chalk.png", null);
                    continue;
                }
                if (stack.is((Item)WitcheryItems.INSTANCE.getRITUAL_CHALK().get())) {
                    Intrinsics.checkNotNull((Object)poseStack);
                    this.drawChalk(poseStack, px, py, "textures/block/chalk_" + (y + x) % 15 + ".png", null);
                    continue;
                }
                if (stack.is((Item)WitcheryItems.INSTANCE.getOTHERWHERE_CHALK().get())) {
                    Intrinsics.checkNotNull((Object)poseStack);
                    this.drawChalk(poseStack, px, py, "textures/block/chalk_" + (y + x) % 15 + ".png", new Color(190, 55, 250).getRGB());
                    continue;
                }
                if (stack.is((Item)WitcheryItems.INSTANCE.getINFERNAL_CHALK().get())) {
                    Intrinsics.checkNotNull((Object)poseStack);
                    this.drawChalk(poseStack, px, py, "textures/block/chalk_" + (y + x) % 15 + ".png", new Color(230, 0, 75).getRGB());
                    continue;
                }
                graphics.renderItem(stack, px, py);
            }
        }
        poseStack.popPose();
    }

    private final void drawChalk(PoseStack poseStack, int x, int y, String texturePath, Integer color) {
        poseStack.pushPose();
        poseStack.translate((double)x, (double)y, 0.0);
        if (color != null) {
            ResourceLocation resourceLocation = Witchery.Companion.id(texturePath);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            RenderUtils.INSTANCE.renderChalk(poseStack, 0, 0, resourceLocation, color);
        } else {
            ResourceLocation resourceLocation = Witchery.Companion.id(texturePath);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            RenderUtils.INSTANCE.renderChalk(poseStack, 0, 0, resourceLocation);
        }
        poseStack.popPose();
    }

    private final void drawCelestial(GuiGraphics graphics, String type, boolean enabled, int x, int y) {
        String tex = enabled ? type : "empty";
        graphics.blit(Witchery.Companion.id("textures/gui/celestial/" + tex + ".png"), x, y, 0.0f, 0.0f, 10, 10, 10, 10);
    }
}

