/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.mixin.CompositeEntryBaseAccessor;
import dev.sterner.witchery.mixin.LootPoolAccessor;
import dev.sterner.witchery.mixin.LootPoolSingletonContainerAccessor;
import dev.sterner.witchery.mixin.LootTableAccessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public class BlockMixin {
    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private static void witchery$injectExtraFortune(BlockState state, Level level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, ItemStack tool, CallbackInfo ci) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (entity instanceof Player) break block7;
            }
            return;
        }
        Player player = (Player)entity;
        MobEffectInstance effect = player.getEffect(WitcheryMobEffects.INSTANCE.getFORTUNE_TOOL());
        if (effect == null) {
            return;
        }
        ResourceKey lootTableId = state.getBlock().getLootTable();
        LootTable table = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableId);
        if (BlockMixin.witchery$supportsFortune(table)) {
            List extraDrops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)tool);
            int fortuneLevel = effect.getAmplifier() + 1;
            for (ItemStack stack : extraDrops) {
                ItemStack bonus = BlockMixin.witchery$applyFortuneEffect(stack.copy(), fortuneLevel, serverLevel.random);
                if (bonus.isEmpty()) continue;
                Block.popResource((Level)serverLevel, (BlockPos)pos, (ItemStack)bonus);
            }
        }
    }

    @Unique
    private static boolean witchery$supportsFortune(LootTable lootTable) {
        for (LootPool pool : ((LootTableAccessor)lootTable).getPools()) {
            for (LootPoolEntryContainer entry : ((LootPoolAccessor)pool).getEntries()) {
                CompositeEntryBase composite;
                if (entry instanceof LootItem) {
                    LootItem lootItem = (LootItem)entry;
                    for (LootItemFunction function : ((LootPoolSingletonContainerAccessor)lootItem).getFunctions()) {
                        if (!BlockMixin.witchery$isFortuneFunction(function)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(entry instanceof CompositeEntryBase) || !BlockMixin.witchery$checkCompositeForFortune(composite = (CompositeEntryBase)entry)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private static boolean witchery$checkCompositeForFortune(CompositeEntryBase composite) {
        for (LootPoolEntryContainer child : ((CompositeEntryBaseAccessor)composite).getChildren()) {
            CompositeEntryBase deeperComposite;
            if (child instanceof LootPoolSingletonContainer) {
                LootPoolSingletonContainer lootItem = (LootPoolSingletonContainer)child;
                for (LootItemFunction function : ((LootPoolSingletonContainerAccessor)lootItem).getFunctions()) {
                    if (!BlockMixin.witchery$isFortuneFunction(function)) continue;
                    return true;
                }
                continue;
            }
            if (!(child instanceof CompositeEntryBase) || !BlockMixin.witchery$checkCompositeForFortune(deeperComposite = (CompositeEntryBase)child)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static boolean witchery$isFortuneFunction(LootItemFunction function) {
        return function instanceof ApplyBonusCount;
    }

    @Unique
    private static ItemStack witchery$applyFortuneEffect(ItemStack drop, int fortuneLevel, RandomSource random) {
        if (drop.isEmpty() || fortuneLevel <= 0) {
            return ItemStack.EMPTY;
        }
        int extra = 0;
        for (int i = 0; i < fortuneLevel; ++i) {
            if (!(random.nextFloat() < 0.5f)) continue;
            ++extra;
        }
        if (extra > 0) {
            drop.grow(extra);
            return drop;
        }
        return ItemStack.EMPTY;
    }
}

