/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import dev.sterner.witchery.content.entity.ChainEntity;
import dev.sterner.witchery.core.api.interfaces.EntityChainInterface;
import dev.sterner.witchery.core.api.interfaces.OnRemovedEffect;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.death.DeathPlayerAttachment;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.features.necromancy.NecroHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements EntityChainInterface {
    @Unique
    private final List<Pair<ChainEntity, Boolean>> witchery$restrainingChains = new ArrayList<Pair<ChainEntity, Boolean>>();
    @Unique
    private boolean witchery$restrained = false;

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventMovement(Vec3 travelVector, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(WitcheryMobEffects.INSTANCE.getBEAR_TRAP_INCAPACITATED())) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            ci.cancel();
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")})
    private void witchery$preventKnockback(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(WitcheryMobEffects.INSTANCE.getBEAR_TRAP_INCAPACITATED())) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.0, 1.0, 0.0));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$deathBootsLavaImmunity(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player && DeathTransformationHelper.INSTANCE.hasDeathBoots(player = (Player)entity) && DeathPlayerAttachment.getData(player).getHasDeathFluidWalking() && source.is(DamageTypes.LAVA)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"decreaseAirSupply"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$deathBootsUnderwaterBreathing(int air, CallbackInfoReturnable<Integer> cir) {
        Player player;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player && DeathTransformationHelper.INSTANCE.isDeath(player = (Player)entity)) {
            cir.setReturnValue((Object)air);
        }
    }

    @Inject(method={"increaseAirSupply"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$deathBootsMaxAirSupply(int air, CallbackInfoReturnable<Integer> cir) {
        Player player;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player && DeathTransformationHelper.INSTANCE.isDeath(player = (Player)entity)) {
            cir.setReturnValue((Object)entity.getMaxAirSupply());
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$deathRobeFireProtection(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player && DeathTransformationHelper.INSTANCE.hasDeathRobe(player = (Player)entity) && (source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypes.LAVA) || source.is(DamageTypes.HOT_FLOOR) || source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE))) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventSwingForAbility(CallbackInfo ci) {
        Player player;
        LivingEntity self = (LivingEntity)this;
        if (self instanceof Player && AfflictionAbilityHandler.INSTANCE.getSelectedAbility(player = (Player)self) != null) {
            ci.cancel();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void witchery$modifyBaseTick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)LivingEntity.class.cast(this);
        BloodPoolHandler.INSTANCE.tickBloodRegen(livingEntity);
        NecroHandler.INSTANCE.tickLiving(livingEntity);
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD")})
    private void witchery$onEffectRemoved(CallbackInfo ci, @Local(argsOnly=true) MobEffectInstance instance) {
        LivingEntity livingEntity = (LivingEntity)LivingEntity.class.cast(this);
        Object object = instance.getEffect().value();
        if (object instanceof OnRemovedEffect) {
            OnRemovedEffect removedEffect = (OnRemovedEffect)object;
            removedEffect.onRemovedEffect(livingEntity);
        }
    }

    @Override
    public void witchery$restrainMovement(@NotNull ChainEntity chainEntity, boolean totalRestrict) {
        this.witchery$restrainingChains.removeIf(pair -> ((ChainEntity)((Object)((Object)pair.getFirst()))).equals((Object)chainEntity));
        this.witchery$restrainingChains.add((Pair<ChainEntity, Boolean>)Pair.of((Object)((Object)chainEntity), (Object)totalRestrict));
        this.witchery$restrained = true;
    }

    @Override
    public boolean witchery$isRestrained() {
        this.witchery$restrainingChains.removeIf(pair -> ((ChainEntity)((Object)((Object)pair.getFirst()))).isRemoved());
        this.witchery$restrained = !this.witchery$restrainingChains.isEmpty();
        return this.witchery$restrained;
    }

    @Override
    @NotNull
    public List<ChainEntity> witchery$getRestrainingChains() {
        this.witchery$restrainingChains.removeIf(pair -> ((ChainEntity)((Object)((Object)pair.getFirst()))).isRemoved());
        return this.witchery$restrainingChains.stream().map(Pair::getFirst).toList();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void witchery$onTick(CallbackInfo ci) {
        LivingEntity self;
        if (this.witchery$isRestrained() && (self = (LivingEntity)this) instanceof Mob) {
            Mob mob = (Mob)self;
            mob.getNavigation().stop();
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$onTravel(Vec3 travelVector, CallbackInfo ci) {
        if (this.witchery$isRestrained()) {
            LivingEntity self = (LivingEntity)this;
            self.walkAnimation.setSpeed(0.0f);
            self.walkAnimation.update(0.0f, 0.0f);
            if (self instanceof Mob) {
                Mob mob = (Mob)self;
                mob.getNavigation().stop();
            }
            if (this.witchery$restrainingChains.stream().anyMatch(Pair::getSecond)) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void witchery$restrainMotion(CallbackInfo ci) {
        if (this.witchery$isRestrained()) {
            LivingEntity self = (LivingEntity)this;
            self.zza = 0.0f;
            self.xxa = 0.0f;
            self.yya = 0.0f;
            self.setJumping(false);
        }
    }

    @ModifyReturnValue(method={"shouldDropLoot"}, at={@At(value="RETURN")})
    private boolean witchery$shouldDropLoot(boolean original) {
        LivingEntity self = (LivingEntity)this;
        if (self.getType().is(WitcheryTags.INSTANCE.getNECROMANCER_SUMMONABLE())) {
            return original && EtherealEntityAttachment.getData(self).getCanDropLoot();
        }
        return original;
    }

    @ModifyVariable(method={"getDamageAfterArmorAbsorb"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float witchery$bypassArmor(float damage, DamageSource source) {
        Player player;
        AfflictionPlayerAttachment.Data data2;
        Entity entity = source.getEntity();
        if (entity instanceof Player && (data2 = AfflictionPlayerAttachment.getData(player = (Player)entity)).getWerewolfLevel() >= 9 && (TransformationHandler.isWolf(player) || TransformationHandler.isWerewolf(player))) {
            return damage;
        }
        return damage;
    }
}

