/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MeleeAttackGoal.class})
public class MeleeAttackGoalMixin {
    @Shadow
    @Final
    protected PathfinderMob mob;

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventAttackingOwner(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        if (this.mob instanceof Zombie && (livingEntity = this.mob.getTarget()) instanceof Player) {
            Player owner;
            Player player = (Player)livingEntity;
            EtherealEntityAttachment.Data etherealData = EtherealEntityAttachment.getData((LivingEntity)this.mob);
            if (etherealData.getOwnerUUID() != null && etherealData.getOwnerUUID().equals(player.getUUID())) {
                cir.setReturnValue((Object)false);
            }
            if (AfflictionPlayerAttachment.getData(player).getLichLevel() > 0 && etherealData.getOwnerUUID() != null && (owner = this.mob.level().getPlayerByUUID(etherealData.getOwnerUUID())) != null && AfflictionPlayerAttachment.getData(owner).getLichLevel() > 0) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

