/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.sterner.witchery.features.petrification.PetrifiedEntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class PetrifiedLivingMixin {
    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventMovement(Vec3 travelVector, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData(entity);
        if (data2.isPetrified()) {
            ci.cancel();
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventJumping(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData(entity);
        if (data2.isPetrified()) {
            ci.cancel();
        }
    }

    @Inject(method={"setSprinting"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventSprinting(boolean sprinting, CallbackInfo ci) {
        if (!sprinting) {
            return;
        }
        LivingEntity entity = (LivingEntity)this;
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData(entity);
        if (data2.isPetrified()) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"knockback"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(DDD)V")})
    private void witchery$reduceKnockback(LivingEntity instance, double x, double y, double z, Operation<Void> original) {
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData(instance);
        if (data2.isPetrified()) {
            original.call(new Object[]{instance, 0.0, 0.0, 0.0});
        } else {
            original.call(new Object[]{instance, x, y, z});
        }
    }

    @Inject(method={"tickHeadTurn"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventTurning(float yRot, float animStep, CallbackInfoReturnable<Float> cir) {
        LivingEntity entity = (LivingEntity)this;
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData(entity);
        if (data2.isPetrified()) {
            cir.cancel();
        }
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventAttacking(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData(entity);
        if (data2.isPetrified()) {
            cir.setReturnValue((Object)false);
        }
    }
}

