/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.features.petrification.PetrifiedEntityAttachment;
import java.util.UUID;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TargetGoal.class})
public abstract class TargetGoalMixin {
    @Shadow
    @Final
    protected Mob mob;

    @Inject(method={"canAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$dontAttackSummonerOwner(LivingEntity potentialTarget, TargetingConditions targetPredicate, CallbackInfoReturnable<Boolean> cir) {
        UUID uuid;
        if (potentialTarget == null) {
            return;
        }
        if (PetrifiedEntityAttachment.INSTANCE.getData(potentialTarget).isPetrified()) {
            cir.setReturnValue((Object)false);
        }
        if (this.mob.getType().is(WitcheryTags.INSTANCE.getNECROMANCER_SUMMONABLE()) && (uuid = EtherealEntityAttachment.getData((LivingEntity)this.mob).getOwnerUUID()) != null && potentialTarget.getUUID().equals(uuid)) {
            cir.setReturnValue((Object)false);
        }
        if (this.mob.getType().is(EntityTypeTags.UNDEAD) && potentialTarget instanceof Player) {
            boolean bl;
            Player player = (Player)potentialTarget;
            boolean bl2 = bl = AfflictionPlayerAttachment.getData(player).getVampireLevel() > 0;
            if (bl) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

