/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.core.api.interfaces.VillagerTransfix;
import dev.sterner.witchery.network.SpawnTransfixParticlesS2CPayload;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public class VillagerMixin
implements VillagerTransfix {
    @Unique
    int witchery$transfixCounter = 0;
    @Unique
    Vec3 witchery$transfixVector = null;
    @Unique
    UUID witchery$mesmerisedUUID = null;
    @Unique
    int witchery$mesmerisedUUIDCounter = 0;

    @Override
    public void setTransfixedLookVector(@NotNull Vec3 vec3) {
        this.witchery$transfixVector = vec3;
        this.witchery$transfixCounter = 200;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void witchery$onTick(CallbackInfo ci) {
        Villager villager = (Villager)Villager.class.cast(this);
        if (!villager.level().isClientSide) {
            if (this.witchery$transfixCounter > 0) {
                if (this.witchery$mesmerisedUUIDCounter <= 0) {
                    villager.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                    villager.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
                }
                villager.getLookControl().setLookAt(this.witchery$transfixVector);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)villager, (CustomPacketPayload)new SpawnTransfixParticlesS2CPayload(villager.position(), this.witchery$transfixCounter < 20), (CustomPacketPayload[])new CustomPacketPayload[0]);
                --this.witchery$transfixCounter;
            } else {
                this.witchery$transfixVector = null;
            }
            if (this.witchery$mesmerisedUUIDCounter > 0) {
                Player player = villager.level().getPlayerByUUID(this.witchery$getMesmerized());
                if (player != null) {
                    villager.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(player.position(), 1.0f, 2));
                }
                --this.witchery$mesmerisedUUIDCounter;
            } else {
                this.witchery$mesmerisedUUID = null;
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void witchery$addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.putInt("WitcheryTransfixCounter", this.witchery$transfixCounter);
        compoundTag.putInt("WitcheryMesmerisedUUIDCounter", this.witchery$mesmerisedUUIDCounter);
        if (this.witchery$transfixVector != null) {
            compoundTag.putDouble("WitcheryTransfixVectorX", this.witchery$transfixVector.x);
            compoundTag.putDouble("WitcheryTransfixVectorY", this.witchery$transfixVector.y);
            compoundTag.putDouble("WitcheryTransfixVectorZ", this.witchery$transfixVector.z);
        }
        if (this.witchery$mesmerisedUUID != null) {
            compoundTag.putUUID("WitcheryMesmerisedUUID", this.witchery$mesmerisedUUID);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void witchery$readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.witchery$transfixCounter = compoundTag.getInt("WitcheryTransfixCounter");
        this.witchery$mesmerisedUUIDCounter = compoundTag.getInt("WitcheryMesmerisedUUIDCounter");
        if (compoundTag.contains("WitcheryTransfixVectorX")) {
            this.witchery$transfixVector = new Vec3(compoundTag.getDouble("WitcheryTransfixVectorX"), compoundTag.getDouble("WitcheryTransfixVectorY"), compoundTag.getDouble("WitcheryTransfixVectorZ"));
        }
        if (compoundTag.contains("WitcheryMesmerisedUUID")) {
            this.witchery$mesmerisedUUID = compoundTag.getUUID("WitcheryMesmerisedUUID");
        }
    }

    @Override
    public boolean witchery$isTransfixed() {
        return this.witchery$transfixCounter > 0;
    }

    @Override
    public void witchery$setMesmerized(@NotNull UUID uuid) {
        this.witchery$mesmerisedUUID = uuid;
        this.witchery$mesmerisedUUIDCounter = 400;
    }

    @Override
    public boolean witchery$isMesmerized() {
        return this.witchery$mesmerisedUUID != null;
    }

    @Override
    @NotNull
    public UUID witchery$getMesmerized() {
        return this.witchery$mesmerisedUUID;
    }
}

