/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Monster {
    protected ZombieMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventOwnerDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            EtherealEntityAttachment.Data etherealData = EtherealEntityAttachment.getData((LivingEntity)this);
            if (etherealData.getOwnerUUID() != null && etherealData.getOwnerUUID().equals(player.getUUID())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    public boolean canAttack(LivingEntity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            EtherealEntityAttachment.Data etherealData = EtherealEntityAttachment.getData((LivingEntity)this);
            if (etherealData.getOwnerUUID() != null && etherealData.getOwnerUUID().equals(player.getUUID())) {
                return false;
            }
        }
        return super.canAttack(target);
    }
}

