/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.features.petrification.PetrificationTextureManager;
import dev.sterner.witchery.features.petrification.PetrifiedEntityAttachment;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererPetrifiedMixin<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    protected LivingEntityRendererPetrifiedMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @WrapOperation(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V")})
    public <E extends Entity> void witchery$fixPetrifiedPose(EntityModel<E> instance, E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch, Operation<Void> original) {
        LivingEntity livingEntity;
        PetrifiedEntityAttachment.Data data2;
        if (entity instanceof LivingEntity && (data2 = PetrifiedEntityAttachment.INSTANCE.getData(livingEntity = (LivingEntity)entity)).isPetrified()) {
            original.call(new Object[]{instance, entity, Float.valueOf(data2.getLimbSwing()), Float.valueOf(data2.getLimbSwingAmount()), Float.valueOf(data2.getAge()), Float.valueOf(data2.getHeadYaw()), Float.valueOf(data2.getHeadPitch())});
            return;
        }
        original.call(new Object[]{instance, entity, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(headYaw), Float.valueOf(headPitch)});
    }

    @WrapOperation(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;prepareMobModel(Lnet/minecraft/world/entity/Entity;FFF)V")})
    public <E extends Entity> void witchery$fixPrepModel(EntityModel<E> instance, E entity, float limbSwing, float limbSwingAmount, float partialTick, Operation<Void> original) {
        LivingEntity livingEntity;
        PetrifiedEntityAttachment.Data data2;
        if (entity instanceof LivingEntity && (data2 = PetrifiedEntityAttachment.INSTANCE.getData(livingEntity = (LivingEntity)entity)).isPetrified()) {
            original.call(new Object[]{instance, entity, Float.valueOf(data2.getLimbSwing()), Float.valueOf(data2.getLimbSwingAmount()), Float.valueOf(partialTick)});
            return;
        }
        original.call(new Object[]{instance, entity, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(partialTick)});
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V", shift=At.Shift.AFTER)})
    private void witchery$renderBreakOverlay(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData((LivingEntity)entity);
        if (!data2.isPetrified() || data2.getBreakProgress() == 0) {
            return;
        }
        ResourceLocation baseTexture = this.getTextureLocation((Entity)entity);
        PetrificationTextureManager.Size size = PetrificationTextureManager.INSTANCE.getTextureSize(baseTexture);
        ResourceLocation breakTexture = LivingEntityRendererPetrifiedMixin.witchery$getBreak(size, data2);
        EntityModel model = ((LivingEntityRenderer)this).getModel();
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)breakTexture));
        model.renderToBuffer(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f), -1);
    }

    @Unique
    private static ResourceLocation witchery$getBreak(PetrificationTextureManager.Size size, PetrifiedEntityAttachment.Data data2) {
        float texW = size.getWidth();
        float texH = size.getHeight();
        float aspect = texW / texH;
        int breakStage = data2.getBreakStage();
        ResourceLocation breakTexture = (double)aspect >= 2.0 ? Witchery.Companion.id("textures/block/break/destroy_stage_" + breakStage + "_64x32.png") : Witchery.Companion.id("textures/block/break/destroy_stage_" + breakStage + ".png");
        return breakTexture;
    }
}

