/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.core.api.event.PossessionEvents;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Shadow
    public Camera camera;
    @Unique
    @Nullable
    private Entity witchery$camerasPossessed;

    @Inject(method={"prepare"}, at={@At(value="HEAD")})
    private void witchery$prepare(Level level, Camera activeRenderInfo, Entity entity, CallbackInfo ci) {
        Minecraft client = Minecraft.getInstance();
        Entity camera = client.getCameraEntity();
        if (camera instanceof Player) {
            Player player = (Player)camera;
            this.witchery$camerasPossessed = PossessionComponentAttachment.INSTANCE.get(player).getHost();
        }
    }

    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$shouldRender(Entity entity, Frustum visibleRegion, double x, double y, double z, CallbackInfoReturnable<Boolean> info) {
        if (this.witchery$camerasPossessed == entity) {
            PossessionEvents.AllowRender event = new PossessionEvents.AllowRender(entity);
            NeoForge.EVENT_BUS.post((Event)event);
            if (this.camera.isDetached() || !event.isCanceled()) {
                info.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"renderShadow"}, at={@At(value="HEAD")}, cancellable=true)
    private static void witchery$renderShadow(PoseStack matrices, MultiBufferSource vertices, Entity rendered, float distance, float tickDelta, LevelReader world, float radius, CallbackInfo ci) {
        Player player;
        if (rendered instanceof Player && AfflictionPlayerAttachment.getData(player = (Player)rendered).isVagrant()) {
            ci.cancel();
        }
    }
}

