/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession.possessed;

import dev.sterner.witchery.core.api.interfaces.Possessable;
import dev.sterner.witchery.core.api.interfaces.ProtoPossessable;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class PossessableEntityMixin
implements ProtoPossessable {
    @Shadow
    private Level level;
    @Shadow
    public boolean hasImpulse;
    @Unique
    @Nullable
    private Player witchery$possessor;

    @Override
    public boolean isBeingPossessed() {
        return this instanceof Possessable && this.witchery$possessor != null;
    }

    @Override
    @Nullable
    public Player getPossessor() {
        if (!this.isBeingPossessed()) {
            return null;
        }
        if (this.witchery$possessor != null && this.witchery$possessor.isRemoved()) {
            this.witchery$possessor = null;
        }
        return this.witchery$possessor;
    }

    @ApiStatus.Internal
    public void setPossessor(@Nullable Player possessor) {
        this.witchery$possessor = possessor;
    }

    @Inject(method={"markHurt"}, at={@At(value="RETURN")})
    private void witchery$markHurt(CallbackInfo ci) {
        Player player = this.getPossessor();
        if (player != null && !this.level.isClientSide && this.hasImpulse) {
            player.hasImpulse = true;
        }
    }

    @Inject(method={"isControlledByLocalInstance"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$isControlledByLocalInstance(CallbackInfoReturnable<Boolean> cir) {
        if (this.isBeingPossessed()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$isInvulnerableTo(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Player player = this.getPossessor();
        if (player != null && player.isCreative()) {
            cir.setReturnValue((Object)(!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) ? 1 : 0));
        }
    }

    @Inject(method={"canUsePortal"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$canUsePortal(boolean allowPassengers, CallbackInfoReturnable<Boolean> cir) {
        if (this.isBeingPossessed()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$startRiding(Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> cir) {
        Player player = this.getPossessor();
        if (player != null) {
            cir.setReturnValue((Object)player.startRiding(vehicle, force));
        }
    }

    @Inject(method={"refreshDimensions"}, at={@At(value="RETURN")})
    private void witchery$refreshDimensions(CallbackInfo ci) {
        Player possessor = this.getPossessor();
        if (possessor != null) {
            possessor.refreshDimensions();
        }
    }

    @Inject(method={"saveAsPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$saveAsPassenger(CompoundTag tag, CallbackInfoReturnable<Boolean> cir) {
        if (this.isBeingPossessed()) {
            cir.setReturnValue((Object)false);
        }
    }
}

