/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession.possessed;

import dev.sterner.witchery.content.entity.player_shell.SoulShellPlayerEntity;
import dev.sterner.witchery.core.api.interfaces.Possessable;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.possession.EntityAiToggle;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function1;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class PossessableLivingEntityMixin
extends Entity
implements Possessable {
    @Unique
    private final boolean witchery$regularEater = this.getType().is(WitcheryTags.INSTANCE.getREGULAR_EATER());
    @Shadow
    public float yHeadRot;
    @Shadow
    public float yBodyRot;
    @Nullable
    private Player possessor;

    @Shadow
    public abstract float getHealth();

    @Shadow
    public abstract float getAbsorptionAmount();

    @Shadow
    public abstract boolean isUsingItem();

    @Shadow
    @Nullable
    public abstract AttributeInstance getAttribute(Holder<Attribute> var1);

    public PossessableLivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public boolean isBeingPossessed() {
        return this.possessor != null;
    }

    @Override
    @Nullable
    public Player getPossessor() {
        if (this.possessor != null && this.possessor.isRemoved()) {
            PossessionComponentAttachment.INSTANCE.get(this.possessor).stopPossessing(!this.possessor.isCreative());
            this.setPossessor(null);
        }
        return this.possessor;
    }

    @Override
    public boolean canBePossessedBy(Player player) {
        return !this.isRemoved() && this.getHealth() > 0.0f && (this.possessor == null || this.possessor.getUUID().equals(player.getUUID()));
    }

    @Override
    public void setPossessor(@Nullable Player possessor) {
        AttributeInstance speedAttribute;
        if (possessor == this.possessor) {
            return;
        }
        LivingEntity self = (LivingEntity)this;
        if (this.possessor != null && PossessionComponentAttachment.INSTANCE.get(this.possessor).getHost() == self && !this.level().isClientSide) {
            throw new IllegalStateException("Players must stop possessing an entity before it can change possessor!");
        }
        if (possessor == null) {
            assert (this.possessor != null);
            this.fallDistance = this.possessor.fallDistance;
            this.setShiftKeyDown(false);
        }
        this.possessor = possessor;
        if (!this.level().isClientSide) {
            EntityAiToggle.toggleAi(self, EntityAiToggle.INSTANCE.getPOSSESSION_MECHANISM_ID(), this.possessor != null, false);
        }
        if ((speedAttribute = this.getAttribute((Holder<Attribute>)Attributes.MOVEMENT_SPEED)) != null && speedAttribute.hasModifier(PossessionComponentAttachment.INSTANCE.getINHERENT_MOB_SLOWNESS_UUID())) {
            speedAttribute.removeModifier(PossessionComponentAttachment.INSTANCE.getINHERENT_MOB_SLOWNESS_UUID());
            if (possessor != null) {
                speedAttribute.addTransientModifier(PossessionComponentAttachment.INSTANCE.getINHERENT_MOB_SLOWNESS());
            }
        }
        this.onPossessorSet(possessor);
    }

    @Override
    public boolean isRegularEater() {
        return this.witchery$regularEater;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isImmobile()Z", ordinal=0)})
    private void witchery$aiStep(CallbackInfo ci) {
        if (this.isBeingPossessed() && !this.level().isClientSide) {
            this.witchery$aiStep();
        }
    }

    @Unique
    protected void witchery$aiStep() {
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void witchery$tick(CallbackInfo ci) {
        Player player = this.getPossessor();
        if (player != null) {
            if (!this.level().isClientSide) {
                player.setAbsorptionAmount(this.getAbsorptionAmount());
            }
            this.setOnGround(player.onGround());
            this.setShiftKeyDown(player.isShiftKeyDown());
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V", shift=At.Shift.AFTER)})
    private void witchery$aiStep2(CallbackInfo ci) {
        Player player = this.getPossessor();
        if (player != null) {
            this.setYRot(player.getYRot());
            this.setXRot(player.getXRot());
            this.yBodyRot = this.yHeadRot = (this.yRotO = this.getYRot());
            this.setSwimming(player.isSwimming());
            this.fallDistance = 0.0f;
            this.setDeltaMovement(player.getDeltaMovement());
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setPos(player.getX(), player.getY(), player.getZ());
            this.horizontalCollision = player.horizontalCollision;
            this.verticalCollision = player.verticalCollision;
        }
    }

    @Inject(method={"doPush", "push"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$doPush(Entity entity, CallbackInfo ci) {
        if (entity == this.getPossessor()) {
            ci.cancel();
            return;
        }
        LivingEntity self = (LivingEntity)this;
        if (entity instanceof Possessable && ((Possessable)entity).getPossessor() == self) {
            ci.cancel();
        }
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void witchery$die(DamageSource damageSource, CallbackInfo ci) {
        ServerPlayer possessor = (ServerPlayer)this.getPossessor();
        if (possessor != null) {
            PossessionComponentAttachment.PossessionComponent component = PossessionComponentAttachment.INSTANCE.get((Player)possessor);
            component.stopPossessing(!possessor.isCreative());
            AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)possessor);
            if (data2.getLichLevel() > 0) {
                AfflictionPlayerAttachment.INSTANCE.smartUpdate((Player)possessor, true, (Function1<? super AfflictionPlayerAttachment.Data, AfflictionPlayerAttachment.Data>)((Function1)currentData -> currentData.withSoulForm(true).withVagrant(false)));
                SoulShellPlayerEntity.Companion.enableFlight(possessor);
                possessor.getAbilities().flying = true;
                possessor.onUpdateAbilities();
                Vec3 velocity = possessor.getDeltaMovement();
                possessor.setDeltaMovement(velocity.x, velocity.y + 0.3, velocity.z);
                possessor.hurtMarked = true;
            }
        }
    }

    @Inject(method={"updatingUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$updateUsingItem(CallbackInfo ci) {
        if (this.isBeingPossessed()) {
            ci.cancel();
        }
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="RETURN")})
    private void witchery$onEffectAdded(MobEffectInstance effectInstance, Entity entity, CallbackInfo ci) {
        Player possessor = this.getPossessor();
        if (possessor instanceof ServerPlayer) {
            possessor.addEffect(new MobEffectInstance(effectInstance));
        }
    }

    @Inject(method={"onEffectUpdated"}, at={@At(value="RETURN")})
    private void witchery$onEffectUpdated(MobEffectInstance effectInstance, boolean reapplyEffect, Entity entity, CallbackInfo ci) {
        Player possessor;
        if (reapplyEffect && (possessor = this.getPossessor()) instanceof ServerPlayer) {
            possessor.addEffect(new MobEffectInstance(effectInstance));
        }
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="RETURN")})
    private void witchery$onEffectRemoved(MobEffectInstance effectInstance, CallbackInfo ci) {
        Player possessor = this.getPossessor();
        if (possessor instanceof ServerPlayer) {
            possessor.removeEffect(effectInstance.getEffect());
        }
    }

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$knockback(double strength, double x, double z, CallbackInfo ci) {
        Player possessing = this.getPossessor();
        if (possessing != null) {
            possessing.knockback(strength, x, z);
            ci.cancel();
        }
    }

    @Inject(method={"randomTeleport"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$randomTeleport(double x, double y, double z, boolean particleEffects, CallbackInfoReturnable<Boolean> cir) {
        Player player = this.getPossessor();
        if (player != null) {
            cir.setReturnValue((Object)player.randomTeleport(x, y, z, particleEffects));
        }
    }

    @Inject(method={"isFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$isFallFlying(CallbackInfoReturnable<Boolean> cir) {
        Player player = this.getPossessor();
        if (player != null) {
            cir.setReturnValue((Object)player.isFallFlying());
        }
    }

    @Inject(method={"isBlocking"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$isBlocking(CallbackInfoReturnable<Boolean> cir) {
        Player possessor = this.getPossessor();
        if (possessor != null) {
            cir.setReturnValue((Object)possessor.isBlocking());
        }
    }

    @Inject(method={"hurtCurrentlyUsedShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$hurtCurrentlyUsedShield(float damage, CallbackInfo ci) {
        Player possessor = this.getPossessor();
        if (possessor != null && !this.level().isClientSide) {
            possessor.hurtCurrentlyUsedShield(damage);
            this.level().broadcastEntityEvent((Entity)possessor, (byte)29);
            ci.cancel();
        }
    }

    @Inject(method={"getUseItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$getUseItem(CallbackInfoReturnable<ItemStack> cir) {
        Player possessor = this.getPossessor();
        if (possessor != null) {
            cir.setReturnValue((Object)possessor.getUseItem());
        }
    }

    @Inject(method={"isUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$isUsingItem(CallbackInfoReturnable<Boolean> cir) {
        Player possessor = this.getPossessor();
        if (possessor != null) {
            cir.setReturnValue((Object)possessor.isUsingItem());
        }
    }
}

