/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin_logic;

import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/mixin_logic/FoodDataMixinLogic;", "", "<init>", "()V", "getFood", "", "player", "Lnet/minecraft/world/entity/player/Player;", "cir", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;", "", "getSaturation", "", "onAdd", "instance", "foodLevel", "saturationLevel", "witchery"})
public final class FoodDataMixinLogic {
    @NotNull
    public static final FoodDataMixinLogic INSTANCE = new FoodDataMixinLogic();

    private FoodDataMixinLogic() {
    }

    public final void getFood(@Nullable Player player, @NotNull CallbackInfoReturnable<Integer> cir) {
        BloodPoolLivingEntityAttachment.Data bloodData;
        int maxBlood;
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        if (player != null && AfflictionPlayerAttachment.getData(player).getVampireLevel() > 0 && (maxBlood = (bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player)).getMaxBlood()) > 0) {
            int blood = bloodData.getBloodPool();
            int scaled = (int)((float)blood / (float)maxBlood * (float)20);
            cir.setReturnValue((Object)scaled);
        }
    }

    public final void getSaturation(@Nullable Player player, @NotNull CallbackInfoReturnable<Float> cir) {
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        if (player != null && AfflictionPlayerAttachment.getData(player).getVampireLevel() > 0) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    public final void onAdd(@NotNull Player instance, int foodLevel, float saturationLevel) {
        BloodPoolLivingEntityAttachment.Data bloodData;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (AfflictionPlayerAttachment.getData(instance).getVampireLevel() == 0 && (bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)instance)).getBloodPool() < bloodData.getMaxBlood()) {
            BloodPoolHandler.increaseBlood((LivingEntity)instance, foodLevel);
        }
    }
}

