/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.network;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.ancient_tablet.AncientTabletBlockEntity;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionType;
import dev.sterner.witchery.network.ReadTabletC2SPayload;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/network/ReadTabletC2SPayload;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "tabletId", "Ljava/util/UUID;", "tabletPos", "Lnet/minecraft/core/BlockPos;", "<init>", "(Ljava/util/UUID;Lnet/minecraft/core/BlockPos;)V", "getTabletId", "()Ljava/util/UUID;", "getTabletPos", "()Lnet/minecraft/core/BlockPos;", "handleOnServer", "", "ctx", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "witchery"})
public final class ReadTabletC2SPayload
implements CustomPacketPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID tabletId;
    @NotNull
    private final BlockPos tabletPos;
    public static final int MAX_TABLETS = 3;
    @NotNull
    private static final List<ResourceLocation> ADVANCEMENT_LOCATIONS;
    @NotNull
    private static final CustomPacketPayload.Type<ReadTabletC2SPayload> ID;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, ReadTabletC2SPayload> STREAM_CODEC;

    public ReadTabletC2SPayload(@NotNull UUID tabletId, @NotNull BlockPos tabletPos) {
        Intrinsics.checkNotNullParameter((Object)tabletId, (String)"tabletId");
        Intrinsics.checkNotNullParameter((Object)tabletPos, (String)"tabletPos");
        this.tabletId = tabletId;
        this.tabletPos = tabletPos;
    }

    @NotNull
    public final UUID getTabletId() {
        return this.tabletId;
    }

    @NotNull
    public final BlockPos getTabletPos() {
        return this.tabletPos;
    }

    public final void handleOnServer(@NotNull IPayloadContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Player player = ctx.player();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        ServerLevel level = player2.serverLevel();
        InfusionPlayerAttachment.Data infusion = InfusionPlayerAttachment.getData((Player)player2);
        if (infusion.getType() != InfusionType.NECRO) {
            return;
        }
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player2);
        if (data2.getLichData().getReadTablets().size() >= 3) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.tabletPos);
        if (!(blockEntity instanceof AncientTabletBlockEntity)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((AncientTabletBlockEntity)blockEntity).getTabletId(), (Object)this.tabletId)) {
            return;
        }
        if (player2.distanceToSqr(Vec3.atCenterOf((Vec3i)((Vec3i)this.tabletPos))) > 100.0) {
            return;
        }
        if (data2.getLichData().getReadTablets().contains(this.tabletId)) {
            return;
        }
        AfflictionPlayerAttachment.Data newData = data2.addReadTablet(this.tabletId);
        AfflictionPlayerAttachment.setData$default((Player)player2, newData, false, 4, null);
        int tabletCount = newData.getLichData().getReadTablets().size();
        if (tabletCount <= 3) {
            ResourceLocation advancementLocation = ADVANCEMENT_LOCATIONS.get(tabletCount - 1);
            String criterion = "impossible_" + tabletCount;
            Intrinsics.checkNotNull((Object)advancementLocation);
            WitcheryUtil.INSTANCE.grantAdvancementCriterion(player2, advancementLocation, criterion);
        }
        player2.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
        player2.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, 0));
        level.playSound(null, player2.blockPosition(), SoundEvents.PORTAL_TRIGGER, SoundSource.PLAYERS, 1.0f, 0.5f);
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC};
        player2.displayClientMessage((Component)Component.literal((String)("Ancient knowledge floods your mind... (" + tabletCount + "/3)")).withStyle(chatFormattingArray), true);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @NotNull
    public final UUID component1() {
        return this.tabletId;
    }

    @NotNull
    public final BlockPos component2() {
        return this.tabletPos;
    }

    @NotNull
    public final ReadTabletC2SPayload copy(@NotNull UUID tabletId, @NotNull BlockPos tabletPos) {
        Intrinsics.checkNotNullParameter((Object)tabletId, (String)"tabletId");
        Intrinsics.checkNotNullParameter((Object)tabletPos, (String)"tabletPos");
        return new ReadTabletC2SPayload(tabletId, tabletPos);
    }

    public static /* synthetic */ ReadTabletC2SPayload copy$default(ReadTabletC2SPayload readTabletC2SPayload, UUID uUID, BlockPos blockPos, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = readTabletC2SPayload.tabletId;
        }
        if ((n & 2) != 0) {
            blockPos = readTabletC2SPayload.tabletPos;
        }
        return readTabletC2SPayload.copy(uUID, blockPos);
    }

    @NotNull
    public String toString() {
        return "ReadTabletC2SPayload(tabletId=" + this.tabletId + ", tabletPos=" + this.tabletPos + ")";
    }

    public int hashCode() {
        int result = this.tabletId.hashCode();
        result = result * 31 + this.tabletPos.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReadTabletC2SPayload)) {
            return false;
        }
        ReadTabletC2SPayload readTabletC2SPayload = (ReadTabletC2SPayload)other;
        if (!Intrinsics.areEqual((Object)this.tabletId, (Object)readTabletC2SPayload.tabletId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tabletPos, (Object)readTabletC2SPayload.tabletPos);
    }

    private static final UUID STREAM_CODEC$lambda$0(KProperty1 $tmp0, ReadTabletC2SPayload p0) {
        return (UUID)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final BlockPos STREAM_CODEC$lambda$1(KProperty1 $tmp0, ReadTabletC2SPayload p0) {
        return (BlockPos)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        Object[] objectArray = new ResourceLocation[]{Witchery.Companion.id("necro/2"), Witchery.Companion.id("necro/3"), Witchery.Companion.id("necro/4")};
        ADVANCEMENT_LOCATIONS = CollectionsKt.listOf((Object[])objectArray);
        ID = new CustomPacketPayload.Type(Witchery.Companion.id("read_tablet"));
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, arg_0 -> ReadTabletC2SPayload.STREAM_CODEC$lambda$0((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)BlockPos.STREAM_CODEC, arg_0 -> ReadTabletC2SPayload.STREAM_CODEC$lambda$1((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), ReadTabletC2SPayload::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/network/ReadTabletC2SPayload$Companion;", "", "<init>", "()V", "MAX_TABLETS", "", "ADVANCEMENT_LOCATIONS", "", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getADVANCEMENT_LOCATIONS", "()Ljava/util/List;", "ID", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ldev/sterner/witchery/network/ReadTabletC2SPayload;", "getID", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ResourceLocation> getADVANCEMENT_LOCATIONS() {
            return ADVANCEMENT_LOCATIONS;
        }

        @NotNull
        public final CustomPacketPayload.Type<ReadTabletC2SPayload> getID() {
            return ID;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, ReadTabletC2SPayload> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

