/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.network;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.soul_cage.SoulCageBlockEntity;
import dev.sterner.witchery.content.entity.ImpEntity;
import dev.sterner.witchery.content.menu.SoulTradingMenu;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.network.SyncSoulTradeDataS2CPayload;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002'(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Ldev/sterner/witchery/network/SelectSoulTradeC2SPayload;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "action", "Ldev/sterner/witchery/network/SelectSoulTradeC2SPayload$Action;", "shift", "", "index", "", "<init>", "(Ldev/sterner/witchery/network/SelectSoulTradeC2SPayload$Action;ZI)V", "buf", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "getAction", "()Ldev/sterner/witchery/network/SelectSoulTradeC2SPayload$Action;", "getShift", "()Z", "getIndex", "()I", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "write", "", "handleOnServer", "ctx", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "syncMenuData", "player", "Lnet/minecraft/server/level/ServerPlayer;", "menu", "Ldev/sterner/witchery/content/menu/SoulTradingMenu;", "executeTrade", "updateMenuData", "findNearbySouls", "", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulData;", "calculateSoulWeight", "entityType", "", "Action", "Companion", "witchery"})
public final class SelectSoulTradeC2SPayload
implements CustomPacketPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Action action;
    private final boolean shift;
    private final int index;
    @NotNull
    private static final CustomPacketPayload.Type<SelectSoulTradeC2SPayload> ID = new CustomPacketPayload.Type(Witchery.Companion.id("select_soul_trade"));
    @NotNull
    private static final StreamCodec<? super RegistryFriendlyByteBuf, SelectSoulTradeC2SPayload> STREAM_CODEC;

    public SelectSoulTradeC2SPayload(@NotNull Action action, boolean shift, int index) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        this.action = action;
        this.shift = shift;
        this.index = index;
    }

    @NotNull
    public final Action getAction() {
        return this.action;
    }

    public final boolean getShift() {
        return this.shift;
    }

    public final int getIndex() {
        return this.index;
    }

    public SelectSoulTradeC2SPayload(@NotNull RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this(Action.values()[buf.readInt()], buf.readBoolean(), buf.readInt());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private final void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeBoolean(this.shift);
        buf.writeInt(this.index);
    }

    public final void handleOnServer(@NotNull IPayloadContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Player player = ctx.player();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
        SoulTradingMenu soulTradingMenu = abstractContainerMenu instanceof SoulTradingMenu ? (SoulTradingMenu)abstractContainerMenu : null;
        if (soulTradingMenu == null) {
            return;
        }
        SoulTradingMenu menu = soulTradingMenu;
        switch (WhenMappings.$EnumSwitchMapping$0[this.action.ordinal()]) {
            case 1: {
                menu.selectSoul(this.index);
                this.syncMenuData(player2, menu);
                break;
            }
            case 2: {
                menu.incrementAmount(this.index, this.shift);
                this.syncMenuData(player2, menu);
                break;
            }
            case 3: {
                menu.decrementAmount(this.index, this.shift);
                this.syncMenuData(player2, menu);
                break;
            }
            case 4: {
                if (menu.canMakeTrade()) {
                    this.executeTrade(player2, menu);
                    break;
                }
                this.syncMenuData(player2, menu);
                break;
            }
            case 5: {
                this.syncMenuData(player2, menu);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void syncMenuData(ServerPlayer player, SoulTradingMenu menu) {
        SyncSoulTradeDataS2CPayload payload = new SyncSoulTradeDataS2CPayload(menu.getAvailableTrades(), menu.getAvailableSouls(), CollectionsKt.toList((Iterable)menu.getSelectedTrades()), menu.getSelectedSoulIndex());
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private final void executeTrade(ServerPlayer player, SoulTradingMenu menu) {
        SoulTradingMenu.SoulData soulData = menu.getSelectedSoul();
        if (soulData == null) {
            return;
        }
        SoulTradingMenu.SoulData soul = soulData;
        if (menu.getSelectedTrades().isEmpty()) {
            return;
        }
        ServerLevel level = player.serverLevel();
        BlockPos playerPos = player.blockPosition();
        int searchRadius = 16;
        if (soul.isBlockEntity()) {
            BlockPos minPos = new BlockPos(playerPos.getX() - searchRadius, playerPos.getY() - searchRadius, playerPos.getZ() - searchRadius);
            maxPos = new BlockPos(playerPos.getX() + searchRadius, playerPos.getY() + searchRadius, playerPos.getZ() + searchRadius);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                SoulCageBlockEntity blockEntity2 = blockEntity instanceof SoulCageBlockEntity ? (SoulCageBlockEntity)blockEntity : null;
                if (blockEntity2 == null || !blockEntity2.getHasSoul()) continue;
                blockEntity2.extractSoul();
                break;
            }
        } else {
            LivingEntity entity;
            maxPos = level.getEntity(soul.getEntityId());
            LivingEntity livingEntity = entity = maxPos instanceof LivingEntity ? (LivingEntity)maxPos : null;
            if (entity != null && EtherealEntityAttachment.getData(entity).isEthereal()) {
                entity.discard();
            }
        }
        for (SoulTradingMenu.SelectedTrade selected : menu.getSelectedTrades()) {
            if (selected.getTradeIndex() < 0 || selected.getTradeIndex() >= menu.getAvailableTrades().size()) continue;
            SoulTradingMenu.SoulTrade trade = menu.getAvailableTrades().get(selected.getTradeIndex());
            ItemStack outputStack = trade.getOutput().copy();
            outputStack.setCount(selected.getAmount());
            if (player.getInventory().add(outputStack.copy())) continue;
            player.drop(outputStack.copy(), false);
        }
        menu.clearSelection();
        this.updateMenuData(player, menu);
    }

    private final void updateMenuData(ServerPlayer player, SoulTradingMenu menu) {
        List<SoulTradingMenu.SoulTrade> trades = ImpEntity.Companion.getAvailableTrades();
        List<SoulTradingMenu.SoulData> souls = this.findNearbySouls(player);
        menu.setTrades(trades);
        menu.setSouls(souls);
        this.syncMenuData(player, menu);
    }

    private final List<SoulTradingMenu.SoulData> findNearbySouls(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        List souls = new ArrayList();
        double searchRadius = 16.0;
        BlockPos playerPos = player.blockPosition();
        AABB searchBox = new AABB(playerPos).inflate(searchRadius);
        List entities = level.getEntitiesOfClass(LivingEntity.class, searchBox, arg_0 -> SelectSoulTradeC2SPayload.findNearbySouls$lambda$1(SelectSoulTradeC2SPayload::findNearbySouls$lambda$0, arg_0));
        for (LivingEntity entity : entities) {
            String entityType;
            Intrinsics.checkNotNullExpressionValue((Object)entity.getType().toString(), (String)"toString(...)");
            int n = entity.getId();
            String string = entity.getType().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            souls.add(new SoulTradingMenu.SoulData(n, this.calculateSoulWeight(string), entityType, false));
        }
        BlockPos minPos = new BlockPos(playerPos.getX() - (int)searchRadius, playerPos.getY() - (int)searchRadius, playerPos.getZ() - (int)searchRadius);
        BlockPos maxPos = new BlockPos(playerPos.getX() + (int)searchRadius, playerPos.getY() + (int)searchRadius, playerPos.getZ() + (int)searchRadius);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            SoulCageBlockEntity blockEntity2 = blockEntity instanceof SoulCageBlockEntity ? (SoulCageBlockEntity)blockEntity : null;
            if (blockEntity2 == null || !blockEntity2.getHasSoul()) continue;
            souls.add(new SoulTradingMenu.SoulData((int)pos.asLong(), 20, "minecraft:villager", true));
        }
        return souls;
    }

    private final int calculateSoulWeight(String entityType) {
        return StringsKt.contains((CharSequence)entityType, (CharSequence)"villager", (boolean)true) ? 20 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"zombie", (boolean)true) ? 10 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"skeleton", (boolean)true) ? 10 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"creeper", (boolean)true) ? 12 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"spider", (boolean)true) ? 8 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"enderman", (boolean)true) ? 25 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"pig", (boolean)true) ? 6 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"cow", (boolean)true) ? 6 : 5)))))));
    }

    private static final boolean findNearbySouls$lambda$0(LivingEntity entity) {
        return entity != null && EtherealEntityAttachment.getData(entity).isEthereal();
    }

    private static final boolean findNearbySouls$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void STREAM_CODEC$lambda$0(SelectSoulTradeC2SPayload payload, RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNull((Object)buf);
        payload.write(buf);
    }

    private static final SelectSoulTradeC2SPayload STREAM_CODEC$lambda$1(RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNull((Object)buf);
        return new SelectSoulTradeC2SPayload(buf);
    }

    static {
        StreamCodec streamCodec = CustomPacketPayload.codec(SelectSoulTradeC2SPayload::STREAM_CODEC$lambda$0, SelectSoulTradeC2SPayload::STREAM_CODEC$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"codec(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/network/SelectSoulTradeC2SPayload$Action;", "", "<init>", "(Ljava/lang/String;I)V", "SELECT_SOUL", "INCREMENT_AMOUNT", "DECREMENT_AMOUNT", "CONFIRM_TRADE", "REQUEST_UPDATE", "witchery"})
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action SELECT_SOUL = new Action();
        public static final /* enum */ Action INCREMENT_AMOUNT = new Action();
        public static final /* enum */ Action DECREMENT_AMOUNT = new Action();
        public static final /* enum */ Action CONFIRM_TRADE = new Action();
        public static final /* enum */ Action REQUEST_UPDATE = new Action();
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        @NotNull
        public static EnumEntries<Action> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actionArray = new Action[]{Action.SELECT_SOUL, Action.INCREMENT_AMOUNT, Action.DECREMENT_AMOUNT, Action.CONFIRM_TRADE, Action.REQUEST_UPDATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/network/SelectSoulTradeC2SPayload$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ldev/sterner/witchery/network/SelectSoulTradeC2SPayload;", "getID", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPacketPayload.Type<SelectSoulTradeC2SPayload> getID() {
            return ID;
        }

        @NotNull
        public final StreamCodec<? super RegistryFriendlyByteBuf, SelectSoulTradeC2SPayload> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Action.values().length];
            try {
                nArray[Action.SELECT_SOUL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.INCREMENT_AMOUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.DECREMENT_AMOUNT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.CONFIRM_TRADE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.REQUEST_UPDATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

