/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.network;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.menu.SoulTradingMenu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Ldev/sterner/witchery/network/SyncSoulTradeDataS2CPayload;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "trades", "", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulTrade;", "souls", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulData;", "selectedTrades", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SelectedTrade;", "selectedSoulIndex", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;I)V", "buf", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "getTrades", "()Ljava/util/List;", "getSouls", "getSelectedTrades", "getSelectedSoulIndex", "()I", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "write", "", "handleOnClient", "Companion", "witchery"})
public final class SyncSoulTradeDataS2CPayload
implements CustomPacketPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SoulTradingMenu.SoulTrade> trades;
    @NotNull
    private final List<SoulTradingMenu.SoulData> souls;
    @NotNull
    private final List<SoulTradingMenu.SelectedTrade> selectedTrades;
    private final int selectedSoulIndex;
    @NotNull
    private static final CustomPacketPayload.Type<SyncSoulTradeDataS2CPayload> ID = new CustomPacketPayload.Type(Witchery.Companion.id("sync_soul_trade_data"));
    @NotNull
    private static final StreamCodec<? super RegistryFriendlyByteBuf, SyncSoulTradeDataS2CPayload> STREAM_CODEC;

    public SyncSoulTradeDataS2CPayload(@NotNull List<SoulTradingMenu.SoulTrade> trades, @NotNull List<SoulTradingMenu.SoulData> souls, @NotNull List<SoulTradingMenu.SelectedTrade> selectedTrades, int selectedSoulIndex) {
        Intrinsics.checkNotNullParameter(trades, (String)"trades");
        Intrinsics.checkNotNullParameter(souls, (String)"souls");
        Intrinsics.checkNotNullParameter(selectedTrades, (String)"selectedTrades");
        this.trades = trades;
        this.souls = souls;
        this.selectedTrades = selectedTrades;
        this.selectedSoulIndex = selectedSoulIndex;
    }

    @NotNull
    public final List<SoulTradingMenu.SoulTrade> getTrades() {
        return this.trades;
    }

    @NotNull
    public final List<SoulTradingMenu.SoulData> getSouls() {
        return this.souls;
    }

    @NotNull
    public final List<SoulTradingMenu.SelectedTrade> getSelectedTrades() {
        return this.selectedTrades;
    }

    public final int getSelectedSoulIndex() {
        return this.selectedSoulIndex;
    }

    public SyncSoulTradeDataS2CPayload(@NotNull RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this(SyncSoulTradeDataS2CPayload.Companion.readTrades(buf), SyncSoulTradeDataS2CPayload.Companion.readSouls(buf), SyncSoulTradeDataS2CPayload.Companion.readSelectedTrades(buf), buf.readInt());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private final void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.trades.size());
        for (SoulTradingMenu.SoulTrade trade : this.trades) {
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)trade.getOutput());
            buf.writeInt(trade.getSoulCost());
        }
        buf.writeInt(this.souls.size());
        for (SoulTradingMenu.SoulData soul : this.souls) {
            buf.writeInt(soul.getEntityId());
            buf.writeInt(soul.getWeight());
            buf.writeUtf(soul.getEntityType());
            buf.writeBoolean(soul.isBlockEntity());
        }
        buf.writeInt(this.selectedTrades.size());
        for (SoulTradingMenu.SelectedTrade selected : this.selectedTrades) {
            buf.writeInt(selected.getTradeIndex());
            buf.writeInt(selected.getAmount());
        }
        buf.writeInt(this.selectedSoulIndex);
    }

    public final void handleOnClient() {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> SyncSoulTradeDataS2CPayload.handleOnClient$lambda$0(client, this));
    }

    private static final void handleOnClient$lambda$0(Minecraft $client, SyncSoulTradeDataS2CPayload this$0) {
        LocalPlayer localPlayer = $client.player;
        AbstractContainerMenu abstractContainerMenu = localPlayer != null ? localPlayer.containerMenu : null;
        SoulTradingMenu soulTradingMenu = abstractContainerMenu instanceof SoulTradingMenu ? (SoulTradingMenu)abstractContainerMenu : null;
        if (soulTradingMenu == null) {
            return;
        }
        SoulTradingMenu menu = soulTradingMenu;
        menu.setTrades(this$0.trades);
        menu.setSouls(this$0.souls);
        menu.getSelectedTrades().clear();
        menu.getSelectedTrades().addAll((Collection<SoulTradingMenu.SelectedTrade>)this$0.selectedTrades);
        menu.setSelectedSoulIndex(this$0.selectedSoulIndex);
    }

    private static final void STREAM_CODEC$lambda$0(SyncSoulTradeDataS2CPayload payload, RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNull((Object)buf);
        payload.write(buf);
    }

    private static final SyncSoulTradeDataS2CPayload STREAM_CODEC$lambda$1(RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNull((Object)buf);
        return new SyncSoulTradeDataS2CPayload(buf);
    }

    static {
        StreamCodec streamCodec = CustomPacketPayload.codec(SyncSoulTradeDataS2CPayload::STREAM_CODEC$lambda$0, SyncSoulTradeDataS2CPayload::STREAM_CODEC$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"codec(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/network/SyncSoulTradeDataS2CPayload$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ldev/sterner/witchery/network/SyncSoulTradeDataS2CPayload;", "getID", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "readTrades", "", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulTrade;", "buf", "readSouls", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulData;", "readSelectedTrades", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SelectedTrade;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPacketPayload.Type<SyncSoulTradeDataS2CPayload> getID() {
            return ID;
        }

        @NotNull
        public final StreamCodec<? super RegistryFriendlyByteBuf, SyncSoulTradeDataS2CPayload> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        private final List<SoulTradingMenu.SoulTrade> readTrades(RegistryFriendlyByteBuf buf) {
            int size = buf.readInt();
            List trades = new ArrayList();
            for (int i = 0; i < size; ++i) {
                ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                int soulCost = buf.readInt();
                Intrinsics.checkNotNull((Object)output);
                trades.add(new SoulTradingMenu.SoulTrade(output, soulCost));
            }
            return trades;
        }

        private final List<SoulTradingMenu.SoulData> readSouls(RegistryFriendlyByteBuf buf) {
            int size = buf.readInt();
            List souls = new ArrayList();
            for (int i = 0; i < size; ++i) {
                int entityId = buf.readInt();
                int weight = buf.readInt();
                String entityType = buf.readUtf();
                boolean isBlockEntity = buf.readBoolean();
                Intrinsics.checkNotNull((Object)entityType);
                souls.add(new SoulTradingMenu.SoulData(entityId, weight, entityType, isBlockEntity));
            }
            return souls;
        }

        private final List<SoulTradingMenu.SelectedTrade> readSelectedTrades(RegistryFriendlyByteBuf buf) {
            int size = buf.readInt();
            List selectedTrades = new ArrayList();
            for (int i = 0; i < size; ++i) {
                int tradeIndex = buf.readInt();
                int amount = buf.readInt();
                selectedTrades.add(new SoulTradingMenu.SelectedTrade(tradeIndex, amount));
            }
            return selectedTrades;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

