/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery;

import com.mojang.datafixers.util.Pair;
import dev.sterner.witchery.mixin.StructureTemplatePoolAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class VillageHelper {
    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        VillageHelper.addBuildingToPool(templatePoolRegistry, processorListRegistry, poolRL, nbtPieceRL, weight, null);
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight, String processorListId) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        ResourceLocation processorRL = processorListId != null ? ResourceLocation.parse((String)processorListId) : ResourceLocation.withDefaultNamespace((String)"empty");
        Holder.Reference processorHolder = processorListRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)processorRL));
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            ObjectArrayList<StructurePoolElement> mut = ((StructureTemplatePoolAccessor)pool).getTemplates();
            mut.add((Object)piece);
            ((StructureTemplatePoolAccessor)pool).setTemplates(mut);
        }
        ArrayList<Pair<StructurePoolElement, Integer>> listOfPieceEntries = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccessor)pool).getRawTemplates());
        listOfPieceEntries.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
        ((StructureTemplatePoolAccessor)pool).setRawTemplates(listOfPieceEntries);
    }
}

