/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\bJ\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J@\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002Jh\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ldev/sterner/witchery/client/DebugAABBRenderer;", "", "<init>", "()V", "debugAABBs", "", "Ldev/sterner/witchery/client/DebugAABBRenderer$DebugAABB;", "addAABB", "", "aabb", "Lnet/minecraft/world/phys/AABB;", "color", "", "durationTicks", "tick", "render", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "cameraPos", "Lnet/minecraft/world/phys/Vec3;", "renderAABBLines", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "r", "", "g", "b", "a", "drawLine", "matrix", "Lorg/joml/Matrix4f;", "x1", "", "y1", "z1", "x2", "y2", "z2", "DebugAABB", "witchery"})
@SourceDebugExtension(value={"SMAP\nDebugAABBRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugAABBRenderer.kt\ndev/sterner/witchery/client/DebugAABBRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1869#2,2:104\n*S KotlinDebug\n*F\n+ 1 DebugAABBRenderer.kt\ndev/sterner/witchery/client/DebugAABBRenderer\n*L\n38#1:104,2\n*E\n"})
public final class DebugAABBRenderer {
    @NotNull
    public static final DebugAABBRenderer INSTANCE = new DebugAABBRenderer();
    @NotNull
    private static final List<DebugAABB> debugAABBs = new ArrayList();

    private DebugAABBRenderer() {
    }

    public final void addAABB(@NotNull AABB aabb, int color, int durationTicks) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        debugAABBs.add(new DebugAABB(aabb, color, durationTicks));
    }

    public final void tick() {
        CollectionsKt.removeAll(debugAABBs, DebugAABBRenderer::tick$lambda$0);
    }

    public final void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, @NotNull Vec3 cameraPos) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        if (debugAABBs.isEmpty()) {
            return;
        }
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        Iterable $this$forEach$iv = debugAABBs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugAABB debug = (DebugAABB)element$iv;
            boolean bl = false;
            AABB aabb = debug.getAabb().move(-cameraPos.x, -cameraPos.y, -cameraPos.z);
            int color = debug.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = 1.0f;
            Intrinsics.checkNotNull((Object)buffer);
            Intrinsics.checkNotNull((Object)aabb);
            INSTANCE.renderAABBLines(poseStack, buffer, aabb, r, g, b, a);
        }
    }

    private final void renderAABBLines(PoseStack poseStack, VertexConsumer buffer, AABB aabb, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.last().pose();
        Intrinsics.checkNotNull((Object)matrix);
        this.drawLine(matrix, buffer, aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.minY, aabb.minZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.maxX, aabb.minY, aabb.minZ, aabb.maxX, aabb.minY, aabb.maxZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.maxX, aabb.minY, aabb.maxZ, aabb.minX, aabb.minY, aabb.maxZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.minX, aabb.minY, aabb.maxZ, aabb.minX, aabb.minY, aabb.minZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.minX, aabb.maxY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.minZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.maxX, aabb.maxY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.maxX, aabb.maxY, aabb.maxZ, aabb.minX, aabb.maxY, aabb.maxZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.minX, aabb.maxY, aabb.maxZ, aabb.minX, aabb.maxY, aabb.minZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.minX, aabb.minY, aabb.minZ, aabb.minX, aabb.maxY, aabb.minZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.maxX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.minZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.maxX, aabb.minY, aabb.maxZ, aabb.maxX, aabb.maxY, aabb.maxZ, r, g, b, a);
        this.drawLine(matrix, buffer, aabb.minX, aabb.minY, aabb.maxZ, aabb.minX, aabb.maxY, aabb.maxZ, r, g, b, a);
    }

    private final void drawLine(Matrix4f matrix, VertexConsumer buffer, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        buffer.addVertex(matrix, (float)x1, (float)y1, (float)z1).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)x2, (float)y2, (float)z2).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static final boolean tick$lambda$0(DebugAABB debug) {
        Intrinsics.checkNotNullParameter((Object)debug, (String)"debug");
        int n = debug.getRemainingTicks();
        debug.setRemainingTicks(n + -1);
        return debug.getRemainingTicks() <= 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\f\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/client/DebugAABBRenderer$DebugAABB;", "", "aabb", "Lnet/minecraft/world/phys/AABB;", "color", "", "remainingTicks", "<init>", "(Lnet/minecraft/world/phys/AABB;II)V", "getAabb", "()Lnet/minecraft/world/phys/AABB;", "getColor", "()I", "getRemainingTicks", "setRemainingTicks", "(I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "witchery"})
    private static final class DebugAABB {
        @NotNull
        private final AABB aabb;
        private final int color;
        private int remainingTicks;

        public DebugAABB(@NotNull AABB aabb, int color, int remainingTicks) {
            Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
            this.aabb = aabb;
            this.color = color;
            this.remainingTicks = remainingTicks;
        }

        @NotNull
        public final AABB getAabb() {
            return this.aabb;
        }

        public final int getColor() {
            return this.color;
        }

        public final int getRemainingTicks() {
            return this.remainingTicks;
        }

        public final void setRemainingTicks(int n) {
            this.remainingTicks = n;
        }

        @NotNull
        public final AABB component1() {
            return this.aabb;
        }

        public final int component2() {
            return this.color;
        }

        public final int component3() {
            return this.remainingTicks;
        }

        @NotNull
        public final DebugAABB copy(@NotNull AABB aabb, int color, int remainingTicks) {
            Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
            return new DebugAABB(aabb, color, remainingTicks);
        }

        public static /* synthetic */ DebugAABB copy$default(DebugAABB debugAABB, AABB aABB, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                aABB = debugAABB.aabb;
            }
            if ((n3 & 2) != 0) {
                n = debugAABB.color;
            }
            if ((n3 & 4) != 0) {
                n2 = debugAABB.remainingTicks;
            }
            return debugAABB.copy(aABB, n, n2);
        }

        @NotNull
        public String toString() {
            return "DebugAABB(aabb=" + this.aabb + ", color=" + this.color + ", remainingTicks=" + this.remainingTicks + ")";
        }

        public int hashCode() {
            int result = this.aabb.hashCode();
            result = result * 31 + Integer.hashCode(this.color);
            result = result * 31 + Integer.hashCode(this.remainingTicks);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DebugAABB)) {
                return false;
            }
            DebugAABB debugAABB = (DebugAABB)other;
            if (!Intrinsics.areEqual((Object)this.aabb, (Object)debugAABB.aabb)) {
                return false;
            }
            if (this.color != debugAABB.color) {
                return false;
            }
            return this.remainingTicks == debugAABB.remainingTicks;
        }
    }
}

