/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryShaders;
import dev.sterner.witchery.features.lifeblood.LifebloodPlayerAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J0\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002JT\u0010!\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00192\b\b\u0002\u0010)\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ldev/sterner/witchery/client/hud/LifebloodHudRenderer;", "", "<init>", "()V", "HEARTBEAT_SPEED", "", "FIRST_BEAT_SCALE", "SECOND_BEAT_SCALE", "MIN_GLOW_INTENSITY", "MAX_GLOW_INTENSITY", "WOBBLE_INTENSITY", "WOBBLE_SPEED", "WOBBLE_FREQUENCY", "renderHud", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "deltaTracker", "Lnet/minecraft/client/DeltaTracker;", "renderLifebloodHearts", "player", "Lnet/minecraft/world/entity/player/Player;", "data", "Ldev/sterner/witchery/features/lifeblood/LifebloodPlayerAttachment$Data;", "screenWidth", "", "y", "calculateHeartbeat", "Ldev/sterner/witchery/client/hud/LifebloodHudRenderer$HeartbeatData;", "timeInSeconds", "easeOutCubic", "t", "easeInQuad", "renderWobblyHeart", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "x", "size", "index", "alpha", "additive", "", "getLifebloodEmissiveTexture", "points", "HeartbeatData", "witchery"})
public final class LifebloodHudRenderer {
    @NotNull
    public static final LifebloodHudRenderer INSTANCE = new LifebloodHudRenderer();
    private static final float HEARTBEAT_SPEED = 0.45f;
    private static final float FIRST_BEAT_SCALE = 0.09f;
    private static final float SECOND_BEAT_SCALE = 0.06f;
    private static final float MIN_GLOW_INTENSITY = 0.5f;
    private static final float MAX_GLOW_INTENSITY = 1.0f;
    private static final float WOBBLE_INTENSITY = 0.008f;
    private static final float WOBBLE_SPEED = 1.2f;
    private static final float WOBBLE_FREQUENCY = 10.0f;

    private LifebloodHudRenderer() {
    }

    public final void renderHud(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)deltaTracker, (String)"deltaTracker");
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (minecraft.options.hideGui || player.isSpectator() || player.isCreative()) {
            return;
        }
        LifebloodPlayerAttachment.Data data2 = LifebloodPlayerAttachment.getData((Player)player);
        if (data2.getLifebloodPoints() <= 0) {
            return;
        }
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        int healthBarY = screenHeight - 39;
        int lifebloodY = healthBarY - 11;
        if (player.getArmorValue() > 0) {
            lifebloodY -= 10;
        }
        if (player.getAbsorptionAmount() > 0.0f) {
            lifebloodY -= 10;
        }
        this.renderLifebloodHearts(guiGraphics, (Player)player, data2, screenWidth, lifebloodY);
    }

    private final void renderLifebloodHearts(GuiGraphics guiGraphics, Player player, LifebloodPlayerAttachment.Data data2, int screenWidth, int y) {
        PoseStack poseStack = guiGraphics.pose();
        int totalHearts = (int)Math.ceil((double)data2.getLifebloodPoints() / 5.0);
        int startX = screenWidth / 2 - 92;
        int size = 10;
        for (int i = 0; i < totalHearts; ++i) {
            int remainder;
            int row = i / 10;
            int x = startX + i % 10 * 8;
            int yPos = y - row * 4;
            int pointsInThisHeart = i == totalHearts - 1 ? ((remainder = data2.getPartialHeartPoints()) == 0 ? 5 : remainder) : 5;
            ResourceLocation emissiveTexture = this.getLifebloodEmissiveTexture(pointsInThisHeart);
            HeartbeatData heartbeat = this.calculateHeartbeat((float)player.level().getGameTime() / 20.0f);
            float heartbeatScale = heartbeat.getScale();
            float glowAlpha = heartbeat.getGlowIntensity();
            poseStack.pushPose();
            poseStack.translate((double)x + (double)size / 2.0, (double)yPos + (double)size / 2.0, 0.0);
            poseStack.scale(heartbeatScale, heartbeatScale, 1.0f);
            poseStack.translate(-((double)size / 2.0), -((double)size / 2.0), 0.0);
            Intrinsics.checkNotNull((Object)poseStack);
            ResourceLocation resourceLocation = Witchery.Companion.id("textures/gui/lifeblood_empty.png");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            this.renderWobblyHeart(player, poseStack, resourceLocation, 0.0f, 0.0f, size, i, 1.0f, false);
            this.renderWobblyHeart(player, poseStack, emissiveTexture, 0.0f, 0.0f, size, i, glowAlpha, true);
            poseStack.popPose();
        }
    }

    private final HeartbeatData calculateHeartbeat(float timeInSeconds) {
        HeartbeatData heartbeatData;
        float cycleTime = timeInSeconds * 0.45f;
        float phase = cycleTime % 1.0f;
        float glowRange = 0.5f;
        if (phase < 0.08f) {
            float t = phase / 0.08f;
            float scale = 1.0f + this.easeOutCubic(t) * 0.09f;
            float glow = 0.5f + this.easeOutCubic(t) * glowRange;
            heartbeatData = new HeartbeatData(scale, glow);
        } else if (phase < 0.2f) {
            float t = (phase - 0.08f) / 0.12f;
            float scale = 1.09f - this.easeInQuad(t) * 0.09f;
            float glow = 1.0f - this.easeInQuad(t) * glowRange;
            heartbeatData = new HeartbeatData(scale, glow);
        } else if (phase < 0.25f) {
            heartbeatData = new HeartbeatData(1.0f, 0.5f);
        } else if (phase < 0.32f) {
            float t = (phase - 0.25f) / 0.07f;
            float scale = 1.0f + this.easeOutCubic(t) * 0.06f;
            float glow = 0.5f + this.easeOutCubic(t) * glowRange;
            heartbeatData = new HeartbeatData(scale, glow);
        } else if (phase < 0.42f) {
            float t = (phase - 0.32f) / 0.1f;
            float scale = 1.06f - this.easeInQuad(t) * 0.06f;
            float glow = 1.0f - this.easeInQuad(t) * glowRange;
            heartbeatData = new HeartbeatData(scale, glow);
        } else {
            heartbeatData = new HeartbeatData(1.0f, 0.5f);
        }
        return heartbeatData;
    }

    private final float easeOutCubic(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 3);
    }

    private final float easeInQuad(float t) {
        return t * t;
    }

    private final void renderWobblyHeart(Player player, PoseStack poseStack, ResourceLocation texture, float x, float y, float size, int index, float alpha, boolean additive) {
        ShaderInstance shaderInstance = WitcheryShaders.lifeblood;
        if (shaderInstance == null) {
            return;
        }
        ShaderInstance shader = shaderInstance;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(() -> LifebloodHudRenderer.renderWobblyHeart$lambda$0(shader));
        RenderSystem.enableBlend();
        if (additive) {
            RenderSystem.blendFunc((int)770, (int)1);
        } else {
            RenderSystem.defaultBlendFunc();
        }
        float gameTime = (float)player.level().getGameTime() / 20.0f + (float)index * 0.5f;
        shader.safeGetUniform("GameTime").set(gameTime);
        shader.safeGetUniform("Intensity").set(0.008f);
        shader.safeGetUniform("Speed").set(1.2f);
        shader.safeGetUniform("Frequency").set(10.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, x, y + size, 0.0f).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex(matrix, x + size, y + size, 0.0f).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(matrix, x + size, y, 0.0f).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(matrix, x, y, 0.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    static /* synthetic */ void renderWobblyHeart$default(LifebloodHudRenderer lifebloodHudRenderer, Player player, PoseStack poseStack, ResourceLocation resourceLocation, float f, float f2, float f3, int n, float f4, boolean bl, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            f4 = 1.0f;
        }
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        lifebloodHudRenderer.renderWobblyHeart(player, poseStack, resourceLocation, f, f2, f3, n, f4, bl);
    }

    private final ResourceLocation getLifebloodEmissiveTexture(int points) {
        ResourceLocation resourceLocation;
        switch (points) {
            case 0: {
                ResourceLocation resourceLocation2 = Witchery.Companion.id("textures/gui/lifeblood_empty.png");
                resourceLocation = resourceLocation2;
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"id(...)");
                break;
            }
            case 1: {
                ResourceLocation resourceLocation3 = Witchery.Companion.id("textures/gui/lifeblood_1_emissive.png");
                resourceLocation = resourceLocation3;
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"id(...)");
                break;
            }
            case 2: {
                ResourceLocation resourceLocation4 = Witchery.Companion.id("textures/gui/lifeblood_2_emissive.png");
                resourceLocation = resourceLocation4;
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"id(...)");
                break;
            }
            case 3: {
                ResourceLocation resourceLocation5 = Witchery.Companion.id("textures/gui/lifeblood_3_emissive.png");
                resourceLocation = resourceLocation5;
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"id(...)");
                break;
            }
            case 4: {
                ResourceLocation resourceLocation6 = Witchery.Companion.id("textures/gui/lifeblood_4_emissive.png");
                resourceLocation = resourceLocation6;
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"id(...)");
                break;
            }
            default: {
                ResourceLocation resourceLocation7 = Witchery.Companion.id("textures/gui/lifeblood_full_emissive.png");
                resourceLocation = resourceLocation7;
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation7, (String)"id(...)");
            }
        }
        return resourceLocation;
    }

    private static final ShaderInstance renderWobblyHeart$lambda$0(ShaderInstance $shader) {
        return $shader;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/client/hud/LifebloodHudRenderer$HeartbeatData;", "", "scale", "", "glowIntensity", "<init>", "(FF)V", "getScale", "()F", "getGlowIntensity", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "witchery"})
    private static final class HeartbeatData {
        private final float scale;
        private final float glowIntensity;

        public HeartbeatData(float scale, float glowIntensity) {
            this.scale = scale;
            this.glowIntensity = glowIntensity;
        }

        public final float getScale() {
            return this.scale;
        }

        public final float getGlowIntensity() {
            return this.glowIntensity;
        }

        public final float component1() {
            return this.scale;
        }

        public final float component2() {
            return this.glowIntensity;
        }

        @NotNull
        public final HeartbeatData copy(float scale, float glowIntensity) {
            return new HeartbeatData(scale, glowIntensity);
        }

        public static /* synthetic */ HeartbeatData copy$default(HeartbeatData heartbeatData, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = heartbeatData.scale;
            }
            if ((n & 2) != 0) {
                f2 = heartbeatData.glowIntensity;
            }
            return heartbeatData.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "HeartbeatData(scale=" + this.scale + ", glowIntensity=" + this.glowIntensity + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.scale);
            result = result * 31 + Float.hashCode(this.glowIntensity);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeartbeatData)) {
                return false;
            }
            HeartbeatData heartbeatData = (HeartbeatData)other;
            if (Float.compare(this.scale, heartbeatData.scale) != 0) {
                return false;
            }
            return Float.compare(this.glowIntensity, heartbeatData.glowIntensity) == 0;
        }
    }
}

