/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.BloodCrucibleModel;
import dev.sterner.witchery.content.block.blood_crucible.BloodCrucibleBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J8\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Ldev/sterner/witchery/client/renderer/block/BloodCrucibleBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/blood_crucible/BloodCrucibleBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "model", "Ldev/sterner/witchery/client/model/BloodCrucibleModel;", "getModel", "()Ldev/sterner/witchery/client/model/BloodCrucibleModel;", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "renderBlood", "buffer", "bloodPercent", "", "Companion", "witchery"})
public final class BloodCrucibleBlockEntityRenderer
implements BlockEntityRenderer<BloodCrucibleBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BloodCrucibleModel model;
    @NotNull
    private static Material BLOOD = new Material(TextureAtlas.LOCATION_BLOCKS, Witchery.Companion.id("block/blood_fluid"));
    public static final int BLOOD_COLOR = 0xFF0000;

    public BloodCrucibleBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ModelPart modelPart = ctx.bakeLayer(BloodCrucibleModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new BloodCrucibleModel(modelPart);
    }

    @NotNull
    public final BloodCrucibleModel getModel() {
        return this.model;
    }

    public void render(@NotNull BloodCrucibleBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -1.5, 0.5);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/block/vampire_altar.png")));
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, -1);
        poseStack.popPose();
        if (blockEntity.bloodPercent() > 0.0) {
            this.renderBlood(blockEntity, poseStack, bufferSource, blockEntity.bloodPercent(), packedLight, packedOverlay);
        }
    }

    private final void renderBlood(BloodCrucibleBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, double bloodPercent, int packedLight, int packedOverlay) {
        if (blockEntity.bloodPercent() > 0.0) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.62 + 0.2 * bloodPercent, 0.5);
            poseStack.scale(0.85f, 1.0f, 0.85f);
            Level level = blockEntity.getLevel();
            if (level != null) {
                long gameTime = level.getGameTime();
                long cycleTime = gameTime % (long)240;
                double normalizedTime = (double)cycleTime / 240.0;
                double waveAmplitude = 0.01;
                double heightOffset = Math.sin(normalizedTime * Math.PI * (double)2) * waveAmplitude;
                poseStack.translate(0.0, heightOffset, 0.0);
            }
            TextureAtlasSprite textureAtlasSprite = BLOOD.sprite();
            Intrinsics.checkNotNullExpressionValue((Object)textureAtlasSprite, (String)"sprite(...)");
            TextureAtlasSprite sprite = textureAtlasSprite;
            int red = 255;
            int green = 0;
            int blue = 0;
            Matrix4f matrix4f = poseStack.last().pose();
            Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
            Matrix4f mat = matrix4f;
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)sprite.atlasLocation()));
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
            VertexConsumer vertexConsumer2 = vertexConsumer;
            float quadSize = 0.3125f;
            vertexConsumer2.addVertex(mat, -quadSize, 0.0f, quadSize).setColor(red, green, blue, 255).setUv(sprite.getU0(), sprite.getV0()).setLight(packedLight).setOverlay(packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer2.addVertex(mat, quadSize, 0.0f, quadSize).setColor(red, green, blue, 255).setUv(sprite.getU1(), sprite.getV0()).setLight(packedLight).setOverlay(packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer2.addVertex(mat, quadSize, 0.0f, -quadSize).setColor(red, green, blue, 255).setUv(sprite.getU1(), sprite.getV1()).setLight(packedLight).setOverlay(packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer2.addVertex(mat, -quadSize, 0.0f, -quadSize).setColor(red, green, blue, 255).setUv(sprite.getU0(), sprite.getV1()).setLight(packedLight).setOverlay(packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
            poseStack.popPose();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/client/renderer/block/BloodCrucibleBlockEntityRenderer$Companion;", "", "<init>", "()V", "BLOOD", "Lnet/minecraft/client/resources/model/Material;", "BLOOD_COLOR", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

