/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.client.particle.ColorBubbleData;
import dev.sterner.witchery.content.block.cauldron.CauldronBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u0010\u0018\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002Jh\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006'"}, d2={"Ldev/sterner/witchery/client/renderer/block/CauldronBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/cauldron/CauldronBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "addBubble", "cauldron", "color", "fluidLevel", "", "renderWater", "addVertex", "vertexConsumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "mat", "Lorg/joml/Matrix4f;", "x", "y", "z", "u", "v", "red", "green", "blue", "Companion", "witchery"})
public final class CauldronBlockEntityRenderer
implements BlockEntityRenderer<CauldronBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Material WATER_STILL = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace((String)"block/water_still"));

    public CauldronBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    public void render(@NotNull CauldronBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        if (blockEntity.getFluidTank().getFluidAmount() > 0) {
            double le = (double)blockEntity.getFluidTank().getFluidAmount() / (double)1000 * (double)3;
            this.renderWater(poseStack, bufferSource, (int)le, blockEntity.getColor(), packedLight, packedOverlay);
            if (((Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.LIT)).booleanValue() && blockEntity.getLevel() != null) {
                Level level = blockEntity.getLevel();
                Intrinsics.checkNotNull((Object)level);
                if (level.random.nextDouble() < 0.25) {
                    this.addBubble(blockEntity, blockEntity.getColor(), le);
                }
            }
        }
    }

    private final void addBubble(CauldronBlockEntity cauldron, int color, double fluidLevel) {
        BlockPos pos = cauldron.getBlockPos();
        Level level = cauldron.getLevel();
        Intrinsics.checkNotNull((Object)level);
        ParticleOptions particleOptions = new ColorBubbleData((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        double d = (double)pos.getX() + 0.5;
        Level level2 = cauldron.getLevel();
        Intrinsics.checkNotNull((Object)level2);
        double d2 = d + Mth.nextDouble((RandomSource)level2.random, (double)-0.25, (double)0.25);
        double d3 = (double)pos.getY() + fluidLevel * 0.25;
        double d4 = (double)pos.getZ() + 0.5;
        Level level3 = cauldron.getLevel();
        Intrinsics.checkNotNull((Object)level3);
        level.addAlwaysVisibleParticle(particleOptions, true, d2, d3, d4 + Mth.nextDouble((RandomSource)level3.random, (double)-0.25, (double)0.25), 0.0, 0.0, 0.0);
    }

    private final void renderWater(PoseStack poseStack, MultiBufferSource bufferSource, int fluidLevel, int color, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.0, ((double)fluidLevel - 3.0) / (double)4, 0.0);
        poseStack.translate(0.0, 1.0, 0.0);
        TextureAtlasSprite material = WATER_STILL.sprite();
        float maxV = (material.getV1() - material.getV0()) * 0.125f;
        float minV = (material.getV1() - material.getV0()) * 0.875f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)material.atlasLocation()));
        Matrix4f mat = poseStack.last().pose();
        Intrinsics.checkNotNull((Object)vertexConsumer);
        Intrinsics.checkNotNull((Object)mat);
        this.addVertex(vertexConsumer, mat, 0.125f, 0.0f, 0.875f, material.getU0(), material.getV0() + maxV, red, green, blue, packedLight, packedOverlay);
        this.addVertex(vertexConsumer, mat, 0.875f, 0.0f, 0.875f, material.getU1(), material.getV0() + maxV, red, green, blue, packedLight, packedOverlay);
        this.addVertex(vertexConsumer, mat, 0.875f, 0.0f, 0.125f, material.getU1(), material.getV0() + minV, red, green, blue, packedLight, packedOverlay);
        this.addVertex(vertexConsumer, mat, 0.125f, 0.0f, 0.125f, material.getU0(), material.getV0() + minV, red, green, blue, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private final void addVertex(VertexConsumer vertexConsumer, Matrix4f mat, float x, float y, float z, float u, float v, int red, int green, int blue, int packedLight, int packedOverlay) {
        vertexConsumer.addVertex(mat, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setLight(packedLight).setOverlay(packedOverlay).setNormal(1.0f, 1.0f, 1.0f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/client/renderer/block/CauldronBlockEntityRenderer$Companion;", "", "<init>", "()V", "WATER_STILL", "Lnet/minecraft/client/resources/model/Material;", "getWATER_STILL", "()Lnet/minecraft/client/resources/model/Material;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Material getWATER_STILL() {
            return WATER_STILL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

