/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.content.block.critter_snare.CritterSnareBlock;
import dev.sterner.witchery.content.block.critter_snare.CritterSnareBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/client/renderer/block/CritterSnareBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/critter_snare/CritterSnareBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class CritterSnareBlockEntityRenderer
implements BlockEntityRenderer<CritterSnareBlockEntity> {
    public CritterSnareBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    public void render(@NotNull CritterSnareBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        poseStack.translate(0.5, 0.2, 0.5);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        if (blockEntity.getBlockState().hasProperty((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) && blockEntity.getBlockState().getValue((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) != CritterSnareBlock.CapturedEntity.NONE) {
            CritterSnareBlock.CapturedEntity state;
            CritterSnareBlock.CapturedEntity capturedEntity = state = (CritterSnareBlock.CapturedEntity)((Object)blockEntity.getBlockState().getValue((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()));
            EntityType entityType = switch (capturedEntity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[capturedEntity.ordinal()]) {
                case 1 -> EntityType.BAT;
                case 2 -> EntityType.SLIME;
                default -> EntityType.SILVERFISH;
            };
            Level level = blockEntity.getLevel();
            Intrinsics.checkNotNull((Object)level);
            Mob entity = (Mob)entityType.create(level);
            if (entity != null) {
                if (entity instanceof Slime) {
                    ((Slime)entity).setSize(1, false);
                }
                if (entity instanceof Bat) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.0, -0.6, 0.0);
                    ((Bat)entity).setResting(true);
                    ((Bat)entity).flyAnimationState.stop();
                    ((Bat)entity).restAnimationState.startIfStopped(0);
                }
                if (entity instanceof Silverfish) {
                    ((Silverfish)entity).setYBodyRot(0.0f);
                    ((Silverfish)entity).tickCount = 0;
                }
                entity.yBodyRot = 0.0f;
                entity.yBodyRotO = 0.0f;
                entity.yRotO = 0.0f;
                entity.setYRot(0.0f);
                entity.yHeadRot = 0.0f;
                entity.yHeadRotO = 0.0f;
                Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity).render((Entity)entity, 0.0f, 0.0f, poseStack, bufferSource, packedLight);
            }
        }
        poseStack.popPose();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CritterSnareBlock.CapturedEntity.values().length];
            try {
                nArray[CritterSnareBlock.CapturedEntity.BAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CritterSnareBlock.CapturedEntity.SLIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

