/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.SpectreEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B!\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ=\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ldev/sterner/witchery/client/renderer/entity/AbstractGhostEntityRenderer;", "T", "Lnet/minecraft/world/entity/Mob;", "M", "Lnet/minecraft/client/model/EntityModel;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "model", "shadowRadius", "", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Lnet/minecraft/client/model/EntityModel;F)V", "render", "", "entity", "entityYaw", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "(Lnet/minecraft/world/entity/Mob;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "(Lnet/minecraft/world/entity/Mob;)Lnet/minecraft/resources/ResourceLocation;", "witchery"})
public abstract class AbstractGhostEntityRenderer<T extends Mob, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    public AbstractGhostEntityRenderer(@NotNull EntityRendererProvider.Context context, @NotNull M model, float shadowRadius) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super(context, model, shadowRadius);
    }

    public /* synthetic */ AbstractGhostEntityRenderer(EntityRendererProvider.Context context, EntityModel entityModel, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.6f;
        }
        this(context, entityModel, f);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        int alpha;
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long timeOfDay = ((Entity)entity).level().getDayTime() % (long)24000;
        int n = alpha = (0L <= timeOfDay ? timeOfDay < 12001L : false) ? 10 : 100;
        if (((Boolean)((Entity)entity).getEntityData().get(SpectreEntity.Companion.getREVEALED())).booleanValue()) {
            alpha = 255;
        }
        int color = alpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity)));
        poseStack.pushPose();
        float f = Mth.rotLerp((float)partialTicks, (float)((Mob)entity).yBodyRotO, (float)((Mob)entity).yBodyRot);
        float ix = ((LivingEntity)entity).getScale();
        poseStack.scale(ix, ix, ix);
        float k = this.getBob((LivingEntity)entity, partialTicks);
        this.setupRotations((LivingEntity)entity, poseStack, k, f, partialTicks, ix);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entity, poseStack, partialTicks);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        float l = 0.0f;
        float m = 0.0f;
        if (!((Entity)entity).isPassenger() && ((LivingEntity)entity).isAlive()) {
            l = ((Mob)entity).walkAnimation.speed(partialTicks);
            m = ((Mob)entity).walkAnimation.position(partialTicks);
            if (((LivingEntity)entity).isBaby()) {
                m *= 3.0f;
            }
            if (l > 1.0f) {
                l = 1.0f;
            }
        }
        float j = Mth.lerp((float)partialTicks, (float)((Mob)entity).xRotO, (float)((Entity)entity).getXRot());
        float g = Mth.rotLerp((float)partialTicks, (float)((Mob)entity).yHeadRotO, (float)((Mob)entity).yHeadRot);
        float h = g - f;
        this.model.prepareMobModel((Entity)entity, m, l, partialTicks);
        this.model.setupAnim((Entity)entity, m, l, k, h, j);
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = this.isBodyVisible((LivingEntity)entity);
        boolean bl2 = !bl && !((Entity)entity).isInvisibleTo((Player)minecraft.player);
        boolean bl3 = minecraft.shouldEntityAppearGlowing((Entity)entity);
        RenderType renderType = this.getRenderType((LivingEntity)entity, bl, bl2, bl3);
        if (renderType != null) {
            int n2 = MobRenderer.getOverlayCoords((LivingEntity)((LivingEntity)entity), (float)this.getWhiteOverlayProgress((LivingEntity)entity, partialTicks));
            ((Model)this.model).renderToBuffer(poseStack, vertexConsumer, packedLight, n2, color);
        }
        poseStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/entity/spectre.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }
}

