/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.layer.HornedHuntsmanEmissiveLayer;
import dev.sterner.witchery.client.model.HornedHuntsmanModel;
import dev.sterner.witchery.content.entity.HornedHuntsmanEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J8\u0010\u0011\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0010H\u0014\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/client/renderer/entity/HornedHuntsmanEntityRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;", "Ldev/sterner/witchery/client/model/HornedHuntsmanModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "entity", "scale", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "partialTick", "", "setupRotations", "ageInTicks", "rotationYaw", "Companion", "witchery"})
public final class HornedHuntsmanEntityRenderer
extends MobRenderer<HornedHuntsmanEntity, HornedHuntsmanModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final ResourceLocation TEXTURE = Witchery.Companion.id("textures/entity/horned_huntsman.png");

    public HornedHuntsmanEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModelPart modelPart = context.bakeLayer(HornedHuntsmanModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        super(context, (EntityModel)new HornedHuntsmanModel(modelPart), 0.7f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer(new HornedHuntsmanEmissiveLayer(this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull HornedHuntsmanEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = TEXTURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"TEXTURE");
        return resourceLocation;
    }

    protected void scale(@NotNull HornedHuntsmanEntity entity, @NotNull PoseStack poseStack, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        float scale = 1.5f;
        poseStack.scale(scale, scale, scale);
        super.scale((LivingEntity)entity, poseStack, partialTick);
    }

    protected void setupRotations(@NotNull HornedHuntsmanEntity entity, @NotNull PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float scale) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        super.setupRotations((LivingEntity)entity, poseStack, ageInTicks, rotationYaw, partialTick, scale);
        if (!entity.isAttacking() && entity.hasSpear()) {
            float swayAmount = Mth.sin((float)(ageInTicks * 0.05f)) * 0.03f;
            poseStack.mulPose(Axis.XP.rotationDegrees(swayAmount));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/sterner/witchery/client/renderer/entity/HornedHuntsmanEntityRenderer$Companion;", "", "<init>", "()V", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

