/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.HuntsmanSpearModel;
import dev.sterner.witchery.content.entity.HuntsmanSpearEntity;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/client/renderer/entity/HuntsmanSpearRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Ldev/sterner/witchery/content/entity/HuntsmanSpearEntity;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "model", "Ldev/sterner/witchery/client/model/HuntsmanSpearModel;", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "Companion", "witchery"})
public final class HuntsmanSpearRenderer
extends EntityRenderer<HuntsmanSpearEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HuntsmanSpearModel model;
    private static final ResourceLocation TEXTURE = Witchery.Companion.id("textures/entity/huntsman_spear.png");

    public HuntsmanSpearRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        ModelPart modelPart = context.bakeLayer(HuntsmanSpearModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new HuntsmanSpearModel(modelPart);
    }

    public void render(@NotNull HuntsmanSpearEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) + 90.0f));
        VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getTextureLocation(entity)), (boolean)false, (boolean)false);
        Intrinsics.checkNotNull((Object)vertexConsumer);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        if (((Boolean)entity.getEntityData().get(HuntsmanSpearEntity.Companion.getID_THROWN_BY_HUNTSMAN())).booleanValue()) {
            RenderType renderType = RenderType.energySwirl((ResourceLocation)TEXTURE, (float)((float)entity.tickCount * 0.01f % 1.0f), (float)((float)entity.tickCount * 0.01f % 1.0f));
            VertexConsumer energyVertexConsumer = buffer.getBuffer(renderType);
            poseStack.scale(1.1f, 1.1f, 1.1f);
            Intrinsics.checkNotNull((Object)energyVertexConsumer);
            this.model.renderToBuffer(poseStack, energyVertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY, new Color(255, 255, 60, 100).getRGB());
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull HuntsmanSpearEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = TEXTURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"TEXTURE");
        return resourceLocation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/sterner/witchery/client/renderer/entity/HuntsmanSpearRenderer$Companion;", "", "<init>", "()V", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

