/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.content.entity.InsanityEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001:\u00010B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\u001dH\u0014J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J(\u0010)\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,H\u0014J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ldev/sterner/witchery/client/renderer/entity/InsanityEntityRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/sterner/witchery/content/entity/InsanityEntity;", "Lnet/minecraft/client/model/EntityModel;", "ctx", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "creeperModel", "Lnet/minecraft/client/model/CreeperModel;", "zombieModel", "Lnet/minecraft/client/model/HumanoidModel;", "skeletonModel", "endermanModel", "creeperTexture", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "zombieTexture", "skeletonTexture", "endermanTexture", "createZombieModel", "modelPart", "Lnet/minecraft/client/model/geom/ModelPart;", "createEndermanModel", "getTextureLocation", "entity", "render", "", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "scale", "livingEntity", "partialTickTime", "getWhiteOverlayProgress", "getRenderType", "Lnet/minecraft/client/renderer/RenderType;", "visibility", "", "transparentVisibility", "glowing", "getShadowRadius", "DummyModel", "witchery"})
public final class InsanityEntityRenderer
extends MobRenderer<InsanityEntity, EntityModel<InsanityEntity>> {
    @NotNull
    private final CreeperModel<InsanityEntity> creeperModel;
    @NotNull
    private final HumanoidModel<InsanityEntity> zombieModel;
    @NotNull
    private final HumanoidModel<InsanityEntity> skeletonModel;
    @NotNull
    private final EntityModel<InsanityEntity> endermanModel;
    private final ResourceLocation creeperTexture;
    private final ResourceLocation zombieTexture;
    private final ResourceLocation skeletonTexture;
    private final ResourceLocation endermanTexture;

    public InsanityEntityRenderer(@NotNull EntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx, (EntityModel)new DummyModel(), 0.5f);
        this.creeperModel = new CreeperModel(ctx.bakeLayer(ModelLayers.CREEPER));
        ModelPart modelPart = ctx.bakeLayer(ModelLayers.ZOMBIE);
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.zombieModel = this.createZombieModel(modelPart);
        this.skeletonModel = new HumanoidModel(ctx.bakeLayer(ModelLayers.SKELETON));
        ModelPart modelPart2 = ctx.bakeLayer(ModelLayers.ENDERMAN);
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.endermanModel = this.createEndermanModel(modelPart2);
        this.creeperTexture = ResourceLocation.withDefaultNamespace((String)"textures/entity/creeper/creeper.png");
        this.zombieTexture = ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/zombie.png");
        this.skeletonTexture = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");
        this.endermanTexture = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderman/enderman.png");
    }

    private final HumanoidModel<InsanityEntity> createZombieModel(ModelPart modelPart) {
        return (HumanoidModel)new HumanoidModel<InsanityEntity>(modelPart){

            public void setupAnim(InsanityEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
                super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.rightArm.xRot = -1.5f;
                this.rightArm.yRot = 0.0f;
                this.rightArm.zRot = 0.0f;
                this.leftArm.xRot = -1.5f;
                this.leftArm.yRot = 0.0f;
                this.leftArm.zRot = 0.0f;
                ModelPart modelPart = this.rightArm;
                modelPart.xRot += Mth.cos((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount;
                modelPart = this.leftArm;
                modelPart.xRot += Mth.cos((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount;
                this.head.zRot = Mth.cos((float)(limbSwing * 0.3f)) * 0.15f * limbSwingAmount;
            }
        };
    }

    private final EntityModel<InsanityEntity> createEndermanModel(ModelPart modelPart) {
        return (EntityModel)new EntityModel<InsanityEntity>(modelPart){
            private final ModelPart root;
            private final ModelPart head;
            private final ModelPart body;
            private final ModelPart rightArm;
            private final ModelPart leftArm;
            private final ModelPart rightLeg;
            private final ModelPart leftLeg;
            {
                this.root = $modelPart;
                this.head = $modelPart.getChild("head");
                this.body = $modelPart.getChild("body");
                this.rightArm = $modelPart.getChild("right_arm");
                this.leftArm = $modelPart.getChild("left_arm");
                this.rightLeg = $modelPart.getChild("right_leg");
                this.leftLeg = $modelPart.getChild("left_leg");
            }

            public void setupAnim(InsanityEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
                this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
                this.head.xRot = headPitch * ((float)Math.PI / 180);
                this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
                this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
                this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            }

            public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
                Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                this.root.render(poseStack, buffer, packedLight, packedOverlay, color);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull InsanityEntity entity) {
        block8: {
            block6: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                    var2_2 = (String)entity.getEntityData().get(InsanityEntity.Companion.getDATA_MIMIC());
                    if (var2_2 == null) break block6;
                    switch (var2_2.hashCode()) {
                        case 2027747405: {
                            if (!var2_2.equals("skeleton")) {
                                ** break;
                            }
                            break block7;
                        }
                        case -696355290: {
                            if (var2_2.equals("zombie")) break;
                            ** break;
                        }
                        case 1028669806: {
                            if (!var2_2.equals("creeper")) ** break;
                            v0 = this.creeperTexture;
                            v1 = v0;
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"creeperTexture");
                            break block8;
                        }
                    }
                    v2 = this.zombieTexture;
                    v1 = v2;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"zombieTexture");
                    break block8;
                }
                v3 = this.skeletonTexture;
                v1 = v3;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"skeletonTexture");
                break block8;
            }
            v4 = this.endermanTexture;
            v1 = v4;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"endermanTexture");
        }
        return v1;
    }

    /*
     * Unable to fully structure code
     */
    public void render(@NotNull InsanityEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        block8: {
            block6: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                    Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
                    Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                    var8_7 = (String)entity.getEntityData().get(InsanityEntity.Companion.getDATA_MIMIC());
                    if (var8_7 == null) break block6;
                    switch (var8_7.hashCode()) {
                        case 2027747405: {
                            if (!var8_7.equals("skeleton")) {
                                ** break;
                            }
                            break block7;
                        }
                        case -696355290: {
                            if (var8_7.equals("zombie")) break;
                            ** break;
                        }
                        case 1028669806: {
                            if (!var8_7.equals("creeper")) ** break;
                            v0 = (EntityModel)this.creeperModel;
                            break block8;
                        }
                    }
                    v0 = (EntityModel)this.zombieModel;
                    break block8;
                }
                v0 = (EntityModel)this.skeletonModel;
                break block8;
            }
            v0 = this.endermanModel;
        }
        currentModel = insanityModel = v0;
        $i$a$-let-InsanityEntityRenderer$render$1 = false;
        this.model = currentModel;
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(@NotNull InsanityEntity livingEntity, @NotNull PoseStack poseStack, float partialTickTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)livingEntity), (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        float f = livingEntity.getSwelling(partialTickTime);
        float g = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float h = (1.0f + f * 0.4f) * g;
        float i = (1.0f + f * 0.1f) / g;
        poseStack.scale(h, i, h);
    }

    protected float getWhiteOverlayProgress(@NotNull InsanityEntity livingEntity, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)((Object)livingEntity), (String)"livingEntity");
        float f = livingEntity.getSwelling(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    @NotNull
    protected RenderType getRenderType(@NotNull InsanityEntity entity, boolean visibility, boolean transparentVisibility, boolean glowing) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        RenderType renderType = RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity));
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"entityTranslucent(...)");
        return renderType;
    }

    protected float getShadowRadius(@NotNull InsanityEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        String string = (String)entity.getEntityData().get(InsanityEntity.Companion.getDATA_MIMIC());
        return Intrinsics.areEqual((Object)string, (Object)"enderman") ? 0.7f : (Intrinsics.areEqual((Object)string, (Object)"creeper") ? 0.5f : 0.5f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J0\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/client/renderer/entity/InsanityEntityRenderer$DummyModel;", "Lnet/minecraft/client/model/EntityModel;", "Ldev/sterner/witchery/content/entity/InsanityEntity;", "<init>", "()V", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "renderToBuffer", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "witchery"})
    private static final class DummyModel
    extends EntityModel<InsanityEntity> {
        public void setupAnim(@NotNull InsanityEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        }

        public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        }
    }
}

