/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.NightmareEntityModel;
import dev.sterner.witchery.content.entity.NightmareEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/client/renderer/entity/NightmareEntityRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/sterner/witchery/content/entity/NightmareEntity;", "Ldev/sterner/witchery/client/model/NightmareEntityModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "witchery"})
public final class NightmareEntityRenderer
extends MobRenderer<NightmareEntity, NightmareEntityModel> {
    public NightmareEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModelPart modelPart = context.bakeLayer(NightmareEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        super(context, (EntityModel)new NightmareEntityModel(modelPart), 0.3f);
    }

    public void render(@NotNull NightmareEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int alpha = 255;
        if (((Boolean)entity.getEntityData().get(NightmareEntity.Companion.getINTANGIBLE())).booleanValue()) {
            alpha = 100;
        }
        int color = alpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity)));
        poseStack.pushPose();
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float ix = entity.getScale();
        poseStack.scale(ix, ix, ix);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        float k = this.getBob((LivingEntity)entity, partialTicks);
        this.setupRotations((LivingEntity)entity, poseStack, k, f, partialTicks, ix);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entity, poseStack, partialTicks);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        float l = 0.0f;
        float m = 0.0f;
        if (!entity.isPassenger() && entity.isAlive()) {
            l = entity.walkAnimation.speed(partialTicks);
            m = entity.walkAnimation.position(partialTicks);
            if (entity.isBaby()) {
                m *= 3.0f;
            }
            if (l > 1.0f) {
                l = 1.0f;
            }
        }
        float j = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        float g = Mth.rotLerp((float)partialTicks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float h = g - f;
        ((NightmareEntityModel)this.model).prepareMobModel((Entity)entity, m, l, partialTicks);
        ((NightmareEntityModel)this.model).setupAnim(entity, m, l, k, h, j);
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = this.isBodyVisible((LivingEntity)entity);
        boolean bl2 = !bl && !entity.isInvisibleTo((Player)minecraft.player);
        boolean bl3 = minecraft.shouldEntityAppearGlowing((Entity)entity);
        RenderType renderType = this.getRenderType((LivingEntity)entity, bl, bl2, bl3);
        if (renderType != null) {
            int n = MobRenderer.getOverlayCoords((LivingEntity)((LivingEntity)entity), (float)this.getWhiteOverlayProgress((LivingEntity)entity, partialTicks));
            NightmareEntityModel nightmareEntityModel = (NightmareEntityModel)this.model;
            Intrinsics.checkNotNull((Object)vertexConsumer);
            nightmareEntityModel.renderToBuffer(poseStack, vertexConsumer, packedLight, n, color);
        }
        poseStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull NightmareEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/entity/nightmare.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }
}

