/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.content.entity.SpectralPigEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/client/renderer/entity/SpectralPigRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/sterner/witchery/content/entity/SpectralPigEntity;", "Lnet/minecraft/client/model/PigModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "getRenderType", "Lnet/minecraft/client/renderer/RenderType;", "livingEntity", "bodyVisible", "", "translucent", "glowing", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "witchery"})
public final class SpectralPigRenderer
extends MobRenderer<SpectralPigEntity, PigModel<SpectralPigEntity>> {
    public SpectralPigRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, (EntityModel)new PigModel(context.bakeLayer(ModelLayers.PIG)), 0.0f);
    }

    public void render(@NotNull SpectralPigEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        poseStack.pushPose();
        ((PigModel)this.model).attackTime = this.getAttackAnim((LivingEntity)entity, partialTicks);
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float g = Mth.rotLerp((float)partialTicks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float h = g - f;
        float j = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        if (MobRenderer.isEntityUpsideDown((LivingEntity)((LivingEntity)entity))) {
            j *= -1.0f;
            h *= -1.0f;
        }
        h = Mth.wrapDegrees((float)h);
        float ix = entity.getScale();
        poseStack.scale(ix, ix, ix);
        float k = this.getBob((LivingEntity)entity, partialTicks);
        this.setupRotations((LivingEntity)entity, poseStack, k, f, partialTicks, ix);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entity, poseStack, partialTicks);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        float l = 0.0f;
        float m = 0.0f;
        if (entity.isAlive()) {
            l = entity.walkAnimation.speed(partialTicks);
            m = entity.walkAnimation.position(partialTicks);
            if (l > 1.0f) {
                l = 1.0f;
            }
        }
        ((PigModel)this.model).prepareMobModel((Entity)entity, m, l, partialTicks);
        ((PigModel)this.model).setupAnim((Entity)entity, m, l, k, h, j);
        int alpha = 20;
        if (((Boolean)entity.getEntityData().get(SpectralPigEntity.Companion.getREVEALED())).booleanValue()) {
            alpha = 160;
        }
        int color = alpha << 24 | 0xAA0000 | 0xFF00 | 0xFF;
        ResourceLocation resourceLocation = this.getTextureLocation(entity);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)resourceLocation));
        int n = MobRenderer.getOverlayCoords((LivingEntity)((LivingEntity)entity), (float)this.getWhiteOverlayProgress((LivingEntity)entity, partialTicks));
        ((PigModel)this.model).renderToBuffer(poseStack, vertexConsumer, packedLight, n, color);
        for (RenderLayer renderLayer : this.layers) {
            renderLayer.render(poseStack, buffer, packedLight, (Entity)entity, m, l, partialTicks, k, h, j);
        }
        poseStack.popPose();
    }

    @Nullable
    protected RenderType getRenderType(@NotNull SpectralPigEntity livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        Intrinsics.checkNotNullParameter((Object)((Object)livingEntity), (String)"livingEntity");
        ResourceLocation resourceLocation = this.getTextureLocation(livingEntity);
        return RenderType.entityTranslucent((ResourceLocation)resourceLocation);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SpectralPigEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"textures/entity/pig/pig.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withDefaultNamespace(...)");
        return resourceLocation;
    }
}

