/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.content.entity.ThrownBrewEntity;
import dev.sterner.witchery.content.item.brew.BrewItem;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/client/renderer/entity/ThrownBrewRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Ldev/sterner/witchery/content/entity/ThrownBrewEntity;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "itemRenderer", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "scale", "", "render", "", "entity", "entityYaw", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "renderTintedQuartzSphere", "brew", "Ldev/sterner/witchery/content/item/brew/BrewItem;", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "Companion", "TintedVertexConsumer", "witchery"})
public final class ThrownBrewRenderer
extends EntityRenderer<ThrownBrewEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemRenderer itemRenderer;
    private final float scale;
    private static final float MIN_CAMERA_DISTANCE_SQUARED = 12.25f;

    public ThrownBrewRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        ItemRenderer itemRenderer = context.getItemRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)itemRenderer, (String)"getItemRenderer(...)");
        this.itemRenderer = itemRenderer;
        this.scale = 1.0f;
    }

    public void render(@NotNull ThrownBrewEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (entity.tickCount < 2 && this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)entity) < 12.25) {
            return;
        }
        ItemStack itemStack = entity.getItem();
        if (entity.isQuartzSphere() && itemStack.getItem() instanceof BrewItem) {
            Item item = itemStack.getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.item.brew.BrewItem");
            this.renderTintedQuartzSphere(entity, poseStack, buffer, packedLight, (BrewItem)item);
            super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
            return;
        }
        poseStack.pushPose();
        poseStack.scale(this.scale, this.scale, this.scale);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private final void renderTintedQuartzSphere(ThrownBrewEntity entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, BrewItem brew) {
        poseStack.pushPose();
        poseStack.scale(this.scale, this.scale, this.scale);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        int brewColor = brew.getColor();
        float red = (float)(brewColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(brewColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(brewColor & 0xFF) / 255.0f;
        ItemStack sphereStack = new ItemStack((ItemLike)WitcheryItems.INSTANCE.getQUARTZ_SPHERE().get());
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.0f, 1.0f);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)this.getTextureLocation(entity)));
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        TintedVertexConsumer glowBuffer = new TintedVertexConsumer(vertexConsumer, red, green, blue, 0.9f);
        BakedModel model = this.itemRenderer.getModel(sphereStack, entity.level(), null, entity.getId());
        this.itemRenderer.render(sphereStack, ItemDisplayContext.GROUND, false, poseStack, arg_0 -> ThrownBrewRenderer.renderTintedQuartzSphere$lambda$0(glowBuffer, arg_0), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        poseStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ThrownBrewEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = TextureAtlas.LOCATION_BLOCKS;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"LOCATION_BLOCKS");
        return resourceLocation;
    }

    private static final VertexConsumer renderTintedQuartzSphere$lambda$0(TintedVertexConsumer $glowBuffer, RenderType renderType) {
        return $glowBuffer;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/client/renderer/entity/ThrownBrewRenderer$Companion;", "", "<init>", "()V", "MIN_CAMERA_DISTANCE_SQUARED", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J(\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J \u0010\u0019\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/client/renderer/entity/ThrownBrewRenderer$TintedVertexConsumer;", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "delegate", "r", "", "g", "b", "a", "<init>", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFF)V", "addVertex", "x", "y", "z", "setColor", "red", "", "green", "blue", "alpha", "setUv", "u", "v", "setUv1", "setUv2", "setNormal", "witchery"})
    private static final class TintedVertexConsumer
    implements VertexConsumer {
        @NotNull
        private final VertexConsumer delegate;
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public TintedVertexConsumer(@NotNull VertexConsumer delegate, float r, float g, float b, float a) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        @NotNull
        public VertexConsumer addVertex(float x, float y, float z) {
            VertexConsumer vertexConsumer = this.delegate.addVertex(x, y, z);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"addVertex(...)");
            return vertexConsumer;
        }

        @NotNull
        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            int tintedR = RangesKt.coerceIn((int)((int)((float)red * this.r)), (int)0, (int)255);
            int tintedG = RangesKt.coerceIn((int)((int)((float)green * this.g)), (int)0, (int)255);
            int tintedB = RangesKt.coerceIn((int)((int)((float)blue * this.b)), (int)0, (int)255);
            int tintedA = RangesKt.coerceIn((int)((int)((float)alpha * this.a)), (int)0, (int)255);
            VertexConsumer vertexConsumer = this.delegate.setColor(tintedR, tintedG, tintedB, tintedA);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"setColor(...)");
            return vertexConsumer;
        }

        @NotNull
        public VertexConsumer setUv(float u, float v) {
            VertexConsumer vertexConsumer = this.delegate.setUv(u, v);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"setUv(...)");
            return vertexConsumer;
        }

        @NotNull
        public VertexConsumer setUv1(int u, int v) {
            VertexConsumer vertexConsumer = this.delegate.setUv1(u, v);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"setUv1(...)");
            return vertexConsumer;
        }

        @NotNull
        public VertexConsumer setUv2(int u, int v) {
            VertexConsumer vertexConsumer = this.delegate.setUv2(u, v);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"setUv2(...)");
            return vertexConsumer;
        }

        @NotNull
        public VertexConsumer setNormal(float x, float y, float z) {
            VertexConsumer vertexConsumer = this.delegate.setNormal(x, y, z);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"setNormal(...)");
            return vertexConsumer;
        }
    }
}

