/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.tarot;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryKeyMappings;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import java.awt.Color;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J0\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J0\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0005H\u0002JH\u0010\"\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/sterner/witchery/client/tarot/TarotCardHudRenderer;", "", "<init>", "()V", "CARD_SCALE", "", "CARD_SPACING", "HUD_PADDING", "ANIMATION_SPEED", "hoveredCardIndex", "", "Ljava/lang/Integer;", "isMenuOpen", "", "animationProgress", "onRenderGuiOverlay", "", "event", "Lnet/neoforged/neoforge/client/event/RenderGuiLayerEvent$Post;", "onClientTick", "Lnet/neoforged/neoforge/client/event/ClientTickEvent$Post;", "openMenu", "closeMenu", "checkHover", "data", "Ldev/sterner/witchery/features/tarot/TarotPlayerAttachment$Data;", "screenWidth", "screenHeight", "mouseX", "mouseY", "renderTarotCards", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "partialTick", "renderMiniCard", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "cardNumber", "isReversed", "x", "y", "isHovered", "getCardTexture", "Lnet/minecraft/resources/ResourceLocation;", "easeOutCubic", "t", "witchery"})
public final class TarotCardHudRenderer {
    @NotNull
    public static final TarotCardHudRenderer INSTANCE = new TarotCardHudRenderer();
    private static final float CARD_SCALE = 0.5f;
    private static final float CARD_SPACING = 4.0f;
    private static final float HUD_PADDING = 10.0f;
    private static final float ANIMATION_SPEED = 0.15f;
    @Nullable
    private static Integer hoveredCardIndex;
    private static boolean isMenuOpen;
    private static float animationProgress;

    private TarotCardHudRenderer() {
    }

    @SubscribeEvent
    public final void onRenderGuiOverlay(@NotNull RenderGuiLayerEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getName(), (Object)VanillaGuiLayers.HOTBAR)) {
            return;
        }
        if (animationProgress <= 0.0f) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)player);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        Intrinsics.checkNotNull((Object)guiGraphics);
        this.renderTarotCards(guiGraphics, data2, screenWidth, screenHeight, event.getPartialTick().getGameTimeDeltaTicks());
    }

    @SubscribeEvent
    public final void onClientTick(@NotNull ClientTickEvent.Post event) {
        boolean shouldBeOpen;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)player);
        boolean bl = shouldBeOpen = !((Collection)data2.getDrawnCards()).isEmpty() && WitcheryKeyMappings.INSTANCE.getUTILITY_BUTTON().isDown();
        if (shouldBeOpen && !isMenuOpen) {
            this.openMenu();
        } else if (!shouldBeOpen && isMenuOpen) {
            this.closeMenu();
        }
        if (isMenuOpen && animationProgress < 1.0f) {
            animationProgress = Math.min(1.0f, animationProgress + 0.15f);
        } else if (!isMenuOpen && animationProgress > 0.0f) {
            animationProgress = Math.max(0.0f, animationProgress - 0.15f);
        }
        if (isMenuOpen && !((Collection)data2.getDrawnCards()).isEmpty()) {
            double mouseX = minecraft.mouseHandler.xpos() * (double)minecraft.getWindow().getGuiScaledWidth() / (double)minecraft.getWindow().getScreenWidth();
            double mouseY = minecraft.mouseHandler.ypos() * (double)minecraft.getWindow().getGuiScaledHeight() / (double)minecraft.getWindow().getScreenHeight();
            this.checkHover(data2, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight(), (float)mouseX, (float)mouseY);
        } else {
            hoveredCardIndex = null;
        }
    }

    private final void openMenu() {
        isMenuOpen = true;
        animationProgress = 0.0f;
    }

    private final void closeMenu() {
        isMenuOpen = false;
    }

    private final void checkHover(TarotPlayerAttachment.Data data2, int screenWidth, int screenHeight, float mouseX, float mouseY) {
        hoveredCardIndex = null;
        float scaledCardWidth = 23.0f;
        float scaledCardHeight = 40.5f;
        int hotbarWidth = 182;
        float hotbarX = (float)(screenWidth - hotbarWidth) / 2.0f;
        float hotbarY = (float)screenHeight - 22.0f;
        float startX = hotbarX + (float)hotbarWidth + 10.0f;
        float targetY = hotbarY - scaledCardHeight / 2.0f + 11.0f;
        float startY = screenHeight;
        float currentY = Mth.lerp((float)this.easeOutCubic(animationProgress), (float)startY, (float)targetY);
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            float x = startX + (float)i * (scaledCardWidth + 4.0f);
            float y = currentY;
            if (!(mouseX >= x) || !(mouseX <= x + scaledCardWidth) || !(mouseY >= y) || !(mouseY <= y + scaledCardHeight)) continue;
            hoveredCardIndex = i;
            break;
        }
    }

    private final void renderTarotCards(GuiGraphics guiGraphics, TarotPlayerAttachment.Data data2, int screenWidth, int screenHeight, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        float scaledCardWidth = 23.0f;
        float scaledCardHeight = 40.5f;
        int hotbarWidth = 182;
        float hotbarX = (float)(screenWidth - hotbarWidth) / 2.0f;
        float hotbarY = (float)screenHeight - 22.0f;
        float startX = hotbarX + (float)hotbarWidth + 10.0f;
        float targetY = hotbarY - scaledCardHeight / 2.0f;
        float startY = screenHeight;
        float currentY = Mth.lerp((float)this.easeOutCubic(animationProgress), (float)startY, (float)targetY);
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean isReversed = bl != null ? bl : false;
            float x = startX + (float)i * (scaledCardWidth + 4.0f);
            float y = currentY;
            Integer n2 = hoveredCardIndex;
            int n3 = i;
            boolean isHovered = n2 != null && n2 == n3;
            Intrinsics.checkNotNull((Object)poseStack);
            this.renderMiniCard(guiGraphics, poseStack, cardNumber, isReversed, x, y, isHovered, partialTick);
        }
    }

    private final void renderMiniCard(GuiGraphics guiGraphics, PoseStack poseStack, int cardNumber, boolean isReversed, float x, float y, boolean isHovered, float partialTick) {
        poseStack.pushPose();
        poseStack.translate((double)x, (double)y, 0.0);
        poseStack.scale(0.5f, 0.5f, 1.0f);
        if (isReversed) {
            poseStack.translate(23.0, 40.5, 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(-23.0, -40.5, 0.0);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float alpha = isHovered ? animationProgress : animationProgress * 0.85f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        ResourceLocation texture = this.getCardTexture(cardNumber);
        guiGraphics.blit(texture, 0, 0, 0.0f, 0.0f, 46, 81, 46, 81);
        if (isHovered) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.84f, (float)0.0f, (float)animationProgress);
            guiGraphics.renderOutline(0, 0, 46, 81, new Color(255, 215, 0, (int)((float)255 * animationProgress)).getRGB());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private final ResourceLocation getCardTexture(int cardNumber) {
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/gui/arcana/" + cardNumber + ".png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }

    private final float easeOutCubic(float t) {
        float t1 = t - 1.0f;
        return t1 * t1 * t1 + 1.0f;
    }
}

