/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.tooltip;

import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/client/tooltip/ClientUrnTooltipComponent;", "Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipComponent;", "potions", "", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Ljava/util/List;)V", "getHeight", "", "getWidth", "font", "Lnet/minecraft/client/gui/Font;", "renderImage", "", "x", "y", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderSlot", "stack", "drawBorder", "gridX", "gridY", "drawSlot", "gridSizeX", "gridSizeY", "witchery"})
public final class ClientUrnTooltipComponent
implements ClientTooltipComponent {
    @NotNull
    private final List<ItemStack> potions;

    public ClientUrnTooltipComponent(@NotNull List<ItemStack> potions) {
        Intrinsics.checkNotNullParameter(potions, (String)"potions");
        this.potions = potions;
    }

    public int getHeight() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int getWidth(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return this.gridSizeX() * 18 + 2;
    }

    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int gridX = this.gridSizeX();
        int gridY = this.gridSizeY();
        this.drawBorder(guiGraphics, x, y, gridX, gridY);
        int index = 0;
        block0: for (int row = 0; row < gridY; ++row) {
            for (int col = 0; col < gridX; ++col) {
                int itemX = x + col * 18 + 1;
                int itemY = y + row * 20 + 1;
                if (index >= this.potions.size()) continue block0;
                this.renderSlot(guiGraphics, itemX, itemY, this.potions.get(index), font);
                ++index;
            }
        }
    }

    private final void renderSlot(GuiGraphics guiGraphics, int x, int y, ItemStack stack, Font font) {
        this.drawSlot(guiGraphics, x, y);
        guiGraphics.renderItem(stack, x + 1, y + 1, 0);
        guiGraphics.renderItemDecorations(font, stack, x + 1, y + 1);
    }

    private final void drawBorder(GuiGraphics guiGraphics, int x, int y, int gridX, int gridY) {
        guiGraphics.fill(x, y, x + gridX * 18 + 2, y + gridY * 20 + 2, new Color(210, 180, 140).getRGB());
    }

    private final void drawSlot(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.fill(x, y, x + 18, y + 20, new Color(139, 115, 85).getRGB());
    }

    private final int gridSizeX() {
        return this.potions.isEmpty() ? 0 : (this.potions.size() <= 3 ? this.potions.size() : 3);
    }

    private final int gridSizeY() {
        return this.potions.isEmpty() ? 0 : (this.potions.size() + 2) / 3;
    }
}

