/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import dev.sterner.witchery.content.block.WitcheryCropBlock;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tH\u0014J(\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J:\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0014\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/content/block/MandrakeCropBlock;", "Ldev/sterner/witchery/content/block/WitcheryCropBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "randomTick", "state", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "playerDestroy", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "tool", "Lnet/minecraft/world/item/ItemStack;", "getBaseSeedId", "Lnet/minecraft/world/item/ItemNameBlockItem;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Companion", "witchery"})
public final class MandrakeCropBlock
extends WitcheryCropBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanProperty AWAKE;
    @NotNull
    private static final VoxelShape[] CUSTOM_SHAPE_BY_AGE;

    public MandrakeCropBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AWAKE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{AWAKE};
        StateDefinition.Builder builder2 = builder.add(propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"add(...)");
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder2);
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        super.randomTick(state, level, pos, random);
        long l = level.getDayTime();
        boolean bl = 0L <= l ? l < 12001L : false;
        if (bl && !((Boolean)state.getValue((Property)AWAKE)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)AWAKE, (Comparable)Boolean.valueOf(true)));
        } else {
            l = level.getDayTime();
            boolean bl2 = 12000L <= l ? l < 24001L : false;
            if (bl2 && (double)random.nextFloat() < 0.2) {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).cycle((Property)AWAKE));
            }
        }
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (level instanceof ServerLevel && ((Boolean)state.getValue((Property)AWAKE)).booleanValue()) {
            ((EntityType)WitcheryEntityTypes.INSTANCE.getMANDRAKE().get()).spawn((ServerLevel)level, pos, MobSpawnType.NATURAL);
        }
    }

    @NotNull
    protected ItemNameBlockItem getBaseSeedId() {
        Object object = WitcheryItems.INSTANCE.getMANDRAKE_SEEDS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemNameBlockItem)object;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Comparable comparable = state.getValue((Property)WitcheryCropBlock.Companion.getAGE());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        VoxelShape voxelShape = CUSTOM_SHAPE_BY_AGE[((Number)((Object)comparable)).intValue()];
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"get(...)");
        return voxelShape;
    }

    static {
        BooleanProperty booleanProperty = BooleanProperty.create((String)"awake");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        AWAKE = booleanProperty;
        VoxelShape[] voxelShapeArray = new VoxelShape[]{CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0)};
        CUSTOM_SHAPE_BY_AGE = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/block/MandrakeCropBlock$Companion;", "", "<init>", "()V", "AWAKE", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getAWAKE", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "CUSTOM_SHAPE_BY_AGE", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getCUSTOM_SHAPE_BY_AGE", "()[Lnet/minecraft/world/phys/shapes/VoxelShape;", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getAWAKE() {
            return AWAKE;
        }

        @NotNull
        public final VoxelShape[] getCUSTOM_SHAPE_BY_AGE() {
            return CUSTOM_SHAPE_BY_AGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

