/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.altar;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.altar.AltarBlock;
import dev.sterner.witchery.content.menu.AltarMenu;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.data.AltarAugmentReloadListener;
import dev.sterner.witchery.core.data.NaturePowerReloadListener;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.network.AltarMultiplierSyncS2CPayload;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 S2\u00020\u0001:\u0002RSB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u00102\u001a\n 4*\u0004\u0018\u00010303H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u000206H\u0002J\u000e\u0010:\u001a\u0002032\u0006\u0010;\u001a\u00020<J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020CH\u0002J\u000e\u0010D\u001a\u0002062\u0006\u00107\u001a\u000208J\u0010\u0010E\u001a\u0002062\u0006\u0010F\u001a\u000208H\u0016J\u0018\u0010G\u001a\u0002062\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0014J\u0018\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020I2\u0006\u0010N\u001a\u00020KH\u0014J\u0016\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020\u00122\u0006\u0010Q\u001a\u00020\tR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0014\"\u0004\b%\u0010\u0016R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00120+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u0010\u0016\u00a8\u0006T"}, d2={"Ldev/sterner/witchery/content/block/altar/AltarBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "powerUpdateQueued", "", "getPowerUpdateQueued", "()Z", "setPowerUpdateQueued", "(Z)V", "augmentUpdateQueued", "getAugmentUpdateQueued", "setAugmentUpdateQueued", "currentPower", "", "getCurrentPower", "()I", "setCurrentPower", "(I)V", "maxPower", "getMaxPower", "setMaxPower", "powerBoost", "", "getPowerBoost", "()D", "setPowerBoost", "(D)V", "powerMultiplier", "getPowerMultiplier", "setPowerMultiplier", "range", "getRange", "setRange", "data", "Lnet/minecraft/world/inventory/ContainerData;", "getData", "()Lnet/minecraft/world/inventory/ContainerData;", "limitTracker", "", "Lnet/minecraft/resources/ResourceLocation;", "getLimitTracker", "()Ljava/util/Map;", "ticks", "getTicks", "setTicks", "getLocalAABB", "Lnet/minecraft/world/phys/AABB;", "kotlin.jvm.PlatformType", "collectAllLocalNaturePower", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "updateCurrentPower", "getLocalAugmentAABB", "direction", "Lnet/minecraft/core/Direction;", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "openMenu", "player", "Lnet/minecraft/server/level/ServerPlayer;", "augmentAltar", "tickServer", "serverLevel", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "pTag", "pRegistries", "consumeAltarPower", "amount", "simulate", "Tuple4", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nAltarBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarBlockEntity.kt\ndev/sterner/witchery/content/block/altar/AltarBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1#2:383\n*E\n"})
public final class AltarBlockEntity
extends MultiBlockCoreEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean powerUpdateQueued;
    private boolean augmentUpdateQueued;
    private int currentPower;
    private int maxPower;
    private double powerBoost;
    private double powerMultiplier;
    private int range;
    @NotNull
    private final ContainerData data;
    @NotNull
    private final Map<ResourceLocation, Integer> limitTracker;
    private int ticks;

    public AltarBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getALTAR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockHorizontalDirectionStructure multiBlockHorizontalDirectionStructure = AltarBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockHorizontalDirectionStructure, (String)"get(...)");
        super(blockEntityType, multiBlockHorizontalDirectionStructure, pos, state);
        this.powerBoost = 1.0;
        this.powerMultiplier = 1.0;
        this.range = 16;
        this.data = new ContainerData(this){
            final /* synthetic */ AltarBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int index) {
                return switch (index) {
                    case 0 -> this.this$0.getCurrentPower();
                    case 1 -> this.this$0.getMaxPower();
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        this.this$0.setCurrentPower(value);
                        break;
                    }
                    case 1: {
                        this.this$0.setMaxPower(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        this.limitTracker = new LinkedHashMap();
        this.powerUpdateQueued = true;
        this.augmentUpdateQueued = true;
    }

    public final boolean getPowerUpdateQueued() {
        return this.powerUpdateQueued;
    }

    public final void setPowerUpdateQueued(boolean bl) {
        this.powerUpdateQueued = bl;
    }

    public final boolean getAugmentUpdateQueued() {
        return this.augmentUpdateQueued;
    }

    public final void setAugmentUpdateQueued(boolean bl) {
        this.augmentUpdateQueued = bl;
    }

    public final int getCurrentPower() {
        return this.currentPower;
    }

    public final void setCurrentPower(int n) {
        this.currentPower = n;
    }

    public final int getMaxPower() {
        return this.maxPower;
    }

    public final void setMaxPower(int n) {
        this.maxPower = n;
    }

    public final double getPowerBoost() {
        return this.powerBoost;
    }

    public final void setPowerBoost(double d) {
        this.powerBoost = d;
    }

    public final double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public final void setPowerMultiplier(double d) {
        this.powerMultiplier = d;
    }

    public final int getRange() {
        return this.range;
    }

    public final void setRange(int n) {
        this.range = n;
    }

    @NotNull
    public final ContainerData getData() {
        return this.data;
    }

    @NotNull
    public final Map<ResourceLocation, Integer> getLimitTracker() {
        return this.limitTracker;
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final void setTicks(int n) {
        this.ticks = n;
    }

    private final AABB getLocalAABB() {
        return AABB.ofSize((Vec3)this.getBlockPos().getCenter(), (double)this.range, (double)this.range, (double)this.range);
    }

    private final void collectAllLocalNaturePower(ServerLevel level) {
        this.limitTracker.clear();
        this.maxPower = 0;
        AABB aabb = this.getLocalAABB();
        level.getBlockStatesIfLoaded(aabb).forEach(arg_0 -> AltarBlockEntity.collectAllLocalNaturePower$lambda$1(arg_0 -> AltarBlockEntity.collectAllLocalNaturePower$lambda$0(this, arg_0), arg_0));
        this.maxPower += (int)Math.min((double)this.maxPower * this.powerBoost, 100000.0);
    }

    private final void updateCurrentPower() {
        double rate = (double)10 * this.powerMultiplier;
        this.currentPower = (double)this.currentPower + rate >= (double)this.maxPower ? this.maxPower : (int)Math.floor((double)this.currentPower + rate);
    }

    @NotNull
    public final AABB getLocalAugmentAABB(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        BlockPos pos = this.getBlockPos();
        Tuple4 tuple4 = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> new Tuple4((double)pos.getX() - 1.0, pos.getZ(), (double)pos.getX() + 2.0, (double)pos.getZ() + 2.0);
            case 2 -> new Tuple4((double)pos.getX() - 1.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 2.0, (double)pos.getZ() + 1.0);
            case 3 -> new Tuple4(pos.getX(), (double)pos.getZ() - 1.0, (double)pos.getX() + 2.0, (double)pos.getZ() + 2.0);
            case 4 -> new Tuple4((double)pos.getX() - 1.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 1.0, (double)pos.getZ() + 2.0);
            default -> new Tuple4(pos.getX(), pos.getZ(), (double)pos.getX() + 2.0, (double)pos.getZ() + 2.0);
        };
        double minX = tuple4.component1();
        double minZ = tuple4.component2();
        double maxX = tuple4.component3();
        double maxZ = tuple4.component4();
        return new AABB(minX, (double)pos.getY() + 1.0, minZ, maxX, (double)pos.getY() + 2.0, maxZ);
    }

    @Override
    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        if (pPlayer instanceof ServerPlayer) {
            this.openMenu((ServerPlayer)pPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    private final void openMenu(ServerPlayer player) {
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new AltarMultiplierSyncS2CPayload(blockPos, this.powerMultiplier), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.openMenu(new MenuProvider(this){
            final /* synthetic */ AltarBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeBlockPos(this.this$0.getBlockPos());
                buf.writeDouble(this.this$0.getPowerMultiplier());
                return new AltarMenu(containerId, inventory, buf);
            }

            public Component getDisplayName() {
                MutableComponent mutableComponent = Component.translatable((String)"container.witchery.altar_menu");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }
        }, this.getBlockPos());
    }

    public final void augmentAltar(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Comparable comparable = this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        AABB augments = this.getLocalAugmentAABB((Direction)comparable);
        this.powerMultiplier = 1.0;
        double prevPowerBoost = this.powerBoost;
        this.powerBoost = 1.0;
        Ref.DoubleRef rangeMultiplier = new Ref.DoubleRef();
        rangeMultiplier.element = 1.0;
        int prevRange = this.range;
        this.range = 16;
        Ref.DoubleRef bestLightAugment = new Ref.DoubleRef();
        Ref.DoubleRef bestHeadAugment = new Ref.DoubleRef();
        Ref.DoubleRef bestChaliceAugment = new Ref.DoubleRef();
        Ref.BooleanRef hasPentacle = new Ref.BooleanRef();
        Ref.BooleanRef hasInfinityEgg = new Ref.BooleanRef();
        level.getBlockStatesIfLoaded(augments).forEach(arg_0 -> AltarBlockEntity.augmentAltar$lambda$1(arg_0 -> AltarBlockEntity.augmentAltar$lambda$0(bestLightAugment, bestHeadAugment, bestChaliceAugment, rangeMultiplier, hasPentacle, hasInfinityEgg, arg_0), arg_0));
        this.powerMultiplier += this.powerMultiplier * bestLightAugment.element;
        this.powerMultiplier += this.powerMultiplier * bestHeadAugment.element;
        if (hasPentacle.element) {
            this.powerMultiplier *= (double)2;
        }
        this.powerBoost += this.powerBoost * bestHeadAugment.element;
        this.powerBoost += this.powerBoost * bestChaliceAugment.element;
        this.range += (int)((double)this.range * rangeMultiplier.element);
        if (hasInfinityEgg.element) {
            this.powerMultiplier *= (double)10;
            this.powerBoost *= (double)2;
        }
        if (!(this.powerBoost == prevPowerBoost) || this.range != prevRange) {
            this.powerUpdateQueued = true;
        }
    }

    @Override
    public void tickServer(@NotNull ServerLevel serverLevel) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        if (this.powerUpdateQueued) {
            this.collectAllLocalNaturePower(serverLevel);
            this.powerUpdateQueued = false;
        }
        if (this.augmentUpdateQueued) {
            this.augmentAltar(serverLevel);
            this.augmentUpdateQueued = false;
        }
        if (this.ticks % 20 == 1) {
            this.updateCurrentPower();
        }
        if (this.ticks % 20 == 5) {
            this.augmentAltar(serverLevel);
        }
        if (this.ticks % 20 == 0 && Witchery.Companion.useDebugBoxRender()) {
            Comparable comparable = this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            AABB augments = this.getLocalAugmentAABB((Direction)comparable);
            RenderUtils.INSTANCE.makeDebugAABB(augments, 65280, 40, serverLevel);
            AABB mainRange = this.getLocalAABB();
            Intrinsics.checkNotNull((Object)mainRange);
            RenderUtils.INSTANCE.makeDebugAABB(mainRange, 0xFF0000, 40, serverLevel);
        }
        if (this.ticks % 20 > 5) {
            this.ticks = 0;
        } else {
            int n = this.ticks;
            this.ticks = n + 1;
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        tag.putInt("currentPower", this.currentPower);
        tag.putInt("maxPower", this.maxPower);
        super.saveAdditional(tag, registries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        this.currentPower = pTag.getInt("currentPower");
        this.maxPower = pTag.getInt("maxPower");
    }

    public final boolean consumeAltarPower(int amount, boolean simulate) {
        boolean hasPower;
        block5: {
            block4: {
                boolean bl = hasPower = amount <= this.currentPower;
                if (simulate) break block4;
                Level level = this.level;
                if (level != null ? !level.isClientSide : false) break block5;
            }
            return hasPower;
        }
        if (!hasPower) {
            return false;
        }
        this.currentPower -= amount;
        return true;
    }

    private static final Unit collectAllLocalNaturePower$lambda$0(AltarBlockEntity this$0, BlockState state) {
        Intrinsics.checkNotNull((Object)state);
        Integer n = NaturePowerReloadListener.INSTANCE.getPower(state);
        if (n == null) {
            return Unit.INSTANCE;
        }
        int power = n;
        Pair<ResourceLocation, Integer> pair = NaturePowerReloadListener.INSTANCE.getLimit(state);
        if (pair == null) {
            return Unit.INSTANCE;
        }
        Pair<ResourceLocation, Integer> limit = pair;
        if (((Number)this$0.limitTracker.getOrDefault(limit.getFirst(), 0)).intValue() >= ((Number)limit.getSecond()).intValue()) {
            return Unit.INSTANCE;
        }
        this$0.maxPower += power;
        this$0.limitTracker.compute((ResourceLocation)limit.getFirst(), (arg_0, arg_1) -> AltarBlockEntity.collectAllLocalNaturePower$lambda$0$1(AltarBlockEntity::collectAllLocalNaturePower$lambda$0$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Integer collectAllLocalNaturePower$lambda$0$0(ResourceLocation resourceLocation, Integer count) {
        int n;
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<unused var>");
        Integer n2 = count;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = it + 1;
        } else {
            n = 1;
        }
        return n;
    }

    private static final Integer collectAllLocalNaturePower$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final void collectAllLocalNaturePower$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit augmentAltar$lambda$0(Ref.DoubleRef $bestLightAugment, Ref.DoubleRef $bestHeadAugment, Ref.DoubleRef $bestChaliceAugment, Ref.DoubleRef $rangeMultiplier, Ref.BooleanRef $hasPentacle, Ref.BooleanRef $hasInfinityEgg, BlockState state) {
        Intrinsics.checkNotNull((Object)state);
        AltarAugmentReloadListener.AltarAugment altarAugment = AltarAugmentReloadListener.INSTANCE.getAugment(state);
        if (altarAugment == null) {
            return Unit.INSTANCE;
        }
        AltarAugmentReloadListener.AltarAugment augment = altarAugment;
        AltarAugmentReloadListener.AugmentBonus bonus = augment.getBonus();
        switch (WhenMappings.$EnumSwitchMapping$1[augment.getCategory().ordinal()]) {
            case 1: {
                if (!(bonus.getLightBonus() > $bestLightAugment.element)) break;
                $bestLightAugment.element = bonus.getLightBonus();
                break;
            }
            case 2: {
                if (!(bonus.getHeadBonus() > $bestHeadAugment.element)) break;
                $bestHeadAugment.element = bonus.getHeadBonus();
                break;
            }
            case 3: {
                if (!(bonus.getChaliceBonus() > $bestChaliceAugment.element)) break;
                $bestChaliceAugment.element = bonus.getChaliceBonus();
                break;
            }
            case 4: {
                if (!(bonus.getRangeMultiplier() > $rangeMultiplier.element)) break;
                $rangeMultiplier.element = bonus.getRangeMultiplier();
                break;
            }
            case 5: {
                if (bonus.getHasPentacle()) {
                    $hasPentacle.element = true;
                }
                if (!bonus.getHasInfinityEgg()) break;
                $hasInfinityEgg.element = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final void augmentAltar$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/block/altar/AltarBlockEntity$Companion;", "", "<init>", "()V", "getClosestAltar", "Ldev/sterner/witchery/content/block/altar/AltarBlockEntity;", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "radius", "", "findNearbyAltars", "", "Lnet/minecraft/world/level/Level;", "onBlockBreak", "", "event", "Lnet/neoforged/neoforge/event/level/BlockEvent$BreakEvent;", "onBlockPlace", "Lnet/neoforged/neoforge/event/level/BlockEvent$EntityPlaceEvent;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nAltarBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarBlockEntity.kt\ndev/sterner/witchery/content/block/altar/AltarBlockEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,382:1\n1869#2,2:383\n1869#2,2:385\n*S KotlinDebug\n*F\n+ 1 AltarBlockEntity.kt\ndev/sterner/witchery/content/block/altar/AltarBlockEntity$Companion\n*L\n344#1:383,2\n365#1:385,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AltarBlockEntity getClosestAltar(@NotNull ServerLevel level, @NotNull BlockPos pos, int radius) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            AltarBlockEntity closestAltar = null;
            double closestDistance = Double.MAX_VALUE;
            int x = -radius;
            if (x <= radius) {
                while (true) {
                    int y;
                    if ((y = -radius) <= radius) {
                        while (true) {
                            int z;
                            if ((z = -radius) <= radius) {
                                while (true) {
                                    double distance;
                                    BlockPos checkPos;
                                    BlockEntity be;
                                    if ((be = level.getBlockEntity(checkPos = pos.offset(x, y, z))) instanceof AltarBlockEntity && (distance = pos.distSqr((Vec3i)checkPos)) < closestDistance) {
                                        closestDistance = distance;
                                        closestAltar = (AltarBlockEntity)be;
                                    }
                                    if (z == radius) break;
                                    ++z;
                                }
                            }
                            if (y == radius) break;
                            ++y;
                        }
                    }
                    if (x == radius) break;
                    ++x;
                }
            }
            return closestAltar;
        }

        private final List<BlockPos> findNearbyAltars(Level level, BlockPos pos) {
            int radius = 32;
            List altars = new ArrayList();
            int x = -radius;
            if (x <= radius) {
                while (true) {
                    int y;
                    if ((y = -radius) <= radius) {
                        while (true) {
                            int z;
                            if ((z = -radius) <= radius) {
                                while (true) {
                                    BlockPos checkPos;
                                    BlockEntity be;
                                    if ((be = level.getBlockEntity(checkPos = pos.offset(x, y, z))) instanceof AltarBlockEntity) {
                                        Intrinsics.checkNotNull((Object)checkPos);
                                        altars.add(checkPos);
                                    }
                                    if (z == radius) break;
                                    ++z;
                                }
                            }
                            if (y == radius) break;
                            ++y;
                        }
                    }
                    if (x == radius) break;
                    ++x;
                }
            }
            return altars;
        }

        public final void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            LevelAccessor level = event.getLevel();
            if (level instanceof Level && !((Level)level).isClientSide) {
                Level level2 = (Level)level;
                BlockPos blockPos = event.getPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
                List<BlockPos> altarPos = this.findNearbyAltars(level2, blockPos);
                Iterable $this$forEach$iv = altarPos;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlockPos pos = (BlockPos)element$iv;
                    boolean bl = false;
                    BlockEntity be = ((Level)level).getBlockEntity(pos);
                    if (!(be instanceof AltarBlockEntity) || !((AltarBlockEntity)be).getLocalAABB().contains(event.getPos().getCenter())) continue;
                    ((AltarBlockEntity)be).setPowerUpdateQueued(true);
                    AltarBlockEntity altarBlockEntity = (AltarBlockEntity)be;
                    Comparable comparable = ((AltarBlockEntity)be).getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                    Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
                    if (!altarBlockEntity.getLocalAugmentAABB((Direction)comparable).contains(event.getPos().getCenter())) continue;
                    ((AltarBlockEntity)be).setAugmentUpdateQueued(true);
                }
            }
        }

        public final void onBlockPlace(@NotNull BlockEvent.EntityPlaceEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            LevelAccessor level = event.getLevel();
            if (level instanceof Level && !((Level)level).isClientSide) {
                Level level2 = (Level)level;
                BlockPos blockPos = event.getPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
                List<BlockPos> altarPos = this.findNearbyAltars(level2, blockPos);
                Iterable $this$forEach$iv = altarPos;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlockPos pos = (BlockPos)element$iv;
                    boolean bl = false;
                    BlockEntity be = ((Level)level).getBlockEntity(pos);
                    if (!(be instanceof AltarBlockEntity) || !((AltarBlockEntity)be).getLocalAABB().contains(event.getPos().getCenter())) continue;
                    ((AltarBlockEntity)be).setPowerUpdateQueued(true);
                    AltarBlockEntity altarBlockEntity = (AltarBlockEntity)be;
                    Comparable comparable = ((AltarBlockEntity)be).getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                    Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
                    if (!altarBlockEntity.getLocalAugmentAABB((Direction)comparable).contains(event.getPos().getCenter())) continue;
                    ((AltarBlockEntity)be).setAugmentUpdateQueued(true);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/content/block/altar/AltarBlockEntity$Tuple4;", "", "minX", "", "minZ", "maxX", "maxZ", "<init>", "(DDDD)V", "getMinX", "()D", "getMinZ", "getMaxX", "getMaxZ", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "witchery"})
    private static final class Tuple4 {
        private final double minX;
        private final double minZ;
        private final double maxX;
        private final double maxZ;

        public Tuple4(double minX, double minZ, double maxX, double maxZ) {
            this.minX = minX;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxZ = maxZ;
        }

        public final double getMinX() {
            return this.minX;
        }

        public final double getMinZ() {
            return this.minZ;
        }

        public final double getMaxX() {
            return this.maxX;
        }

        public final double getMaxZ() {
            return this.maxZ;
        }

        public final double component1() {
            return this.minX;
        }

        public final double component2() {
            return this.minZ;
        }

        public final double component3() {
            return this.maxX;
        }

        public final double component4() {
            return this.maxZ;
        }

        @NotNull
        public final Tuple4 copy(double minX, double minZ, double maxX, double maxZ) {
            return new Tuple4(minX, minZ, maxX, maxZ);
        }

        public static /* synthetic */ Tuple4 copy$default(Tuple4 tuple4, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = tuple4.minX;
            }
            if ((n & 2) != 0) {
                d2 = tuple4.minZ;
            }
            if ((n & 4) != 0) {
                d3 = tuple4.maxX;
            }
            if ((n & 8) != 0) {
                d4 = tuple4.maxZ;
            }
            return tuple4.copy(d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "Tuple4(minX=" + this.minX + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxZ=" + this.maxZ + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.minX);
            result = result * 31 + Double.hashCode(this.minZ);
            result = result * 31 + Double.hashCode(this.maxX);
            result = result * 31 + Double.hashCode(this.maxZ);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tuple4)) {
                return false;
            }
            Tuple4 tuple4 = (Tuple4)other;
            if (Double.compare(this.minX, tuple4.minX) != 0) {
                return false;
            }
            if (Double.compare(this.minZ, tuple4.minZ) != 0) {
                return false;
            }
            if (Double.compare(this.maxX, tuple4.maxX) != 0) {
                return false;
            }
            return Double.compare(this.maxZ, tuple4.maxZ) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AltarAugmentReloadListener.AugmentCategory.values().length];
            try {
                nArray[AltarAugmentReloadListener.AugmentCategory.LIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AltarAugmentReloadListener.AugmentCategory.HEAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AltarAugmentReloadListener.AugmentCategory.CHALICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AltarAugmentReloadListener.AugmentCategory.RANGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AltarAugmentReloadListener.AugmentCategory.SPECIAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

