/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.censer;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.core.api.block.ActiveEffect;
import dev.sterner.witchery.core.api.block.AltarPowerConsumer;
import dev.sterner.witchery.core.api.block.PotionDisperser;
import dev.sterner.witchery.core.api.block.PotionDisperserHelper;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.util.WitcheryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016J\u0016\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0016\u0010%\u001a\u00020\u001e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010&\u001a\u00020\u0016H\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020\u0016H\u0002J\u0016\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005J\u0010\u00100\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J \u00101\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u00102\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u0018H\u0002J \u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020;H\u0002J\u0016\u0010@\u001a\u00020\u001e2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\u0012\u0010B\u001a\u00020\u001e2\b\u0010C\u001a\u0004\u0018\u00010DH\u0002J\u0018\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u0002092\u0006\u0010G\u001a\u00020=H\u0002J\b\u0010H\u001a\u00020\u001eH\u0002J\b\u0010I\u001a\u00020\u001eH\u0002J\u0018\u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020MH\u0014J\u0018\u0010N\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020MH\u0014J \u0010Q\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010R\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Ldev/sterner/witchery/content/block/censer/CenserBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "Ldev/sterner/witchery/core/api/block/AltarPowerConsumer;", "Ldev/sterner/witchery/core/api/block/PotionDisperser;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "potionContents", "", "Lnet/minecraft/world/item/alchemy/PotionContents;", "specialPotions", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient;", "activeEffects", "", "Ldev/sterner/witchery/core/api/block/ActiveEffect;", "owner", "Ljava/util/Optional;", "Ljava/util/UUID;", "infiniteMode", "", "dispersalRadius", "", "deferredNbtData", "Lnet/minecraft/nbt/CompoundTag;", "cachedAltarPos", "getPotionContents", "setPotionContents", "", "contents", "getSpecialPotions", "setSpecialPotions", "potions", "getActiveEffects", "getOwner", "setOwner", "isInfiniteMode", "setInfiniteMode", "infinite", "getDispersalRadius", "shouldConsumePower", "isOnAltar", "tickPotionEffects", "level", "Lnet/minecraft/world/level/Level;", "pos", "consumeAltarPower", "spawnClientParticles", "spawnSpecialEffectParticles", "x", "y", "z", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pHand", "Lnet/minecraft/world/InteractionHand;", "configureDispersalRadius", "stack", "configureSpecialDispersalRadius", "potionList", "findAndCacheAltar", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "consumePotionItem", "player", "hand", "playPotionSound", "spawnPotionAddedParticles", "saveAdditional", "tag", "holder", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "pTag", "pRegistries", "tick", "updateLitState", "witchery"})
@SourceDebugExtension(value={"SMAP\nCenserBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CenserBlockEntity.kt\ndev/sterner/witchery/content/block/censer/CenserBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n1#2:454\n1869#3,2:455\n*S KotlinDebug\n*F\n+ 1 CenserBlockEntity.kt\ndev/sterner/witchery/content/block/censer/CenserBlockEntity\n*L\n237#1:455,2\n*E\n"})
public final class CenserBlockEntity
extends WitcheryBaseBlockEntity
implements AltarPowerConsumer,
PotionDisperser {
    @NotNull
    private List<PotionContents> potionContents;
    @NotNull
    private List<WitcheryPotionIngredient> specialPotions;
    @NotNull
    private final List<ActiveEffect> activeEffects;
    @NotNull
    private Optional<UUID> owner;
    private boolean infiniteMode;
    private double dispersalRadius;
    @Nullable
    private CompoundTag deferredNbtData;
    @Nullable
    private BlockPos cachedAltarPos;

    public CenserBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getCENSER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        this.potionContents = CollectionsKt.listOf((Object)PotionContents.EMPTY);
        this.specialPotions = CollectionsKt.emptyList();
        this.activeEffects = new ArrayList();
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.owner = optional;
        this.infiniteMode = true;
        this.dispersalRadius = 16.0;
    }

    @Override
    @NotNull
    public List<PotionContents> getPotionContents() {
        return this.potionContents;
    }

    @Override
    public void setPotionContents(@NotNull List<PotionContents> contents) {
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        this.potionContents = contents;
        this.setChanged();
    }

    @Override
    @NotNull
    public List<WitcheryPotionIngredient> getSpecialPotions() {
        return this.specialPotions;
    }

    @Override
    public void setSpecialPotions(@NotNull List<WitcheryPotionIngredient> potions) {
        Intrinsics.checkNotNullParameter(potions, (String)"potions");
        this.specialPotions = potions;
        this.setChanged();
    }

    @Override
    @NotNull
    public List<ActiveEffect> getActiveEffects() {
        return this.activeEffects;
    }

    @Override
    @NotNull
    public Optional<UUID> getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@NotNull Optional<UUID> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        this.owner = owner;
        this.setChanged();
    }

    @Override
    public boolean isInfiniteMode() {
        return this.infiniteMode;
    }

    @Override
    public void setInfiniteMode(boolean infinite) {
        this.infiniteMode = infinite;
        this.setChanged();
    }

    @Override
    public double getDispersalRadius() {
        return this.dispersalRadius;
    }

    @Override
    public boolean shouldConsumePower() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOnAltar() {
        BlockEntity blockEntity;
        if (this.cachedAltarPos == null) return false;
        Level level = this.level;
        if (level != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            blockEntity = level.getBlockEntity(blockPos);
        } else {
            blockEntity = null;
        }
        if (!(blockEntity instanceof AltarBlockEntity)) return false;
        return true;
    }

    public final void tickPotionEffects(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Iterator<ActiveEffect> iterator = this.activeEffects.iterator();
        long currentTime = level.getGameTime();
        while (iterator.hasNext()) {
            ActiveEffect effect = iterator.next();
            if (effect.getRemainingTicks() == -1) {
                boolean hasAltarPower = true;
                if (currentTime % (long)20 == 0L) {
                    hasAltarPower = this.consumeAltarPower(level);
                }
                if (!hasAltarPower) {
                    iterator.remove();
                    continue;
                }
                if (effect.isSpecial()) {
                    if (currentTime - effect.getLastSpecialActivation() < 40L) continue;
                    PotionDisperserHelper.INSTANCE.applyEffects(this, level, pos, effect);
                    effect.setLastSpecialActivation(currentTime);
                    continue;
                }
                PotionDisperserHelper.INSTANCE.applyEffects(this, level, pos, effect);
                continue;
            }
            if (effect.getRemainingTicks() > 0) {
                if (effect.isSpecial()) {
                    if (currentTime - effect.getLastSpecialActivation() >= 40L) {
                        PotionDisperserHelper.INSTANCE.applyEffects(this, level, pos, effect);
                        effect.setLastSpecialActivation(currentTime);
                    }
                } else {
                    PotionDisperserHelper.INSTANCE.applyEffects(this, level, pos, effect);
                }
                int n = effect.getRemainingTicks();
                effect.setRemainingTicks(n + -1);
                if (effect.getRemainingTicks() > 0) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private final boolean consumeAltarPower(Level level) {
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!(level.getBlockEntity(blockPos) instanceof AltarBlockEntity)) {
                this.cachedAltarPos = null;
                this.setChanged();
                return false;
            }
        }
        int requiredAltarPower = 2;
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            return this.tryConsumeAltarPower(level, blockPos, requiredAltarPower, false);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final void spawnClientParticles(Level level, BlockPos pos, BlockState blockState) {
        block12: {
            random = level.random;
            blockX = pos.getX();
            blockY = pos.getY();
            blockZ = pos.getZ();
            minBound = 0.28125;
            maxBound = 0.71875;
            bottomY = 0.375;
            v0 = blockState.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProperties(...)");
            var20_11 = v0;
            for (T var22_15 : var20_11) {
                it = (Property)var22_15;
                $i$a$-find-CenserBlockEntity$spawnClientParticles$isLit$1 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"lit")) continue;
                v1 = var22_15;
                break block12;
            }
            v1 = null;
        }
        if ((v2 = (Property)v1) == null) ** GOTO lbl-1000
        it = v2;
        $i$a$-let-CenserBlockEntity$spawnClientParticles$isLit$2 = false;
        v3 = (Boolean)blockState.getValue((Property)((BooleanProperty)it));
        v2 = v3;
        if (v3 != null) {
            v4 = v2.booleanValue();
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        isLit = v4;
        face = random.nextInt(4);
        switch (face) {
            case 0: {
                x = blockX + minBound + random.nextDouble() * (maxBound - minBound);
                z = blockZ + minBound - 0.02;
                v5 = TuplesKt.to((Object)x, (Object)z);
                break;
            }
            case 1: {
                x = blockX + minBound + random.nextDouble() * (maxBound - minBound);
                z = blockZ + maxBound + 0.02;
                v5 = TuplesKt.to((Object)x, (Object)z);
                break;
            }
            case 2: {
                x = blockX + maxBound + 0.02;
                z = blockZ + minBound + random.nextDouble() * (maxBound - minBound);
                v5 = TuplesKt.to((Object)x, (Object)z);
                break;
            }
            default: {
                x = blockX + minBound - 0.02;
                z = blockZ + minBound + random.nextDouble() * (maxBound - minBound);
                v5 = TuplesKt.to((Object)x, (Object)z);
            }
        }
        var19_24 = v5;
        particleX = ((Number)var19_24.component1()).doubleValue();
        particleZ = ((Number)var19_24.component2()).doubleValue();
        particleY = blockY + bottomY;
        if (isLit && random.nextFloat() < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, particleX, particleY, particleZ, 0.0, 0.01 - random.nextDouble() * 0.01, 0.0);
        }
        if (isLit && random.nextFloat() < 0.15f) {
            level.addParticle((ParticleOptions)ParticleTypes.SOUL, particleX + (random.nextDouble() - 0.5) * 0.05, particleY, particleZ + (random.nextDouble() - 0.5) * 0.05, 0.0, 0.01 + random.nextDouble() * 0.01, 0.0);
        }
        if (((Collection)this.activeEffects).isEmpty() == false) {
            PotionDisperserHelper.INSTANCE.spawnPotionParticles(level, pos, this, 0.4f);
            this.spawnSpecialEffectParticles(level, blockX + 0.5, particleY, blockZ + 0.5);
        }
        if (isLit && random.nextFloat() < 0.2f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, particleX, particleY + 0.05, particleZ, 0.0, 0.01, 0.0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void spawnSpecialEffectParticles(Level level, double x, double y, double z) {
        random = level.random;
        $this$forEach$iv = this.activeEffects;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block17: {
                block18: {
                    block16: {
                        block15: {
                            effect = (ActiveEffect)element$iv;
                            $i$a$-forEach-CenserBlockEntity$spawnSpecialEffectParticles$1 = false;
                            if (!effect.isSpecial() || !(random.nextFloat() < 0.1f) || (var15_12 = effect.getId().getPath()) == null) continue;
                            switch (var15_12.hashCode()) {
                                case -963519295: {
                                    if (var15_12.equals("fertile")) break;
                                    ** break;
                                }
                                case 3327858: {
                                    if (!var15_12.equals("love")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                                case 1729863050: {
                                    if (!var15_12.equals("extinguish")) {
                                        ** break;
                                    }
                                    break block16;
                                }
                                case 697027433: {
                                    if (!var15_12.equals("harvest")) {
                                        ** break;
                                    }
                                    break block17;
                                }
                                case 3181587: {
                                    if (!var15_12.equals("grow")) {
                                        ** break;
                                    }
                                    break block18;
                                }
                                case -903068151: {
                                    if (!var15_12.equals("shrink")) {
                                        ** break;
                                    }
                                    break block18;
                                }
                                case -1662828212: {
                                    if (!var15_12.equals("grow_flowers")) ** break;
                                    level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x + (random.nextDouble() - 0.5) * 0.5, y, z + (random.nextDouble() - 0.5) * 0.5, 0.0, 0.0, 0.0);
                                    ** break;
                                }
                            }
                            level.addParticle((ParticleOptions)ParticleTypes.COMPOSTER, x + (random.nextDouble() - 0.5) * 0.5, y + 0.2, z + (random.nextDouble() - 0.5) * 0.5, 0.0, 0.0, 0.0);
                            ** break;
                        }
                        level.addParticle((ParticleOptions)ParticleTypes.HEART, x + (random.nextDouble() - 0.5) * 0.8, y + 0.5, z + (random.nextDouble() - 0.5) * 0.8, 0.0, 0.0, 0.0);
                        ** break;
                    }
                    level.addParticle((ParticleOptions)ParticleTypes.SPLASH, x + (random.nextDouble() - 0.5) * 0.6, y + 0.1, z + (random.nextDouble() - 0.5) * 0.6, 0.0, -0.1, 0.0);
                    ** break;
                }
                level.addParticle((ParticleOptions)ParticleTypes.WITCH, x + (random.nextDouble() - 0.5) * 0.5, y + 0.3, z + (random.nextDouble() - 0.5) * 0.5, 0.0, 0.02, 0.0);
                ** break;
            }
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x + (random.nextDouble() - 0.5) * 0.6, y, z + (random.nextDouble() - 0.5) * 0.6, 0.0, 0.0, 0.0);
lbl49:
            // 14 sources

        }
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (pStack.is(Items.POTION) || pStack.is(Items.SPLASH_POTION) || pStack.is(Items.LINGERING_POTION)) {
            PotionContents potionContents = (PotionContents)pStack.get(DataComponents.POTION_CONTENTS);
            if (potionContents == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            PotionContents contents = potionContents;
            if (Intrinsics.areEqual((Object)contents, (Object)PotionContents.EMPTY)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            this.setPotionContents(CollectionsKt.listOf((Object)contents));
            this.configureDispersalRadius(pStack);
            this.consumePotionItem(pPlayer, pHand);
            this.playPotionSound();
            Level level = this.level;
            this.findAndCacheAltar(level instanceof ServerLevel ? (ServerLevel)level : null);
            PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            return ItemInteractionResult.SUCCESS;
        }
        if (pStack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get())) {
            List list = (List)pStack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get());
            if (list == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            List potionList = list;
            this.setSpecialPotions(potionList);
            this.configureSpecialDispersalRadius(potionList);
            this.consumePotionItem(pPlayer, pHand);
            this.playPotionSound();
            Level level = this.level;
            this.findAndCacheAltar(level instanceof ServerLevel ? (ServerLevel)level : null);
            PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    private final void configureDispersalRadius(ItemStack stack) {
        this.dispersalRadius = stack.is(Items.LINGERING_POTION) ? 20.0 : (stack.is(Items.SPLASH_POTION) ? 18.0 : 16.0);
    }

    private final void configureSpecialDispersalRadius(List<WitcheryPotionIngredient> potionList) {
        Comparable comparable;
        Iterator iterator = ((Iterable)potionList).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            WitcheryPotionIngredient it = (WitcheryPotionIngredient)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getDispersalModifier().getRangeModifier());
            while (iterator.hasNext()) {
                WitcheryPotionIngredient it2 = (WitcheryPotionIngredient)iterator.next();
                $i$a$-maxOfOrNull-CenserBlockEntity$configureSpecialDispersalRadius$maxRangeModifier$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getDispersalModifier().getRangeModifier());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int maxRangeModifier = n != null ? n : 1;
        this.dispersalRadius = 16.0 * (double)maxRangeModifier;
    }

    private final void findAndCacheAltar(ServerLevel serverLevel) {
        if (this.cachedAltarPos == null && serverLevel != null) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.cachedAltarPos = this.getAltarPos(serverLevel, blockPos);
            this.setChanged();
        }
    }

    private final void consumePotionItem(Player player, InteractionHand hand) {
        if (!player.isCreative()) {
            WitcheryUtil.INSTANCE.addItemToInventoryAndConsume(player, hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
    }

    private final void playPotionSound() {
        Level level = this.level;
        if (level != null) {
            level.playSound(null, this.getBlockPos(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.spawnPotionAddedParticles();
    }

    private final void spawnPotionAddedParticles() {
        if (this.level instanceof ServerLevel) {
            int color = PotionDisperserHelper.INSTANCE.calculatePotionColor(this);
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            int n = 20;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                double offsetX = (level2.random.nextDouble() - 0.5) * 0.6;
                Level level3 = this.level;
                Intrinsics.checkNotNull((Object)level3);
                double offsetZ = (level3.random.nextDouble() - 0.5) * 0.6;
                serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)color).toVector3f(), 0.8f), (double)this.getBlockPos().getX() + 0.5 + offsetX, (double)this.getBlockPos().getY() + 0.8, (double)this.getBlockPos().getZ() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider holder) {
        block1: {
            BlockPos it;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super.saveAdditional(tag, holder);
            BlockPos blockPos = this.cachedAltarPos;
            if (blockPos != null) {
                it = blockPos;
                boolean bl = false;
                tag.put("AltarPos", NbtUtils.writeBlockPos((BlockPos)it));
            }
            tag.putDouble("DispersalRadius", this.dispersalRadius);
            tag.putBoolean("InfiniteMode", this.infiniteMode);
            Level level = this.level;
            if (level == null) break block1;
            it = level;
            boolean bl = false;
            PotionDisperserHelper.INSTANCE.savePotionData(tag, this, (Level)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        void it;
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("AltarPos")) {
            this.cachedAltarPos = NbtUtils.readBlockPos((CompoundTag)pTag, (String)"AltarPos").orElse(null);
        }
        Double d = pTag.getDouble("DispersalRadius");
        double d2 = ((Number)d).doubleValue();
        CenserBlockEntity censerBlockEntity = this;
        boolean bl = false;
        boolean bl2 = it > 0.0;
        Double d3 = bl2 ? d : null;
        censerBlockEntity.dispersalRadius = d3 != null ? d3 : 16.0;
        this.infiniteMode = pTag.getBoolean("InfiniteMode");
        Level level = this.level;
        if (level != null) {
            Level it2 = level;
            boolean bl3 = false;
            PotionDisperserHelper.INSTANCE.loadPotionData(pTag, this, it2);
            if (this.activeEffects.isEmpty() && (!((Collection)this.potionContents).isEmpty() || !((Collection)this.specialPotions).isEmpty())) {
                PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            }
        } else {
            CenserBlockEntity $this$loadAdditional_u24lambda_u242 = this;
            boolean bl4 = false;
            $this$loadAdditional_u24lambda_u242.deferredNbtData = pTag.copy();
        }
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super.tick(level, pos, blockState);
        CompoundTag compoundTag = this.deferredNbtData;
        if (compoundTag != null) {
            CompoundTag nbtData = compoundTag;
            boolean bl = false;
            PotionDisperserHelper.INSTANCE.loadPotionData(nbtData, this, level);
            if (this.activeEffects.isEmpty() && (!((Collection)this.potionContents).isEmpty() || !((Collection)this.specialPotions).isEmpty())) {
                PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            }
            this.deferredNbtData = null;
        }
        if (level.getGameTime() % (long)20 == 0L && this.activeEffects.isEmpty() && (!((Collection)this.potionContents).isEmpty() || !((Collection)this.specialPotions).isEmpty())) {
            PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
        }
        if (!level.isClientSide && level.getGameTime() % (long)100 == 0L && this.cachedAltarPos == null) {
            this.findAndCacheAltar(level instanceof ServerLevel ? (ServerLevel)level : null);
        }
        if (level.getGameTime() % (long)5 == 0L) {
            this.spawnClientParticles(level, pos, blockState);
        }
        if (level.isClientSide) {
            return;
        }
        this.updateLitState(level, pos, blockState);
        this.tickPotionEffects(level, pos);
    }

    private final void updateLitState(Level level, BlockPos pos, BlockState blockState) {
        BooleanProperty litProperty;
        Object v1;
        block3: {
            Collection collection = blockState.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProperties(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                Property it = (Property)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"lit")) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Object var5_9 = v1;
        BooleanProperty booleanProperty = litProperty = var5_9 instanceof BooleanProperty ? (BooleanProperty)var5_9 : null;
        if (litProperty != null) {
            boolean shouldBeLit = !((Collection)this.activeEffects).isEmpty() || this.isOnAltar();
            Boolean currentlyLit = (Boolean)blockState.getValue((Property)litProperty);
            if (!Intrinsics.areEqual((Object)currentlyLit, (Object)shouldBeLit)) {
                level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)litProperty, (Comparable)Boolean.valueOf(shouldBeLit)));
            }
        }
    }
}

