/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.distillery;

import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.content.block.distillery.DistilleryBlock;
import dev.sterner.witchery.content.menu.DistilleryMenu;
import dev.sterner.witchery.content.recipe.MultipleItemRecipeInput;
import dev.sterner.witchery.content.recipe.distillery.DistilleryCraftingRecipe;
import dev.sterner.witchery.core.api.block.AltarPowerConsumer;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 f2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001fB\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J.\u0010-\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020 \u0018\u0001002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u00101\u001a\u00020\u0014H\u0002J,\u00102\u001a\u00020*2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e042\u0006\u0010/\u001a\u00020 H\u0002J,\u00105\u001a\u00020.2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000e042\u0006\u00101\u001a\u00020\u0014H\u0002J,\u00107\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010/\u001a\u00020 H\u0002J,\u00108\u001a\u00020.2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000e042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u00101\u001a\u00020\u0014H\u0002J\u0018\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020;2\u0006\u0010/\u001a\u00020 H\u0002J.\u0010<\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020 \u0018\u0001002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u00101\u001a\u00020\u0014H\u0002J\u0018\u0010=\u001a\u00020.2\u0006\u0010:\u001a\u00020;2\u0006\u0010/\u001a\u00020 H\u0002J \u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u0014H\u0002J\u0016\u0010A\u001a\u00020*2\f\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u000100H\u0016J\u000e\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u000100H\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020*2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010J\u001a\u00020*2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0014J\u0018\u0010O\u001a\u00020*2\u0006\u0010P\u001a\u00020L2\u0006\u0010Q\u001a\u00020NH\u0014J\b\u0010R\u001a\u00020.H\u0016J\u0010\u0010S\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u0014H\u0016J\u0018\u0010U\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u0014H\u0016J\u0010\u0010W\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u0014H\u0016J\u0010\u0010X\u001a\u00020.2\u0006\u0010H\u001a\u00020FH\u0016J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0016J\"\u0010]\u001a\u00020.2\u0006\u0010^\u001a\u00020\u00142\u0006\u0010_\u001a\u00020\u000e2\b\u0010`\u001a\u0004\u0018\u00010\\H\u0016J \u0010a\u001a\u00020.2\u0006\u0010^\u001a\u00020\u00142\u0006\u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020\\H\u0016J\b\u0010b\u001a\u00020*H\u0016J\b\u0010c\u001a\u00020\u0014H\u0016J\u0018\u0010d\u001a\u00020*2\u0006\u0010T\u001a\u00020\u00142\u0006\u0010_\u001a\u00020\u000eH\u0016J\u0010\u0010e\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0002R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018RN\u0010\u001c\u001aB\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0012\f\u0012\n \u001f*\u0004\u0018\u00010 0  \u001f* \u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0012\f\u0012\n \u001f*\u0004\u0018\u00010 0 \u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006g"}, d2={"Ldev/sterner/witchery/content/block/distillery/DistilleryBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "Lnet/minecraft/world/Container;", "Ldev/sterner/witchery/core/api/block/AltarPowerConsumer;", "Lnet/minecraft/world/inventory/RecipeCraftingHolder;", "Lnet/minecraft/world/WorldlyContainer;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "cookingProgress", "", "getCookingProgress", "()I", "setCookingProgress", "(I)V", "cookingTotalTime", "getCookingTotalTime", "setCookingTotalTime", "quickCheck", "Lnet/minecraft/world/item/crafting/RecipeManager$CachedCheck;", "Ldev/sterner/witchery/content/recipe/MultipleItemRecipeInput;", "kotlin.jvm.PlatformType", "Ldev/sterner/witchery/content/recipe/distillery/DistilleryCraftingRecipe;", "recipesUsed", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lnet/minecraft/resources/ResourceLocation;", "cachedAltarPos", "dataAccess", "Lnet/minecraft/world/inventory/ContainerData;", "getDataAccess", "()Lnet/minecraft/world/inventory/ContainerData;", "tickServer", "", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "distill", "", "recipe", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "maxStackSize", "consumeInputItems", "inputItems", "", "placeOutputItems", "outputItems", "checkInputs", "checkOutputs", "hasEnoughAltarPower", "level", "Lnet/minecraft/world/level/Level;", "canDistill", "consumeAltarPower", "canFitInSlot", "resultStack", "outputSlot", "setRecipeUsed", "getRecipeUsed", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "openMenu", "player", "Lnet/minecraft/server/level/ServerPlayer;", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "tag", "registries", "isEmpty", "getItem", "slot", "removeItem", "amount", "removeItemNoUpdate", "stillValid", "getSlotsForFace", "", "side", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "index", "stack", "direction", "canTakeItemThroughFace", "clearContent", "getContainerSize", "setItem", "getTotalCookTime", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nDistilleryBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistilleryBlockEntity.kt\ndev/sterner/witchery/content/block/distillery/DistilleryBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,492:1\n1563#2:493\n1634#2,3:494\n1#3:497\n*S KotlinDebug\n*F\n+ 1 DistilleryBlockEntity.kt\ndev/sterner/witchery/content/block/distillery/DistilleryBlockEntity\n*L\n265#1:493\n265#1:494,3\n*E\n"})
public final class DistilleryBlockEntity
extends MultiBlockCoreEntity
implements Container,
AltarPowerConsumer,
RecipeCraftingHolder,
WorldlyContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> items;
    private int cookingProgress;
    private int cookingTotalTime;
    private final RecipeManager.CachedCheck<MultipleItemRecipeInput, DistilleryCraftingRecipe> quickCheck;
    @NotNull
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    @Nullable
    private BlockPos cachedAltarPos;
    @NotNull
    private final ContainerData dataAccess;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_EXTRA_INPUT = 1;
    public static final int SLOT_JAR = 2;
    public static final int SLOT_RESULT_1 = 3;
    public static final int SLOT_RESULT_2 = 4;
    public static final int SLOT_RESULT_3 = 5;
    public static final int SLOT_RESULT_4 = 6;
    public static final int DATA_COOKING_PROGRESS = 0;
    public static final int DATA_COOKING_TOTAL_TIME = 1;
    public static final int NUM_DATA_VALUES = 2;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;

    public DistilleryBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getDISTILLERY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockStructure multiBlockStructure = DistilleryBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockStructure, (String)"get(...)");
        super(blockEntityType, multiBlockStructure, blockPos, blockState);
        NonNullList nonNullList = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)WitcheryRecipeTypes.INSTANCE.getDISTILLERY_RECIPE_TYPE().get()));
        this.recipesUsed = new Object2IntOpenHashMap();
        this.dataAccess = new ContainerData(this){
            final /* synthetic */ DistilleryBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int index) {
                return switch (index) {
                    case 0 -> this.this$0.getCookingProgress();
                    case 1 -> this.this$0.getCookingTotalTime();
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        this.this$0.setCookingProgress(value);
                        break;
                    }
                    case 1: {
                        this.this$0.setCookingTotalTime(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.items = nonNullList;
    }

    public final int getCookingProgress() {
        return this.cookingProgress;
    }

    public final void setCookingProgress(int n) {
        this.cookingProgress = n;
    }

    public final int getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    public final void setCookingTotalTime(int n) {
        this.cookingTotalTime = n;
    }

    @NotNull
    public final ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void tickServer(@NotNull ServerLevel serverLevel) {
        boolean hasJar;
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        boolean shouldUpdateBlock = false;
        boolean isProcessing = false;
        Object object = this.items.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack jarStack = (ItemStack)object;
        Object object2 = this.items.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        ItemStack inputStack = (ItemStack)object2;
        Object object3 = this.items.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        ItemStack inputStack2 = (ItemStack)object3;
        boolean hasInput = !inputStack.isEmpty();
        boolean bl = hasJar = !jarStack.isEmpty();
        if (hasInput && hasJar) {
            Object[] objectArray = new ItemStack[]{inputStack, inputStack2};
            RecipeHolder distillingRecipe = this.quickCheck.getRecipeFor((RecipeInput)new MultipleItemRecipeInput(CollectionsKt.listOf((Object[])objectArray)), (Level)serverLevel).orElse(null);
            if (this.canDistill((RecipeHolder<DistilleryCraftingRecipe>)distillingRecipe, this.items, this.getMaxStackSize())) {
                int n = this.cookingProgress;
                this.cookingProgress = n + 1;
                isProcessing = true;
                if (this.cookingProgress % 20 == 0) {
                    Level level = (Level)serverLevel;
                    Recipe recipe = distillingRecipe.value();
                    Intrinsics.checkNotNullExpressionValue((Object)recipe, (String)"value(...)");
                    this.consumeAltarPower(level, (DistilleryCraftingRecipe)recipe);
                }
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = this.getTotalCookTime((Level)serverLevel);
                    if (this.distill((RecipeHolder<DistilleryCraftingRecipe>)distillingRecipe, this.items, this.getMaxStackSize())) {
                        this.setRecipeUsed(distillingRecipe);
                    }
                    shouldUpdateBlock = true;
                }
            } else {
                this.cookingProgress = 0;
            }
        } else if (this.cookingProgress > 0) {
            this.cookingProgress = Mth.clamp((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
        if (isProcessing && !((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            serverLevel.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
        } else if (!isProcessing && ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            serverLevel.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (shouldUpdateBlock) {
            BlockEntity.setChanged((Level)((Level)serverLevel), (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
        }
    }

    private final boolean distill(RecipeHolder<DistilleryCraftingRecipe> recipe, NonNullList<ItemStack> items, int maxStackSize) {
        if (recipe == null) {
            return false;
        }
        List<ItemStack> inputItems = ((DistilleryCraftingRecipe)recipe.value()).getInputItems();
        List<ItemStack> outputItems = ((DistilleryCraftingRecipe)recipe.value()).getOutputItems();
        Recipe recipe2 = recipe.value();
        Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"value(...)");
        this.consumeInputItems(items, inputItems, (DistilleryCraftingRecipe)recipe2);
        boolean success = this.placeOutputItems(items, outputItems, maxStackSize);
        if (success) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            Recipe recipe3 = recipe.value();
            Intrinsics.checkNotNullExpressionValue((Object)recipe3, (String)"value(...)");
            this.consumeAltarPower(level, (DistilleryCraftingRecipe)recipe3);
        }
        return success;
    }

    private final void consumeInputItems(NonNullList<ItemStack> items, List<ItemStack> inputItems, DistilleryCraftingRecipe recipe) {
        Object object = items.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack inputStack = (ItemStack)object;
        Object object2 = items.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        ItemStack extraInputStack = (ItemStack)object2;
        Object object3 = items.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        ItemStack jarStack = (ItemStack)object3;
        if (inputItems.size() == 1) {
            ItemStack firstInput = inputItems.get(0);
            if (ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)firstInput)) {
                inputStack.shrink(firstInput.getCount());
            }
        } else if (inputItems.size() >= 2) {
            if (ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)inputItems.get(0)) && ItemStack.isSameItemSameComponents((ItemStack)extraInputStack, (ItemStack)inputItems.get(1))) {
                inputStack.shrink(inputItems.get(0).getCount());
                extraInputStack.shrink(inputItems.get(1).getCount());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)inputItems.get(1)) && ItemStack.isSameItemSameComponents((ItemStack)extraInputStack, (ItemStack)inputItems.get(0))) {
                inputStack.shrink(inputItems.get(1).getCount());
                extraInputStack.shrink(inputItems.get(0).getCount());
            }
        }
        jarStack.shrink(recipe.getJarConsumption());
    }

    private final boolean placeOutputItems(NonNullList<ItemStack> items, List<ItemStack> outputItems, int maxStackSize) {
        Integer[] integerArray = new Integer[]{3, 4, 5, 6};
        List outputSlots = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object[])integerArray));
        for (ItemStack outputItem : outputItems) {
            boolean placed = false;
            Iterator iterator = outputSlots.iterator();
            while (iterator.hasNext()) {
                int slot = ((Number)iterator.next()).intValue();
                Object object = items.get(slot);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                ItemStack resultSlot = (ItemStack)object;
                if (!this.canFitInSlot(outputItem, resultSlot, maxStackSize)) continue;
                if (resultSlot.isEmpty()) {
                    items.set(slot, (Object)outputItem.copy());
                } else {
                    resultSlot.grow(outputItem.getCount());
                }
                placed = true;
                break;
            }
            if (placed) continue;
            return false;
        }
        return true;
    }

    private final boolean checkInputs(List<ItemStack> inputItems, NonNullList<ItemStack> items, DistilleryCraftingRecipe recipe) {
        Object object = items.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack jarStack = (ItemStack)object;
        if (jarStack.getCount() < recipe.getJarConsumption()) {
            return false;
        }
        if (inputItems.isEmpty()) {
            return false;
        }
        ItemStack firstInput = inputItems.get(0);
        Object object2 = items.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        ItemStack inputStack = (ItemStack)object2;
        Object object3 = items.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        ItemStack extraInputStack = (ItemStack)object3;
        if (inputItems.size() == 1) {
            return ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)firstInput) && extraInputStack.isEmpty();
        }
        ItemStack secondInput = inputItems.get(1);
        boolean inputsMatch = ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)firstInput) && ItemStack.isSameItemSameComponents((ItemStack)extraInputStack, (ItemStack)secondInput) || ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)secondInput) && ItemStack.isSameItemSameComponents((ItemStack)extraInputStack, (ItemStack)firstInput);
        return inputsMatch;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkOutputs(List<ItemStack> outputItems, NonNullList<ItemStack> items, int maxStackSize) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Integer[] integerArray = new Integer[]{3, 4, 5, 6};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])integerArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ItemStack)items.get((int)it));
        }
        List outputSlots = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        for (ItemStack outputItem : outputItems) {
            boolean fits = false;
            int n = ((Collection)outputSlots).size();
            for (int i = 0; i < n; ++i) {
                void $this$checkOutputs_u24lambda_u241;
                ItemStack itemStack;
                ItemStack slot = (ItemStack)outputSlots.get(i);
                if (!this.canFitInSlot(outputItem, slot, maxStackSize)) continue;
                fits = true;
                ItemStack bl = itemStack = slot.copy();
                int n2 = i;
                collection = outputSlots;
                boolean bl2 = false;
                $this$checkOutputs_u24lambda_u241.grow(outputItem.getCount());
                Unit unit = Unit.INSTANCE;
                ItemStack itemStack2 = itemStack;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"apply(...)");
                collection.set(n2, itemStack2);
                break;
            }
            if (fits) continue;
            return false;
        }
        return true;
    }

    private final boolean hasEnoughAltarPower(Level level, DistilleryCraftingRecipe recipe) {
        int requiredAltarPower;
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!(level.getBlockEntity(blockPos) instanceof AltarBlockEntity)) {
                this.cachedAltarPos = null;
                this.setChanged();
                return false;
            }
        }
        if ((requiredAltarPower = recipe.getAltarPower()) > 0 && this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            return this.tryConsumeAltarPower(level, blockPos, requiredAltarPower, true);
        }
        return requiredAltarPower == 0;
    }

    private final boolean canDistill(RecipeHolder<DistilleryCraftingRecipe> recipe, NonNullList<ItemStack> items, int maxStackSize) {
        if (recipe == null) {
            return false;
        }
        if (this.cachedAltarPos == null && this.level instanceof ServerLevel) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.cachedAltarPos = this.getAltarPos(serverLevel, blockPos);
            this.setChanged();
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        Recipe recipe2 = recipe.value();
        Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"value(...)");
        if (!this.hasEnoughAltarPower(level, (DistilleryCraftingRecipe)recipe2)) {
            return false;
        }
        List<ItemStack> inputItems = ((DistilleryCraftingRecipe)recipe.value()).getInputItems();
        List<ItemStack> outputItems = ((DistilleryCraftingRecipe)recipe.value()).getOutputItems();
        Recipe recipe3 = recipe.value();
        Intrinsics.checkNotNullExpressionValue((Object)recipe3, (String)"value(...)");
        if (!this.checkInputs(inputItems, items, (DistilleryCraftingRecipe)recipe3)) {
            return false;
        }
        return this.checkOutputs(outputItems, items, maxStackSize);
    }

    private final boolean consumeAltarPower(Level level, DistilleryCraftingRecipe recipe) {
        int requiredAltarPower;
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!(level.getBlockEntity(blockPos) instanceof AltarBlockEntity)) {
                this.cachedAltarPos = null;
                this.setChanged();
                return false;
            }
        }
        if ((requiredAltarPower = recipe.getAltarPower()) > 0 && this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            return this.tryConsumeAltarPower(level, blockPos, requiredAltarPower, false);
        }
        return requiredAltarPower == 0;
    }

    private final boolean canFitInSlot(ItemStack resultStack, ItemStack outputSlot, int maxStackSize) {
        if (outputSlot.isEmpty()) {
            return true;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)outputSlot, (ItemStack)resultStack)) {
            return outputSlot.getCount() + resultStack.getCount() <= Math.min(maxStackSize, outputSlot.getMaxStackSize());
        }
        return false;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourceLocation = recipe.id();
            this.recipesUsed.addTo((Object)resourceLocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        if (pPlayer instanceof ServerPlayer) {
            this.openMenu((ServerPlayer)pPlayer);
            return InteractionResult.SUCCESS;
        }
        return super.onUseWithoutItem(pPlayer);
    }

    private final void openMenu(ServerPlayer player) {
        player.openMenu(new MenuProvider(this){
            final /* synthetic */ DistilleryBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeBlockPos(this.this$0.getBlockPos());
                return new DistilleryMenu(containerId, inventory, buf);
            }

            public Component getDisplayName() {
                MutableComponent mutableComponent = Component.translatable((String)"container.witchery.distillery_menu");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }
        }, this.getBlockPos());
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        NonNullList nonNullList = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.cookingProgress = pTag.getShort("CookTime");
        this.cookingTotalTime = pTag.getShort("CookTimeTotal");
        if (pTag.contains("altarPos")) {
            this.cachedAltarPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)pTag, (String)"altarPos").get();
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putShort("CookTime", (short)this.cookingProgress);
        tag.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            tag.put("altarPos", NbtUtils.writeBlockPos((BlockPos)blockPos));
        }
    }

    public boolean isEmpty() {
        Iterator iterator = this.items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator2.next();
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.items.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.items), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.items), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return CollectionsKt.toIntArray((Collection)CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)this.items.size()))));
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return index == 2 && stack.is((Item)WitcheryItems.INSTANCE.getJAR().get()) || index == 0 || index == 1;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return index == 3 || index == 4 || index == 5 || index == 6;
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Object object = this.items.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack itemStack = (ItemStack)object;
        boolean bl = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack);
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (!(slot != 0 && slot != 1 && slot != 2 || bl)) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            this.cookingTotalTime = this.getTotalCookTime(level);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    private final int getTotalCookTime(Level level) {
        Object[] objectArray = new ItemStack[]{this.getItem(0), this.getItem(1)};
        MultipleItemRecipeInput singleRecipeInput = new MultipleItemRecipeInput(CollectionsKt.listOf((Object[])objectArray));
        Integer cookQuickTime = this.quickCheck.getRecipeFor((RecipeInput)singleRecipeInput, level).map(arg_0 -> DistilleryBlockEntity.getTotalCookTime$lambda$1(DistilleryBlockEntity::getTotalCookTime$lambda$0, arg_0)).orElse(200);
        Intrinsics.checkNotNull((Object)cookQuickTime);
        return RangesKt.coerceAtLeast((int)cookQuickTime, (int)1);
    }

    private static final Integer getTotalCookTime$lambda$0(RecipeHolder recipeHolder) {
        Intrinsics.checkNotNullParameter((Object)recipeHolder, (String)"recipeHolder");
        Recipe recipe = recipeHolder.value();
        Intrinsics.checkNotNull((Object)recipe, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.recipe.distillery.DistilleryCraftingRecipe");
        return ((DistilleryCraftingRecipe)recipe).getCookingTime();
    }

    private static final Integer getTotalCookTime$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/block/distillery/DistilleryBlockEntity$Companion;", "", "<init>", "()V", "SLOT_INPUT", "", "SLOT_EXTRA_INPUT", "SLOT_JAR", "SLOT_RESULT_1", "SLOT_RESULT_2", "SLOT_RESULT_3", "SLOT_RESULT_4", "DATA_COOKING_PROGRESS", "DATA_COOKING_TOTAL_TIME", "NUM_DATA_VALUES", "BURN_TIME_STANDARD", "BURN_COOL_SPEED", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

