/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.oven;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.menu.OvenMenu;
import dev.sterner.witchery.content.recipe.oven.OvenCookingRecipe;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 t2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001tB\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u00106\u001a\u000207H\u0002J \u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\tH\u0016J \u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010G\u001a\u0002092\u0006\u0010@\u001a\u00020HH\u0002J4\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010O\u001a\u00020\u0014H\u0002J4\u0010P\u001a\u0002072\u0006\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010O\u001a\u00020\u0014H\u0002J\u0010\u0010Q\u001a\u00020\u00142\u0006\u0010R\u001a\u00020\u000eH\u0002J\u0010\u0010S\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J\"\u0010X\u001a\u0002072\u0006\u0010Y\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020\u000e2\b\u0010[\u001a\u0004\u0018\u00010WH\u0016J \u0010\\\u001a\u0002072\u0006\u0010Y\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010[\u001a\u00020WH\u0016J\b\u0010]\u001a\u00020\u0014H\u0016J\u0018\u0010^\u001a\u0002092\u0006\u0010_\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u000eH\u0016J\u0018\u0010`\u001a\u0002072\u0006\u0010_\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u000eH\u0016J\u0016\u0010a\u001a\u0002092\f\u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010MH\u0016J\u000e\u0010b\u001a\b\u0012\u0002\b\u0003\u0018\u00010MH\u0016J\u0010\u0010c\u001a\u0002092\u0006\u0010d\u001a\u00020eH\u0016J\u0018\u0010f\u001a\u0002092\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020jH\u0014J\u0018\u0010k\u001a\u0002092\u0006\u0010g\u001a\u00020h2\u0006\u0010l\u001a\u00020jH\u0014J\b\u0010m\u001a\u000207H\u0016J\u0010\u0010n\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u0014H\u0016J\u0018\u0010o\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u00142\u0006\u0010p\u001a\u00020\u0014H\u0016J\u0010\u0010q\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u0014H\u0016J\u0010\u0010r\u001a\u0002072\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010s\u001a\u000209H\u0016R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u001a\u0010\"\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u001a\u0010%\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010/\u001aB\u0012\f\u0012\n 2*\u0004\u0018\u00010101\u0012\f\u0012\n 2*\u0004\u0018\u00010303 2* \u0012\f\u0012\n 2*\u0004\u0018\u00010101\u0012\f\u0012\n 2*\u0004\u0018\u00010303\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u00104\u001aB\u0012\f\u0012\n 2*\u0004\u0018\u00010101\u0012\f\u0012\n 2*\u0004\u0018\u00010505 2* \u0012\f\u0012\n 2*\u0004\u0018\u00010101\u0012\f\u0012\n 2*\u0004\u0018\u00010505\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Ldev/sterner/witchery/content/block/oven/OvenBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "Lnet/minecraft/world/Container;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/world/inventory/RecipeCraftingHolder;", "Lnet/minecraft/world/inventory/StackedContentsCompatible;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "litTime", "", "getLitTime", "()I", "setLitTime", "(I)V", "litDuration", "getLitDuration", "setLitDuration", "cookingProgress", "getCookingProgress", "setCookingProgress", "cookingTotalTime", "getCookingTotalTime", "setCookingTotalTime", "fumeHoodCount", "getFumeHoodCount", "setFumeHoodCount", "filteredFumeHoodCount", "getFilteredFumeHoodCount", "setFilteredFumeHoodCount", "dataAccess", "Lnet/minecraft/world/inventory/ContainerData;", "getDataAccess", "()Lnet/minecraft/world/inventory/ContainerData;", "recipesUsed", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lnet/minecraft/resources/ResourceLocation;", "quickCheck", "Lnet/minecraft/world/item/crafting/RecipeManager$CachedCheck;", "Lnet/minecraft/world/item/crafting/SingleRecipeInput;", "kotlin.jvm.PlatformType", "Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe;", "quickCookCheck", "Lnet/minecraft/world/item/crafting/SmokingRecipe;", "isLit", "", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "state", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "stack", "hand", "Lnet/minecraft/world/InteractionHand;", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "openMenu", "Lnet/minecraft/server/level/ServerPlayer;", "canBurn", "registryAccess", "Lnet/minecraft/core/RegistryAccess;", "recipe", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "inventory", "maxStackSize", "burn", "getBurnDuration", "fuel", "getTotalCookTime", "getSlotsForFace", "", "side", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "index", "itemStack", "direction", "canTakeItemThroughFace", "getContainerSize", "setItem", "slot", "canPlaceItem", "setRecipeUsed", "getRecipeUsed", "fillStackedContents", "contents", "Lnet/minecraft/world/entity/player/StackedContents;", "loadAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "registries", "isEmpty", "getItem", "removeItem", "amount", "removeItemNoUpdate", "stillValid", "clearContent", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nOvenBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OvenBlockEntity.kt\ndev/sterner/witchery/content/block/oven/OvenBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,465:1\n1#2:466\n216#3,2:467\n*S KotlinDebug\n*F\n+ 1 OvenBlockEntity.kt\ndev/sterner/witchery/content/block/oven/OvenBlockEntity\n*L\n402#1:467,2\n*E\n"})
public final class OvenBlockEntity
extends WitcheryBaseBlockEntity
implements Container,
WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> items;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private int fumeHoodCount;
    private int filteredFumeHoodCount;
    @NotNull
    private final ContainerData dataAccess;
    @NotNull
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    private final RecipeManager.CachedCheck<SingleRecipeInput, OvenCookingRecipe> quickCheck;
    private final RecipeManager.CachedCheck<SingleRecipeInput, SmokingRecipe> quickCookCheck;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_RESULT = 2;
    public static final int SLOT_EXTRA_INPUT = 3;
    public static final int SLOT_EXTRA_RESULT = 4;
    @NotNull
    private static final int[] SLOTS_FOR_UP;
    @NotNull
    private static final int[] SLOTS_FOR_DOWN;
    @NotNull
    private static final int[] SLOTS_FOR_SIDES;
    public static final int DATA_LIT_TIME = 0;
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;

    public OvenBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getOVEN().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        NonNullList nonNullList = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        this.dataAccess = new ContainerData(this){
            final /* synthetic */ OvenBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int index) {
                return switch (index) {
                    case 0 -> this.this$0.getLitTime();
                    case 1 -> this.this$0.getLitDuration();
                    case 2 -> this.this$0.getCookingProgress();
                    case 3 -> this.this$0.getCookingTotalTime();
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        this.this$0.setLitTime(value);
                        break;
                    }
                    case 1: {
                        this.this$0.setLitDuration(value);
                        break;
                    }
                    case 2: {
                        this.this$0.setCookingProgress(value);
                        break;
                    }
                    case 3: {
                        this.this$0.setCookingTotalTime(value);
                    }
                }
            }

            public int getCount() {
                return 4;
            }
        };
        this.recipesUsed = new Object2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)WitcheryRecipeTypes.INSTANCE.getOVEN_RECIPE_TYPE().get()));
        this.quickCookCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMOKING);
    }

    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.items = nonNullList;
    }

    public final int getLitTime() {
        return this.litTime;
    }

    public final void setLitTime(int n) {
        this.litTime = n;
    }

    public final int getLitDuration() {
        return this.litDuration;
    }

    public final void setLitDuration(int n) {
        this.litDuration = n;
    }

    public final int getCookingProgress() {
        return this.cookingProgress;
    }

    public final void setCookingProgress(int n) {
        this.cookingProgress = n;
    }

    public final int getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    public final void setCookingTotalTime(int n) {
        this.cookingTotalTime = n;
    }

    public final int getFumeHoodCount() {
        return this.fumeHoodCount;
    }

    public final void setFumeHoodCount(int n) {
        this.fumeHoodCount = n;
    }

    public final int getFilteredFumeHoodCount() {
        return this.filteredFumeHoodCount;
    }

    public final void setFilteredFumeHoodCount(int n) {
        this.filteredFumeHoodCount = n;
    }

    @NotNull
    public final ContainerData getDataAccess() {
        return this.dataAccess;
    }

    private final boolean isLit() {
        return this.litTime > 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        block21: {
            block20: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                super.tick(level, pos, state);
                if (level.isClientSide) {
                    return;
                }
                wasLit = this.isLit();
                shouldUpdateBlock = false;
                if (this.isLit()) {
                    var6_6 = this.litTime;
                    this.litTime = var6_6 + -1;
                }
                v0 = this.items.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                fuelStack = (ItemStack)v0;
                v1 = this.items.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                inputStack = (ItemStack)v1;
                hasInput = inputStack.isEmpty() == false;
                v2 = hasFuel = fuelStack.isEmpty() == false;
                if (!this.isLit() && (!hasFuel || !hasInput)) break block20;
                ovenRecipe = hasInput != false ? (RecipeHolder)this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(inputStack), level).orElse(null) : null;
                cookRecipe = hasInput != false ? (RecipeHolder)this.quickCookCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(inputStack), level).orElse(null) : null;
                maxStackSize = this.getMaxStackSize();
                if (!this.isLit()) {
                    v3 = level.registryAccess();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"registryAccess(...)");
                    v4 = ovenRecipe;
                    if (v4 == null) {
                        v4 = cookRecipe;
                    }
                    if (this.canBurn(v3, v4, this.items, maxStackSize)) {
                        this.litDuration = this.litTime = this.getBurnDuration(fuelStack);
                        if (this.isLit()) {
                            shouldUpdateBlock = true;
                            if (hasFuel) {
                                fuelItem = fuelStack.getItem();
                                fuelStack.shrink(1);
                                if (fuelStack.isEmpty()) {
                                    remainingFuelItem = fuelItem.getCraftingRemainingItem();
                                    v5 = this.items;
                                    v6 = 1;
                                    v7 = remainingFuelItem;
                                    if (v7 != null) {
                                        var15_17 = v7;
                                        var18_18 = v6;
                                        var17_19 = v5;
                                        $i$a$-let-OvenBlockEntity$tick$1 = false;
                                        var19_21 = new ItemStack((ItemLike)it);
                                        v5 = var17_19;
                                        v6 = var18_18;
                                        v8 = var19_21;
                                    } else {
                                        v8 = ItemStack.EMPTY;
                                    }
                                    v5.set(v6, (Object)v8);
                                }
                            }
                        }
                    }
                }
                if (!this.isLit()) ** GOTO lbl-1000
                v9 = level.registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"registryAccess(...)");
                v10 = ovenRecipe;
                if (v10 == null) {
                    v10 = cookRecipe;
                }
                if (this.canBurn(v9, v10, this.items, maxStackSize)) {
                    var13_15 = this.cookingProgress;
                    this.cookingProgress = var13_15 + 1;
                    if (this.cookingProgress == this.cookingTotalTime) {
                        this.cookingProgress = 0;
                        this.cookingTotalTime = this.getTotalCookTime(level);
                        v11 = level.registryAccess();
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"registryAccess(...)");
                        v12 = ovenRecipe;
                        if (v12 == null) {
                            v12 = cookRecipe;
                        }
                        if (this.burn(v11, v12, this.items, maxStackSize)) {
                            v13 = ovenRecipe;
                            if (v13 == null) {
                                v13 = cookRecipe;
                            }
                            this.setRecipeUsed(v13);
                        }
                        shouldUpdateBlock = true;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.cookingProgress = 0;
                }
                break block21;
            }
            if (!this.isLit() && this.cookingProgress > 0) {
                this.cookingProgress = Mth.clamp((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
            }
        }
        if (wasLit != this.isLit()) {
            shouldUpdateBlock = true;
            newState = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            level.setBlock(pos, newState, 3);
        }
        if (shouldUpdateBlock) {
            BlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player player, @NotNull ItemStack stack, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (player instanceof ServerPlayer) {
            this.openMenu((ServerPlayer)player);
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(player, stack, hand);
    }

    @Override
    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player instanceof ServerPlayer) {
            this.openMenu((ServerPlayer)player);
            return InteractionResult.SUCCESS;
        }
        return super.onUseWithoutItem(player);
    }

    private final void openMenu(ServerPlayer player) {
        player.openMenu(new MenuProvider(this){
            final /* synthetic */ OvenBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeBlockPos(this.this$0.getBlockPos());
                return new OvenMenu(containerId, inventory, buf);
            }

            public Component getDisplayName() {
                MutableComponent mutableComponent = Component.translatable((String)"container.witchery.oven_menu");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }
        }, this.getBlockPos());
    }

    private final boolean canBurn(RegistryAccess registryAccess, RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize) {
        if (!((ItemStack)inventory.get(0)).isEmpty() && recipe != null) {
            ItemStack resultStack = recipe.value().getResultItem((HolderLookup.Provider)registryAccess);
            if (resultStack.isEmpty()) {
                return false;
            }
            Object object = inventory.get(2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack outputStack = (ItemStack)object;
            return outputStack.isEmpty() ? true : (!ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack) ? false : (outputStack.getCount() < maxStackSize && outputStack.getCount() < outputStack.getMaxStackSize() ? true : outputStack.getCount() < resultStack.getMaxStackSize()));
        }
        return false;
    }

    private final boolean burn(RegistryAccess registryAccess, RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize) {
        if (recipe != null && this.canBurn(registryAccess, recipe, inventory, maxStackSize)) {
            Object object = inventory.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack inputStack = (ItemStack)object;
            ItemStack resultStack = recipe.value().getResultItem((HolderLookup.Provider)registryAccess);
            Object object2 = inventory.get(2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            ItemStack outputStack = (ItemStack)object2;
            if (outputStack.isEmpty()) {
                inventory.set(2, (Object)resultStack.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack)) {
                outputStack.grow(1);
            }
            if (recipe.value() instanceof OvenCookingRecipe) {
                Recipe recipe2 = recipe.value();
                Intrinsics.checkNotNull((Object)recipe2, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.recipe.oven.OvenCookingRecipe");
                OvenCookingRecipe ovenRecipe = (OvenCookingRecipe)recipe2;
                ItemStack extraResultStack = ovenRecipe.getExtraOutput().copy();
                Ingredient extraInputStack = ovenRecipe.getExtraIngredient();
                Object object3 = inventory.get(4);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                ItemStack extraOutputStack = (ItemStack)object3;
                double extraOutputChanceIncrease = (double)this.fumeHoodCount * 0.2 + (double)this.filteredFumeHoodCount * 0.3;
                if (extraInputStack.test((ItemStack)inventory.get(3))) {
                    Level level = this.level;
                    Intrinsics.checkNotNull((Object)level);
                    if (level.random.nextDouble() > 0.75 - extraOutputChanceIncrease) {
                        if (!extraResultStack.isEmpty()) {
                            if (extraOutputStack.isEmpty()) {
                                inventory.set(4, (Object)extraResultStack.copy());
                            } else if (ItemStack.isSameItemSameComponents((ItemStack)extraOutputStack, (ItemStack)extraResultStack)) {
                                extraOutputStack.grow(1);
                            }
                        }
                        ((ItemStack)inventory.get(3)).shrink(1);
                    }
                }
            } else if (((ItemStack)inventory.get(3)).is((Item)WitcheryItems.INSTANCE.getJAR().get())) {
                ItemStack foulFume = ((Item)WitcheryItems.INSTANCE.getFOUL_FUME().get()).getDefaultInstance();
                Object object4 = inventory.get(4);
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                ItemStack extraOutputStack = (ItemStack)object4;
                if (extraOutputStack.isEmpty()) {
                    inventory.set(4, (Object)foulFume);
                } else if (ItemStack.isSameItemSameComponents((ItemStack)extraOutputStack, (ItemStack)foulFume)) {
                    extraOutputStack.grow(1);
                }
                ((ItemStack)inventory.get(3)).shrink(1);
            }
            if (inputStack.is(Blocks.WET_SPONGE.asItem()) && !((ItemStack)inventory.get(1)).isEmpty() && ((ItemStack)inventory.get(1)).is(Items.BUCKET)) {
                inventory.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            inputStack.shrink(1);
            return true;
        }
        return false;
    }

    private final int getBurnDuration(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        Item item = fuel.getItem();
        Integer n = AbstractFurnaceBlockEntity.getFuel().getOrDefault(item, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        return ((Number)n).intValue();
    }

    private final int getTotalCookTime(Level level) {
        SingleRecipeInput singleRecipeInput = new SingleRecipeInput(this.getItem(0));
        Integer cookQuickTime = this.quickCookCheck.getRecipeFor((RecipeInput)singleRecipeInput, level).map(arg_0 -> OvenBlockEntity.getTotalCookTime$lambda$1(OvenBlockEntity::getTotalCookTime$lambda$0, arg_0)).orElse(200);
        Integer baseCookTime = this.quickCheck.getRecipeFor((RecipeInput)singleRecipeInput, level).map(arg_0 -> OvenBlockEntity.getTotalCookTime$lambda$3(OvenBlockEntity::getTotalCookTime$lambda$2, arg_0)).orElse(cookQuickTime);
        double speedBoost = (double)this.fumeHoodCount * 0.25 + (double)this.filteredFumeHoodCount * 0.35;
        int finalCookTime = (int)((double)baseCookTime.intValue() / (1.0 + speedBoost));
        return RangesKt.coerceAtLeast((int)finalCookTime, (int)1);
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : (side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES);
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return this.canPlaceItem(index, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return direction == Direction.DOWN && index == 1 ? stack.is(Items.WATER_BUCKET) || stack.is(Items.BUCKET) : true;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Object object = this.items.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack itemStack = (ItemStack)object;
        boolean bl = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack);
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (slot == 0 && !bl) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            this.cookingTotalTime = this.getTotalCookTime(level);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        Object object = this.items.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack itemStack = (ItemStack)object;
        return AbstractFurnaceBlockEntity.isFuel((ItemStack)stack) || stack.is(Items.BUCKET) && !itemStack.is(Items.BUCKET);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourceLocation = recipe.id();
            this.recipesUsed.addTo((Object)resourceLocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void fillStackedContents(@NotNull StackedContents contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Iterator iterator = this.items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator2.next();
            contents.accountStack(itemStack);
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(tag, pRegistries);
        NonNullList nonNullList = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)pRegistries);
        this.litTime = tag.getShort("BurnTime");
        this.cookingProgress = tag.getShort("CookTime");
        this.cookingTotalTime = tag.getShort("CookTimeTotal");
        Object object = this.items.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.litDuration = this.getBurnDuration((ItemStack)object);
        this.fumeHoodCount = tag.getInt("FumeHoodCount");
        this.filteredFumeHoodCount = tag.getInt("FilteredFumeHoodCount");
        CompoundTag compoundTag = tag.getCompound("RecipesUsed");
        for (String string : compoundTag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)string), compoundTag.getInt(string));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putShort("BurnTime", (short)this.litTime);
        tag.putShort("CookTime", (short)this.cookingProgress);
        tag.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        tag.putInt("FumeHoodCount", this.fumeHoodCount);
        tag.putInt("FilteredFumeHoodCount", this.filteredFumeHoodCount);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        CompoundTag compoundTag = new CompoundTag();
        Map $this$forEach$iv = (Map)this.recipesUsed;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            ResourceLocation resourceLocation = (ResourceLocation)k;
            Integer integer = (Integer)entry.getValue();
            String string = resourceLocation.toString();
            Integer n = integer;
            Intrinsics.checkNotNull((Object)n);
            compoundTag.putInt(string, n.intValue());
        }
        tag.put("RecipesUsed", (Tag)compoundTag);
    }

    public boolean isEmpty() {
        Iterator iterator = this.items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator2.next();
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.items.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.items), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.items), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
    }

    private static final Integer getTotalCookTime$lambda$0(RecipeHolder recipeHolder) {
        Intrinsics.checkNotNullParameter((Object)recipeHolder, (String)"recipeHolder");
        Recipe recipe = recipeHolder.value();
        Intrinsics.checkNotNull((Object)recipe, (String)"null cannot be cast to non-null type net.minecraft.world.item.crafting.SmokingRecipe");
        return ((SmokingRecipe)recipe).getCookingTime();
    }

    private static final Integer getTotalCookTime$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer getTotalCookTime$lambda$2(RecipeHolder recipeHolder) {
        Intrinsics.checkNotNullParameter((Object)recipeHolder, (String)"recipeHolder");
        Recipe recipe = recipeHolder.value();
        Intrinsics.checkNotNull((Object)recipe, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.recipe.oven.OvenCookingRecipe");
        return ((OvenCookingRecipe)recipe).getCookingTime();
    }

    private static final Integer getTotalCookTime$lambda$3(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    static {
        int[] nArray = new int[]{0};
        SLOTS_FOR_UP = nArray;
        nArray = new int[]{2, 1};
        SLOTS_FOR_DOWN = nArray;
        nArray = new int[]{1};
        SLOTS_FOR_SIDES = nArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/content/block/oven/OvenBlockEntity$Companion;", "", "<init>", "()V", "SLOT_INPUT", "", "SLOT_FUEL", "SLOT_RESULT", "SLOT_EXTRA_INPUT", "SLOT_EXTRA_RESULT", "SLOTS_FOR_UP", "", "getSLOTS_FOR_UP", "()[I", "SLOTS_FOR_DOWN", "getSLOTS_FOR_DOWN", "SLOTS_FOR_SIDES", "getSLOTS_FOR_SIDES", "DATA_LIT_TIME", "DATA_LIT_DURATION", "DATA_COOKING_PROGRESS", "DATA_COOKING_TOTAL_TIME", "NUM_DATA_VALUES", "BURN_TIME_STANDARD", "BURN_COOL_SPEED", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getSLOTS_FOR_UP() {
            return SLOTS_FOR_UP;
        }

        @NotNull
        public final int[] getSLOTS_FOR_DOWN() {
            return SLOTS_FOR_DOWN;
        }

        @NotNull
        public final int[] getSLOTS_FOR_SIDES() {
            return SLOTS_FOR_SIDES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

