/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.phylactery;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.necromancy.PhylacteryLevelDataAttachment;
import dev.sterner.witchery.features.necromancy.SoulPoolPlayerAttachment;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0018H\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J \u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020.2\u0006\u0010)\u001a\u00020*H\u0016R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Ldev/sterner/witchery/content/block/phylactery/PhylacteryBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "value", "Ljava/util/UUID;", "ownerUUID", "getOwnerUUID", "()Ljava/util/UUID;", "", "ownerName", "getOwnerName", "()Ljava/lang/String;", "", "hasSoul", "getHasSoul", "()Z", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pHand", "Lnet/minecraft/world/InteractionHand;", "setLevel", "", "level", "Lnet/minecraft/world/level/Level;", "onPlace", "pPlacer", "Lnet/minecraft/world/entity/LivingEntity;", "onBreak", "player", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "getUpdateTag", "getUpdatePacket", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "onDataPacket", "net", "Lnet/minecraft/network/Connection;", "packet", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nPhylacteryBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhylacteryBlockEntity.kt\ndev/sterner/witchery/content/block/phylactery/PhylacteryBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class PhylacteryBlockEntity
extends WitcheryBaseBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private String ownerName;
    private boolean hasSoul;

    public PhylacteryBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getPHYLACTERY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Nullable
    public final String getOwnerName() {
        return this.ownerName;
    }

    public final boolean getHasSoul() {
        return this.hasSoul;
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (pPlayer instanceof ServerPlayer && pStack.is((Item)WitcheryItems.INSTANCE.getSPECTRAL_DUST().get())) {
            Object v0;
            ServerLevel serverLevel;
            block4: {
                serverLevel = ((ServerPlayer)pPlayer).serverLevel();
                Intrinsics.checkNotNull((Object)serverLevel);
                Iterable iterable = PhylacteryLevelDataAttachment.INSTANCE.listPhylacteries(serverLevel);
                for (Object t : iterable) {
                    PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPos(), (Object)this.getBlockPos())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            PhylacteryLevelDataAttachment.PhylacteryRecord current = v0;
            if (current != null && !current.getHasSoul()) {
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                PhylacteryLevelDataAttachment.INSTANCE.setPhylacteryHasSoul(serverLevel, blockPos, true);
                this.hasSoul = true;
                this.setChanged();
                Level level = this.level;
                if (level != null) {
                    level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AbstractCandleBlock.LIT, (Comparable)Boolean.valueOf(true)));
                }
                serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                SoulPoolPlayerAttachment.Data pool = SoulPoolPlayerAttachment.getData(pPlayer);
                SoulPoolPlayerAttachment.setData(pPlayer, SoulPoolPlayerAttachment.Data.copy$default(pool, 0, pool.getSoulPool() + 1, 1, null));
                ((ServerPlayer)pPlayer).displayClientMessage((Component)Component.literal((String)"Soul bound to phylactery."), true);
            }
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    public void setLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super.setLevel(level);
        if (level instanceof ServerLevel) {
            Object v2;
            block3: {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                PhylacteryLevelDataAttachment.INSTANCE.applyPendingPhylacteryChangesForPos(serverLevel, blockPos);
                Iterable iterable = PhylacteryLevelDataAttachment.INSTANCE.listPhylacteries((ServerLevel)level);
                for (Object t : iterable) {
                    PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPos(), (Object)this.getBlockPos())) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            PhylacteryLevelDataAttachment.PhylacteryRecord record = v2;
            if (record != null) {
                this.hasSoul = record.getHasSoul();
                this.ownerUUID = record.getOwner();
            }
        }
    }

    @Override
    public void onPlace(@Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        super.onPlace(pPlacer, pStack);
        if (pPlacer instanceof ServerPlayer) {
            ServerLevel level = ((ServerPlayer)pPlacer).serverLevel();
            int lichLevel = AfflictionPlayerAttachment.getData((Player)pPlacer).getLichLevel();
            int maxSouls = (2 <= lichLevel ? lichLevel < 4 : false) ? 1 : ((4 <= lichLevel ? lichLevel < 6 : false) ? 2 : (lichLevel >= 6 ? 3 : 0));
            Intrinsics.checkNotNull((Object)level);
            UUID uUID = ((ServerPlayer)pPlacer).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            List<PhylacteryLevelDataAttachment.PhylacteryRecord> existing = PhylacteryLevelDataAttachment.INSTANCE.listPhylacteriesForPlayer(level, uUID);
            if (existing.size() >= maxSouls) {
                level.destroyBlock(this.getBlockPos(), true, (Entity)pPlacer);
                ((ServerPlayer)pPlacer).displayClientMessage((Component)Component.literal((String)"You cannot bind more phylacteries."), true);
                return;
            }
            this.ownerUUID = ((ServerPlayer)pPlacer).getUUID();
            this.ownerName = ((ServerPlayer)pPlacer).getName().getString();
            this.hasSoul = false;
            this.setChanged();
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            UUID uUID2 = ((ServerPlayer)pPlacer).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            PhylacteryLevelDataAttachment.INSTANCE.addPhylactery(level, new PhylacteryLevelDataAttachment.PhylacteryRecord(blockPos, uUID2, false));
        }
    }

    @Override
    public void onBreak(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onBreak(player);
        if (player instanceof ServerPlayer) {
            Object v0;
            ServerLevel level;
            block4: {
                level = ((ServerPlayer)player).serverLevel();
                Intrinsics.checkNotNull((Object)level);
                Iterable iterable = PhylacteryLevelDataAttachment.INSTANCE.listPhylacteries(level);
                for (Object t : iterable) {
                    PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPos(), (Object)this.getBlockPos())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            PhylacteryLevelDataAttachment.PhylacteryRecord record = v0;
            if (record != null) {
                if (record.getHasSoul()) {
                    SoulPoolPlayerAttachment.Data pool = SoulPoolPlayerAttachment.getData(player);
                    SoulPoolPlayerAttachment.setData(player, SoulPoolPlayerAttachment.Data.copy$default(pool, 0, RangesKt.coerceAtLeast((int)(pool.getSoulPool() - 1), (int)0), 1, null));
                }
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                PhylacteryLevelDataAttachment.INSTANCE.queueRemovePhylactery(level, blockPos);
            }
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        UUID uUID = this.ownerUUID;
        if (uUID != null) {
            it = uUID;
            boolean bl = false;
            tag.putUUID("OwnerUUID", (UUID)it);
        }
        String string = this.ownerName;
        if (string != null) {
            it = string;
            boolean bl = false;
            tag.putString("OwnerName", (String)it);
        }
        tag.putBoolean("HasSoul", this.hasSoul);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        if (tag.hasUUID("OwnerUUID")) {
            this.ownerUUID = tag.getUUID("OwnerUUID");
        }
        if (tag.contains("OwnerName")) {
            this.ownerName = tag.getString("OwnerName");
        }
        this.hasSoul = tag.getBoolean("HasSoul");
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)net, (String)"net");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.onDataPacket(net, packet, registries);
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.loadAdditional(tag, registries);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/content/block/phylactery/PhylacteryBlockEntity$Companion;", "", "<init>", "()V", "onPlayerLoad", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void onPlayerLoad(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (player instanceof ServerPlayer) {
                ServerLevel level = ((ServerPlayer)player).serverLevel();
                Intrinsics.checkNotNull((Object)level);
                Map<UUID, Integer> deltas = PhylacteryLevelDataAttachment.INSTANCE.popPendingPlayerDeltas(level);
                Integer n = deltas.get(((ServerPlayer)player).getUUID());
                int delta = n != null ? n : 0;
                SoulPoolPlayerAttachment.Data pool = SoulPoolPlayerAttachment.getData(player);
                int n2 = RangesKt.coerceAtLeast((int)(pool.getSoulPool() + delta), (int)0);
                int n3 = pool.getMaxSouls();
                SoulPoolPlayerAttachment.setData(player, pool.copy(n3, n2));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

