/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.AbstractSpectralEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/content/entity/BansheeEntity;", "Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "save", "", "compound", "Lnet/minecraft/nbt/CompoundTag;", "load", "isInvulnerableTo", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "Companion", "GhostMoveControl", "RandomFloatAroundGoal", "witchery"})
public final class BansheeEntity
extends AbstractSpectralEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Boolean> REVEALED;

    public BansheeEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getBANSHEE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((EntityType<? extends FlyingMob>)((EntityType)object), level);
        this.moveControl = new GhostMoveControl(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomFloatAroundGoal(this));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(REVEALED, (Object)false);
        super.defineSynchedData(builder);
    }

    public boolean save(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Object object = this.entityData.get(REVEALED);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        compound.putBoolean("Revealed", ((Boolean)object).booleanValue());
        return super.save(compound);
    }

    public void load(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.entityData.set(REVEALED, (Object)compound.getBoolean("Revealed"));
        super.load(compound);
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.is(DamageTypeTags.IS_PROJECTILE) || super.isInvulnerableTo(source);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(BansheeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        REVEALED = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/BansheeEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "REVEALED", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getREVEALED", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = FlyingMob.createMobAttributes().add(Attributes.FLYING_SPEED, 0.35).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getREVEALED() {
            return REVEALED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/entity/BansheeEntity$GhostMoveControl;", "Lnet/minecraft/world/entity/ai/control/MoveControl;", "ghost", "Ldev/sterner/witchery/content/entity/BansheeEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/BansheeEntity;)V", "floatDuration", "", "tick", "", "canReach", "", "pos", "Lnet/minecraft/world/phys/Vec3;", "length", "rotateTowards", "", "currentYaw", "targetYaw", "maxTurn", "witchery"})
    public static final class GhostMoveControl
    extends MoveControl {
        @NotNull
        private final BansheeEntity ghost;
        private int floatDuration;

        public GhostMoveControl(@NotNull BansheeEntity ghost) {
            Intrinsics.checkNotNullParameter((Object)((Object)ghost), (String)"ghost");
            super((Mob)ghost);
            this.ghost = ghost;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                int n = this.floatDuration;
                this.floatDuration = n + -1;
                if (n <= 0) {
                    this.floatDuration += this.ghost.random.nextInt(5) + 2;
                    Vec3 vec3 = new Vec3(this.wantedX - this.ghost.getX(), this.wantedY - this.ghost.getY(), this.wantedZ - this.ghost.getZ());
                    double d = vec3.length();
                    Vec3 vec32 = vec3.normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
                    vec3 = vec32;
                    if (this.canReach(vec3, Mth.ceil((double)d))) {
                        this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().add(vec3.scale(0.1)));
                    } else {
                        this.operation = MoveControl.Operation.WAIT;
                    }
                    if (d > 0.1) {
                        float targetYaw = (float)(Mth.atan2((double)vec3.z, (double)vec3.x) * 57.29577951308232) - 90.0f;
                        this.ghost.setYRot(this.rotateTowards(this.ghost.getYRot(), targetYaw, 25.0f));
                    }
                }
            }
        }

        private final boolean canReach(Vec3 pos, int length) {
            AABB aABB = this.ghost.getBoundingBox();
            for (int i = 1; i < length; ++i) {
                aABB = aABB.move(pos);
                if (this.ghost.level().noCollision((Entity)this.ghost, aABB)) continue;
                return false;
            }
            return true;
        }

        private final float rotateTowards(float currentYaw, float targetYaw, float maxTurn) {
            float deltaYaw = Mth.wrapDegrees((float)(targetYaw - currentYaw));
            return currentYaw + Mth.clamp((float)deltaYaw, (float)(-maxTurn), (float)maxTurn);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/BansheeEntity$RandomFloatAroundGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "bansheeEntity", "Ldev/sterner/witchery/content/entity/BansheeEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/BansheeEntity;)V", "canUse", "", "canContinueToUse", "start", "", "witchery"})
    public static final class RandomFloatAroundGoal
    extends Goal {
        @NotNull
        private final BansheeEntity bansheeEntity;

        public RandomFloatAroundGoal(@NotNull BansheeEntity bansheeEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)bansheeEntity), (String)"bansheeEntity");
            this.bansheeEntity = bansheeEntity;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double f;
            double e;
            MoveControl moveControl = this.bansheeEntity.moveControl;
            if (!moveControl.hasWanted()) {
                return true;
            }
            double d = moveControl.getWantedX() - this.bansheeEntity.getX();
            double g = d * d + (e = moveControl.getWantedY() - this.bansheeEntity.getY()) * e + (f = moveControl.getWantedZ() - this.bansheeEntity.getZ()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            RandomSource randomSource = this.bansheeEntity.random;
            double d = this.bansheeEntity.getX() + (double)((randomSource.nextFloat() * 2.0f - 1.0f) * 8.0f);
            double e = (double)randomSource.nextFloat() < 0.6 ? this.bansheeEntity.getY() - (double)(randomSource.nextFloat() * 8.0f) : this.bansheeEntity.getY() + (double)(randomSource.nextFloat() * 8.0f);
            double f = this.bansheeEntity.getZ() + (double)((randomSource.nextFloat() * 2.0f - 1.0f) * 8.0f);
            this.bansheeEntity.moveControl.setWantedPosition(d, e, f, 1.0);
        }
    }
}

