/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.ScytheThrownEntity;
import dev.sterner.witchery.content.entity.goal.FocusSummonerGoal;
import dev.sterner.witchery.content.entity.goal.ScytheThrowGoal;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 S2\u00020\u0001:\u0001SB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aH\u0002J\u0006\u0010\u001d\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020\u0016H\u0014J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#J,\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0002\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010/\u001a\u00020\u0016H\u0016J\b\u00100\u001a\u00020\u0016H\u0002J\u0018\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000bH\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\u000bH\u0002J\u0010\u00107\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002J \u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020:H\u0002J\u0010\u0010=\u001a\u00020\r2\u0006\u0010\"\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u000205H\u0016J\u000e\u0010C\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#J\u0006\u0010D\u001a\u00020\rJ\b\u0010E\u001a\u00020\u0016H\u0002J\u0010\u0010F\u001a\u00020\u00162\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00162\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u00020AH\u0016J\u0010\u0010L\u001a\u00020\u00162\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u00162\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u00020:H\u0016J\b\u0010R\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Ldev/sterner/witchery/content/entity/DeathEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "bossEvent", "Lnet/minecraft/server/level/ServerBossEvent;", "focusSummonerGoal", "Ldev/sterner/witchery/content/entity/goal/FocusSummonerGoal;", "teleportCooldown", "", "hasForcedTarget", "", "getHasForcedTarget", "()Z", "setHasForcedTarget", "(Z)V", "scytheThrowCooldown", "meleeCooldown", "lastPhase", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "getSummonerUUID", "Ljava/util/UUID;", "setSummonerUUID", "uuid", "getPhase", "setPhase", "phase", "registerGoals", "setForcedTarget", "target", "Lnet/minecraft/world/entity/LivingEntity;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnGroupData", "populateDefaultEquipmentSlots", "random", "Lnet/minecraft/util/RandomSource;", "tick", "updatePhase", "onPhaseChange", "oldPhase", "newPhase", "getTeleportChance", "", "getTeleportCooldown", "attemptTeleportNearTarget", "teleportDeathTo", "x", "", "y", "z", "doHurtTarget", "Lnet/minecraft/world/entity/Entity;", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "throwScythe", "canThrowScythe", "updateBossBar", "startSeenByPlayer", "player", "Lnet/minecraft/server/level/ServerPlayer;", "stopSeenByPlayer", "die", "damageSource", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "removeWhenFarAway", "distanceToClosestPlayer", "isPersistenceRequired", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nDeathEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeathEntity.kt\ndev/sterner/witchery/content/entity/DeathEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,477:1\n1#2:478\n*E\n"})
public final class DeathEntity
extends Monster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerBossEvent bossEvent;
    @NotNull
    private final FocusSummonerGoal focusSummonerGoal;
    private int teleportCooldown;
    private boolean hasForcedTarget;
    private int scytheThrowCooldown;
    private int meleeCooldown;
    private int lastPhase;
    @NotNull
    private static final EntityDataAccessor<Optional<UUID>> DATA_SUMMONER_UUID;
    @NotNull
    private static final EntityDataAccessor<Integer> DATA_PHASE;
    public static final int PHASE_NORMAL = 0;
    public static final int PHASE_ENRAGED = 1;
    public static final int PHASE_DESPERATE = 2;

    public DeathEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getDEATH().get(), level);
        this.bossEvent = new ServerBossEvent((Component)Component.translatable((String)"entity.witchery.death"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.focusSummonerGoal = new FocusSummonerGoal((Mob)this, 1200);
    }

    public final boolean getHasForcedTarget() {
        return this.hasForcedTarget;
    }

    public final void setHasForcedTarget(boolean bl) {
        this.hasForcedTarget = bl;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_SUMMONER_UUID, Optional.empty());
        builder.define(DATA_PHASE, (Object)0);
    }

    @Nullable
    public final UUID getSummonerUUID() {
        return ((Optional)this.entityData.get(DATA_SUMMONER_UUID)).orElse(null);
    }

    private final void setSummonerUUID(UUID uuid) {
        this.entityData.set(DATA_SUMMONER_UUID, Optional.ofNullable(uuid));
    }

    public final int getPhase() {
        Object object = this.entityData.get(DATA_PHASE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setPhase(int phase) {
        this.entityData.set(DATA_PHASE, (Object)phase);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ScytheThrowGoal(this, 20.0, 100, 60));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)this.focusSummonerGoal);
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public final void setForcedTarget(@NotNull LivingEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.setTarget(target);
        this.hasForcedTarget = true;
        this.setSummonerUUID(target.getUUID());
        this.focusSummonerGoal.setSummoner(target);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        RandomSource randomSource = level.getRandom();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
        this.populateDefaultEquipmentSlots(randomSource, difficulty);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource random, @NotNull DifficultyInstance difficulty) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WitcheryItems.INSTANCE.getDEATH_SICKLE().get()));
    }

    public void tick() {
        int n;
        super.tick();
        if (this.level().getGameTime() % (long)20 == 0L && this.getHealth() < this.getMaxHealth()) {
            this.heal(1.0f);
        }
        this.updatePhase();
        if (this.teleportCooldown > 0) {
            n = this.teleportCooldown;
            this.teleportCooldown = n + -1;
        } else {
            LivingEntity target = this.getTarget();
            if (target != null && target.isAlive() && this.random.nextFloat() < this.getTeleportChance()) {
                this.attemptTeleportNearTarget(target);
            }
        }
        this.updateBossBar();
        if (this.scytheThrowCooldown > 0) {
            n = this.scytheThrowCooldown;
            this.scytheThrowCooldown = n + -1;
        }
        if (this.meleeCooldown > 0) {
            n = this.meleeCooldown;
            this.meleeCooldown = n + -1;
        }
        switch (this.getPhase()) {
            case 1: {
                if (!(this.random.nextFloat() < 0.1f) || !(this.level() instanceof ServerLevel)) break;
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY() + 1.0, this.getZ(), 2, 0.3, 0.5, 0.3, 0.02);
                break;
            }
            case 2: {
                if (!(this.random.nextFloat() < 0.2f) || !(this.level() instanceof ServerLevel)) break;
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY() + 1.0, this.getZ(), 3, 0.4, 0.5, 0.4, 0.05);
            }
        }
    }

    private final void updatePhase() {
        int newPhase;
        float healthPercent = this.getHealth() / this.getMaxHealth();
        int n = healthPercent <= 0.25f ? 2 : (newPhase = healthPercent <= 0.5f ? 1 : 0);
        if (newPhase != this.lastPhase) {
            this.onPhaseChange(this.lastPhase, newPhase);
            this.lastPhase = newPhase;
            this.setPhase(newPhase);
        }
    }

    private final void onPhaseChange(int oldPhase, int newPhase) {
        if (this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            switch (newPhase) {
                case 1: {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY() + 1.0, this.getZ(), 50, 1.0, 1.0, 1.0, 0.1);
                    this.level().playSound(null, this.blockPosition(), SoundEvents.WITHER_AMBIENT, SoundSource.HOSTILE, 2.0f, 0.5f);
                    this.bossEvent.setColor(BossEvent.BossBarColor.YELLOW);
                    break;
                }
                case 2: {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY() + 1.0, this.getZ(), 100, 1.5, 1.5, 1.5, 0.15);
                    this.level().playSound(null, this.blockPosition(), SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 2.0f, 0.3f);
                    this.bossEvent.setColor(BossEvent.BossBarColor.RED);
                }
            }
        }
    }

    private final float getTeleportChance() {
        return switch (this.getPhase()) {
            case 2 -> 0.1f;
            case 1 -> 0.07f;
            default -> 0.05f;
        };
    }

    private final int getTeleportCooldown() {
        return switch (this.getPhase()) {
            case 2 -> 100;
            case 1 -> 160;
            default -> 200;
        };
    }

    private final void attemptTeleportNearTarget(LivingEntity target) {
        if (!(this.level() instanceof ServerLevel)) {
            return;
        }
        RandomSource random = RandomSource.create();
        for (int i = 0; i < 16; ++i) {
            double angle = random.nextDouble() * Math.PI * (double)2;
            double distance = 2.0 + random.nextDouble() * 2.0;
            double x = target.getX() + Math.cos(angle) * distance;
            double z = target.getZ() + Math.sin(angle) * distance;
            double y = target.getY() + random.nextDouble() * 2.0 - 1.0;
            if (!this.teleportDeathTo(x, y, z)) continue;
            if (this.level() instanceof ServerLevel) {
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.xo, this.yo + (double)(this.getBbHeight() / (float)2), this.zo, 30, 0.5, 0.5, 0.5, 0.5);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y + (double)(this.getBbHeight() / (float)2), z, 30, 0.5, 0.5, 0.5, 0.5);
            }
            this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.level().playSound(null, x, y, z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.teleportCooldown = this.getTeleportCooldown() + random.nextInt(100);
            break;
        }
    }

    private final boolean teleportDeathTo(double x, double y, double z) {
        Level level = this.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return false;
        }
        ServerLevel serverLevel2 = serverLevel;
        BlockPos blockPos = this.blockPosition().offset(Mth.floor((double)(x - this.getX())), Mth.floor((double)(y - this.getY())), Mth.floor((double)(z - this.getZ())));
        if (!serverLevel2.isEmptyBlock(blockPos) || !serverLevel2.isEmptyBlock(blockPos.above())) {
            return false;
        }
        this.teleportTo(x, y, z);
        return true;
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.meleeCooldown > 0) {
            return false;
        }
        if (target instanceof LivingEntity) {
            float damage = ((LivingEntity)target).getMaxHealth() * 0.15f;
            boolean result = ((LivingEntity)target).hurt(this.level().damageSources().mobAttack((LivingEntity)this), damage);
            if (result) {
                this.meleeCooldown = 10;
                if (this.level() instanceof ServerLevel) {
                    Level level = this.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, ((LivingEntity)target).getX(), ((LivingEntity)target).getY() + (double)(((LivingEntity)target).getBbHeight() / (float)2), ((LivingEntity)target).getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.level().playSound(null, target.blockPosition(), SoundEvents.PLAYER_ATTACK_STRONG, SoundSource.HOSTILE, 1.0f, 0.8f);
            }
            return result;
        }
        return super.doHurtTarget(target);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        float cappedDamage = Math.min(amount, 16.0f);
        boolean result = super.hurt(source, cappedDamage);
        if (result && this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, this.getX(), this.getY() + (double)(this.getBbHeight() / (float)2), this.getZ(), RangesKt.coerceAtLeast((int)((int)(cappedDamage / (float)2)), (int)1), 0.3, 0.3, 0.3, 0.0);
        }
        return result;
    }

    public final void throwScythe(@NotNull LivingEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.scytheThrowCooldown > 0) {
            return;
        }
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        ScytheThrownEntity scythe = new ScytheThrownEntity(level, (LivingEntity)this);
        double dx = target.getX() - this.getX();
        double dy = target.getEyeY() - this.getEyeY();
        double dz = target.getZ() - this.getZ();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        Vec3 velocity = new Vec3(dx, dy + horizontalDistance * 0.1, dz).normalize().scale(1.5);
        scythe.setDeltaMovement(velocity);
        this.level().addFreshEntity((Entity)scythe);
        this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.HOSTILE, 1.0f, 0.8f);
        this.scytheThrowCooldown = switch (this.getPhase()) {
            case 2 -> 60;
            case 1 -> 80;
            default -> 100;
        };
    }

    public final boolean canThrowScythe() {
        return this.scytheThrowCooldown <= 0;
    }

    private final void updateBossBar() {
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.level() instanceof ServerLevel) {
            List nearbyPlayers = this.level().getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(64.0));
            for (ServerPlayer player : nearbyPlayers) {
                this.bossEvent.addPlayer(player);
            }
            Collection collection = this.bossEvent.getPlayers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
            for (ServerPlayer player : CollectionsKt.toList((Iterable)collection)) {
                if (!(player.distanceToSqr((Entity)this) > 4096.0)) continue;
                this.bossEvent.removePlayer(player);
            }
        }
    }

    public void startSeenByPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    public void die(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.die(damageSource);
        if (this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY() + (double)(this.getBbHeight() / (float)2), this.getZ(), 100, 1.5, 1.5, 1.5, 0.2);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + (double)(this.getBbHeight() / (float)2), this.getZ(), 50, 1.0, 1.0, 1.0, 0.1);
            this.level().playSound(null, this.blockPosition(), SoundEvents.WITHER_DEATH, SoundSource.HOSTILE, 2.0f, 0.5f);
        }
        this.bossEvent.removeAllPlayers();
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("SummonerUUID")) {
            this.setSummonerUUID(compound.getUUID("SummonerUUID"));
        }
        this.hasForcedTarget = compound.getBoolean("HasForcedTarget");
        this.teleportCooldown = compound.getInt("TeleportCooldown");
        this.scytheThrowCooldown = compound.getInt("ScytheThrowCooldown");
        this.setPhase(compound.getInt("Phase"));
        this.lastPhase = this.getPhase();
        if (this.bossEvent != null) {
            Component component = this.getCustomName();
            if (component == null) {
                component = (Component)Component.translatable((String)"entity.witchery.death");
            }
            this.bossEvent.setName(component);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        UUID uUID = this.getSummonerUUID();
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            compound.putUUID("SummonerUUID", it);
        }
        compound.putBoolean("HasForcedTarget", this.hasForcedTarget);
        compound.putInt("TeleportCooldown", this.teleportCooldown);
        compound.putInt("ScytheThrowCooldown", this.scytheThrowCooldown);
        compound.putInt("Phase", this.getPhase());
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(DeathEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_SUMMONER_UUID = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(DeathEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        DATA_PHASE = entityDataAccessor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/DeathEntity$Companion;", "", "<init>", "()V", "DATA_SUMMONER_UUID", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Ljava/util/Optional;", "Ljava/util/UUID;", "DATA_PHASE", "", "PHASE_NORMAL", "PHASE_ENRAGED", "PHASE_DESPERATE", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 20.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.ARMOR, 10.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

