/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J \u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0016J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020*H\u0016J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020.J\u0014\u00101\u001a\u00020\u00122\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\u000e\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007J\b\u00106\u001a\u00020*H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ldev/sterner/witchery/content/entity/FloatingItemEntity;", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "bobOffs", "", "getBobOffs", "()F", "age", "", "getAge", "()I", "setAge", "(I)V", "maxAge", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "interact", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "playerTouch", "tick", "lerpMotion", "pX", "", "pY", "pZ", "lerpRotation", "currentRotation", "targetRotation", "isNoGravity", "", "fireImmune", "isAttackable", "getItem", "Lnet/minecraft/world/item/ItemStack;", "setItem", "stack", "onSyncedDataUpdated", "dataAccessor", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getSpin", "partialTick", "isPickable", "Companion", "witchery"})
public final class FloatingItemEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float bobOffs;
    private int age;
    private int maxAge;
    @NotNull
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK;

    public FloatingItemEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getFLOATING_ITEM().get(), level);
        this.bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.maxAge = 6000;
        this.noPhysics = false;
    }

    public final float getBobOffs() {
        return this.bobOffs;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.age = compound.getInt("age");
        this.maxAge = compound.getInt("maxAge");
        if (compound.contains("Item", 10)) {
            CompoundTag compoundTag = compound.getCompound("Item");
            ItemStack itemStack = ItemStack.parse((HolderLookup.Provider)((HolderLookup.Provider)this.registryAccess()), (Tag)((Tag)compoundTag)).orElse(ItemStack.EMPTY);
            Intrinsics.checkNotNull((Object)itemStack, (String)"null cannot be cast to non-null type net.minecraft.world.item.ItemStack");
            this.setItem(itemStack);
        } else {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.setItem(itemStack);
        }
        if (this.getItem().isEmpty()) {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.putInt("age", this.age);
        compound.putInt("maxAge", this.maxAge);
        if (!this.getItem().isEmpty()) {
            compound.put("Item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!player.level().isClientSide) {
            ItemStack itemStack = player.getMainHandItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            ItemStack handStack = itemStack;
            if (handStack.isEmpty() && hand == InteractionHand.MAIN_HAND) {
                player.setItemInHand(hand, this.getItem());
                this.remove(Entity.RemovalReason.DISCARDED);
                return InteractionResult.CONSUME;
            }
        }
        InteractionResult interactionResult = super.interact(player, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interact(...)");
        return interactionResult;
    }

    public void playerTouch(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.level().isClientSide) {
            ItemStack itemStack = this.getItem();
            Item item = itemStack.getItem();
            int i = itemStack.getCount();
            if (player.getInventory().add(itemStack)) {
                player.take((Entity)this, i);
                if (itemStack.isEmpty()) {
                    this.discard();
                    itemStack.setCount(i);
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), i);
            }
        }
    }

    public void tick() {
        super.tick();
        this.baseTick();
        int n = this.age;
        this.age = n + 1;
        if (this.age > this.maxAge) {
            this.discard();
        }
        this.checkInsideBlocks();
        Vec3 movement = this.getDeltaMovement();
        double nextX = this.getX() + movement.x;
        double nextY = this.getY() + movement.y;
        double nextZ = this.getZ() + movement.z;
        double distance = movement.horizontalDistance();
        float xRot = this.lerpRotation(this.xRotO, (float)(Mth.atan2((double)movement.y, (double)distance) * 57.2957763671875));
        float yRot = this.lerpRotation(this.yRotO, (float)(Mth.atan2((double)movement.x, (double)movement.z) * 57.2957763671875));
        this.setXRot(xRot);
        this.setYRot(yRot);
        this.setPos(nextX, nextY, nextZ);
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
    }

    public void lerpMotion(double pX, double pY, double pZ) {
        this.setDeltaMovement(pX, pY, pZ);
        this.setOldPosAndRot();
    }

    private final float lerpRotation(float currentRotation, float targetRotation) {
        float current = currentRotation;
        while (targetRotation - current < -180.0f) {
            current -= 360.0f;
        }
        while (targetRotation - current >= 180.0f) {
            current += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)current, (float)targetRotation);
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isAttackable() {
        return false;
    }

    @NotNull
    public final ItemStack getItem() {
        Object object = this.getEntityData().get(DATA_ITEM_STACK);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    public final void setItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.getEntityData().set(DATA_ITEM_STACK, (Object)stack);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataAccessor) {
        Intrinsics.checkNotNullParameter(dataAccessor, (String)"dataAccessor");
        super.onSyncedDataUpdated(dataAccessor);
        if (Intrinsics.areEqual(DATA_ITEM_STACK, dataAccessor)) {
            this.getItem().setEntityRepresentation((Entity)this);
        }
    }

    public final float getSpin(float partialTick) {
        return ((float)this.age + partialTick) / 20.0f + this.bobOffs;
    }

    public boolean isPickable() {
        return true;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_ITEM_STACK = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/content/entity/FloatingItemEntity$Companion;", "", "<init>", "()V", "DATA_ITEM_STACK", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/world/item/ItemStack;", "getDATA_ITEM_STACK", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<ItemStack> getDATA_ITEM_STACK() {
            return DATA_ITEM_STACK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

