/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.HornedHuntsmanEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 <2\u00020\u0001:\u0001<B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001bH\u0014J \u0010!\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0014J\b\u0010&\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020\tH\u0014J\b\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00152\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010%\u001a\u00020\tH\u0002J\b\u00104\u001a\u00020\u0015H\u0014J\b\u00105\u001a\u000206H\u0014J \u00107\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u000209H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ldev/sterner/witchery/content/entity/HuntsmanSpearEntity;", "Lnet/minecraft/world/entity/projectile/AbstractArrow;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "pickupItemStack", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "dealtDamage", "", "clientSideReturnSpearTickCount", "", "getClientSideReturnSpearTickCount", "()I", "setClientSideReturnSpearTickCount", "(I)V", "thrownByBoss", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "tick", "isAcceptibleReturnOwner", "findHitEntity", "Lnet/minecraft/world/phys/EntityHitResult;", "startVec", "Lnet/minecraft/world/phys/Vec3;", "endVec", "onHitEntity", "result", "hitBlockEnchantmentEffects", "Lnet/minecraft/server/level/ServerLevel;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "stack", "getWeaponItem", "tryPickup", "player", "Lnet/minecraft/world/entity/player/Player;", "getDefaultPickupItem", "getDefaultHitGroundSoundEvent", "Lnet/minecraft/sounds/SoundEvent;", "playerTouch", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "getLoyaltyFromItem", "", "tickDespawn", "getWaterInertia", "", "shouldRender", "x", "", "y", "z", "Companion", "witchery"})
public final class HuntsmanSpearEntity
extends AbstractArrow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean dealtDamage;
    private int clientSideReturnSpearTickCount;
    private boolean thrownByBoss;
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(HuntsmanSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(HuntsmanSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @NotNull
    private static final EntityDataAccessor<Boolean> ID_THROWN_BY_HUNTSMAN;
    private static final float BASE_DAMAGE = 12.0f;
    private static final float HUNTSMAN_DAMAGE_BONUS = 6.0f;

    public final int getClientSideReturnSpearTickCount() {
        return this.clientSideReturnSpearTickCount;
    }

    public final void setClientSideReturnSpearTickCount(int n) {
        this.clientSideReturnSpearTickCount = n;
    }

    public HuntsmanSpearEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getHUNTSMAN_SPEAR().get(), level);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public HuntsmanSpearEntity(@NotNull Level level, @NotNull LivingEntity owner, @NotNull ItemStack pickupItemStack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)pickupItemStack, (String)"pickupItemStack");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getHUNTSMAN_SPEAR().get(), owner, level, pickupItemStack, null);
        this.pickup = owner instanceof Player && ((Player)owner).getAbilities().instabuild ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.DISALLOWED;
        this.thrownByBoss = owner instanceof HornedHuntsmanEntity;
        this.entityData.set(ID_THROWN_BY_HUNTSMAN, (Object)this.thrownByBoss);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(pickupItemStack));
        this.entityData.set(ID_FOIL, (Object)pickupItemStack.hasFoil());
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(ID_LOYALTY, (Object)0);
        builder.define(ID_FOIL, (Object)false);
        builder.define(ID_THROWN_BY_HUNTSMAN, (Object)false);
    }

    public void tick() {
        Vec3 vec3;
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte loyalty = ((Number)this.entityData.get(ID_LOYALTY)).byteValue();
        if (loyalty > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)loyalty, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d = 0.05 * (double)loyalty;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
                if (this.level().isClientSide) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (entity instanceof HornedHuntsmanEntity && ((Boolean)this.entityData.get(ID_THROWN_BY_HUNTSMAN)).booleanValue() && (this.dealtDamage || this.isNoPhysics()) && loyalty <= 0) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                vec3 = ((HornedHuntsmanEntity)entity).getEyePosition().subtract(this.position());
                double returnSpeed = 0.03;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(returnSpeed)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.tick();
    }

    private final boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !((ServerPlayer)entity).isSpectator();
        }
        return false;
    }

    @Nullable
    protected EntityHitResult findHitEntity(@NotNull Vec3 startVec, @NotNull Vec3 endVec) {
        Intrinsics.checkNotNullParameter((Object)startVec, (String)"startVec");
        Intrinsics.checkNotNullParameter((Object)endVec, (String)"endVec");
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity owner;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Entity target = result.getEntity();
        float damage = 12.0f;
        if (((Boolean)this.entityData.get(ID_THROWN_BY_HUNTSMAN)).booleanValue()) {
            damage += 6.0f;
        }
        DamageSource damageSource = (owner = this.getOwner()) != null ? target.level().damageSources().trident((Entity)this, owner) : target.level().damageSources().trident((Entity)this, (Entity)this);
        Level level = this.level();
        if (level instanceof ServerLevel && target instanceof LivingEntity) {
            damage = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)level), (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)damage);
        }
        this.dealtDamage = true;
        if (target.hurt(damageSource, damage)) {
            if (level instanceof ServerLevel) {
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)((ServerLevel)level), (Entity)target, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
            }
            if (target instanceof LivingEntity) {
                RandomSource random;
                this.doKnockback((LivingEntity)target, damageSource);
                if (owner instanceof HornedHuntsmanEntity && (random = ((HornedHuntsmanEntity)owner).getRandom()).nextFloat() < 0.3f) {
                    Holder effect = switch (random.nextInt(3)) {
                        case 0 -> MobEffects.WEAKNESS;
                        case 1 -> MobEffects.MOVEMENT_SLOWDOWN;
                        default -> MobEffects.POISON;
                    };
                    ((LivingEntity)target).addEffect(new MobEffectInstance(effect, 120, 1));
                }
                this.doPostHurtEffects((LivingEntity)target);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    protected void hitBlockEnchantmentEffects(@NotNull ServerLevel level, @NotNull BlockHitResult hitResult, @NotNull ItemStack stack) {
        LivingEntity livingEntity;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Vec3 vec3 = hitResult.getBlockPos().clampLocationWithin(hitResult.getLocation());
        if (this.getOwner() instanceof LivingEntity) {
            Entity entity = this.getOwner();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            livingEntity = (LivingEntity)entity;
        } else {
            livingEntity = null;
        }
        LivingEntity livingOwner = livingEntity;
        EnchantmentHelper.onHitBlock((ServerLevel)level, (ItemStack)stack, (LivingEntity)livingOwner, (Entity)((Entity)this), null, (Vec3)vec3, (BlockState)level.getBlockState(hitResult.getBlockPos()), arg_0 -> HuntsmanSpearEntity.hitBlockEnchantmentEffects$lambda$0(this, arg_0));
    }

    @NotNull
    public ItemStack getWeaponItem() {
        ItemStack itemStack = this.getPickupItemStackOrigin();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getPickupItemStackOrigin(...)");
        return itemStack;
    }

    protected boolean tryPickup(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get());
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        SoundEvent soundEvent = SoundEvents.TRIDENT_HIT_GROUND;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TRIDENT_HIT_GROUND");
        return soundEvent;
    }

    public void playerTouch(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        this.dealtDamage = compound.getBoolean("DealtDamage");
        this.thrownByBoss = compound.getBoolean("ThrownByHuntsman");
        this.entityData.set(ID_THROWN_BY_HUNTSMAN, (Object)this.thrownByBoss);
        ItemStack itemStack = this.getPickupItemStackOrigin();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getPickupItemStackOrigin(...)");
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(itemStack));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DealtDamage", this.dealtDamage);
        compound.putBoolean("ThrownByHuntsman", this.thrownByBoss);
    }

    private final byte getLoyaltyFromItem(ItemStack stack) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            int enchantmentLoyalty = EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)((ServerLevel)level), (ItemStack)stack, (Entity)((Entity)this));
            int loyaltyValue = enchantmentLoyalty <= 0 ? 1 : enchantmentLoyalty;
            return (byte)Mth.clamp((int)loyaltyValue, (int)1, (int)127);
        }
        return 1;
    }

    protected void tickDespawn() {
        byte loyalty = ((Number)this.entityData.get(ID_LOYALTY)).byteValue();
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || loyalty <= 0) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    private static final void hitBlockEnchantmentEffects$lambda$0(HuntsmanSpearEntity this$0, Item it) {
        this$0.kill();
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HuntsmanSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        ID_THROWN_BY_HUNTSMAN = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\t0\t \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\t0\t\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/content/entity/HuntsmanSpearEntity$Companion;", "", "<init>", "()V", "ID_LOYALTY", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "ID_FOIL", "", "ID_THROWN_BY_HUNTSMAN", "getID_THROWN_BY_HUNTSMAN", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "BASE_DAMAGE", "", "HUNTSMAN_DAMAGE_BONUS", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getID_THROWN_BY_HUNTSMAN() {
            return ID_THROWN_BY_HUNTSMAN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

