/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010!\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0014J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0017H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ldev/sterner/witchery/content/entity/ScytheThrownEntity;", "Lnet/minecraft/world/entity/projectile/ThrowableProjectile;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "ownerUUID", "Ljava/util/UUID;", "ticksExisted", "", "maxDistance", "", "maxLifetime", "lastHitEntities", "", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "getRotationYaw", "", "setRotationYaw", "yaw", "isReturning", "", "setReturning", "returning", "tick", "checkEntityCollisions", "onHitEntity", "result", "Lnet/minecraft/world/phys/EntityHitResult;", "onHitBlock", "Lnet/minecraft/world/phys/BlockHitResult;", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "getOwner", "Lnet/minecraft/world/entity/Entity;", "isPickable", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nScytheThrownEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScytheThrownEntity.kt\ndev/sterner/witchery/content/entity/ScytheThrownEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
public final class ScytheThrownEntity
extends ThrowableProjectile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID ownerUUID;
    private int ticksExisted;
    private final double maxDistance;
    private final int maxLifetime;
    @NotNull
    private Set<Integer> lastHitEntities;
    @NotNull
    private static final EntityDataAccessor<Float> DATA_ROTATION_YAW;
    @NotNull
    private static final EntityDataAccessor<Boolean> DATA_RETURNING;

    public ScytheThrownEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getSCYTHE_THROWN().get(), level);
        this.maxDistance = 32.0;
        this.maxLifetime = 100;
        this.lastHitEntities = new LinkedHashSet();
    }

    public ScytheThrownEntity(@NotNull Level level, @NotNull LivingEntity owner) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getSCYTHE_THROWN().get(), owner, level);
        this.maxDistance = 32.0;
        this.maxLifetime = 100;
        this.lastHitEntities = new LinkedHashSet();
        this.ownerUUID = owner.getUUID();
        this.setPos(owner.getX(), owner.getEyeY() - 0.1, owner.getZ());
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(DATA_ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(DATA_RETURNING, (Object)false);
    }

    public final float getRotationYaw() {
        Object object = this.entityData.get(DATA_ROTATION_YAW);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    private final void setRotationYaw(float yaw) {
        this.entityData.set(DATA_ROTATION_YAW, (Object)Float.valueOf(yaw));
    }

    public final boolean isReturning() {
        Object object = this.entityData.get(DATA_RETURNING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setReturning(boolean returning) {
        this.entityData.set(DATA_RETURNING, (Object)returning);
    }

    public void tick() {
        double distanceToOwner;
        super.tick();
        int n = this.ticksExisted;
        this.ticksExisted = n + 1;
        this.setRotationYaw((this.getRotationYaw() + 30.0f) % 360.0f);
        if (this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            if (this.random.nextFloat() < 0.3f) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        Entity owner = this.getOwner();
        if (!this.isReturning() && owner != null && ((distanceToOwner = this.distanceToSqr(owner)) > this.maxDistance * this.maxDistance || this.ticksExisted > this.maxLifetime / 2)) {
            this.setReturning(true);
            this.lastHitEntities.clear();
        }
        if (this.isReturning() && owner != null) {
            Vec3 toOwner = owner.position().add(0.0, owner.getEyeY() - this.getY(), 0.0).subtract(this.position());
            double distance = toOwner.length();
            if (distance < 1.0) {
                this.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
                this.discard();
                return;
            }
            double speed = 0.5 + (1.0 - distance / this.maxDistance) * 0.5;
            Vec3 direction = toOwner.normalize().scale(speed);
            this.setDeltaMovement(direction);
        }
        this.checkEntityCollisions();
        if (this.ticksExisted > this.maxLifetime) {
            this.discard();
        }
    }

    private final void checkEntityCollisions() {
        AABB aabb = new AABB(this.getX() - 1.0, this.getY() - 0.5, this.getZ() - 1.0, this.getX() + 1.0, this.getY() + 0.5, this.getZ() + 1.0);
        List entities = this.level().getEntities((Entity)this, aabb, arg_0 -> ScytheThrownEntity.checkEntityCollisions$lambda$1(arg_0 -> ScytheThrownEntity.checkEntityCollisions$lambda$0(this, arg_0), arg_0));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            this.onHitEntity(new EntityHitResult(entity));
            this.lastHitEntities.add(((LivingEntity)entity).getId());
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.HOSTILE, 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitEntity(result);
        if (this.level().isClientSide) {
            return;
        }
        Entity entity = result.getEntity();
        Entity owner = this.getOwner();
        if (entity instanceof LivingEntity && !Intrinsics.areEqual((Object)entity, (Object)owner)) {
            float baseDamage = owner instanceof LivingEntity ? ((LivingEntity)owner).getMaxHealth() * 0.1f : 15.0f;
            DamageSource damageSource = owner != null ? this.level().damageSources().mobAttack((LivingEntity)owner) : this.level().damageSources().magic();
            ((LivingEntity)entity).hurt(damageSource, baseDamage);
            double knockbackStrength = 0.5;
            double angle = Math.atan2(((LivingEntity)entity).getZ() - this.getZ(), ((LivingEntity)entity).getX() - this.getX());
            ((LivingEntity)entity).knockback(knockbackStrength, -Math.cos(angle), -Math.sin(angle));
            if (this.level() instanceof ServerLevel) {
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, ((LivingEntity)entity).getX(), ((LivingEntity)entity).getY() + (double)(((LivingEntity)entity).getBbHeight() / (float)2), ((LivingEntity)entity).getZ(), 3, 0.5, 0.5, 0.5, 0.0);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, ((LivingEntity)entity).getX(), ((LivingEntity)entity).getY() + (double)(((LivingEntity)entity).getBbHeight() / (float)2), ((LivingEntity)entity).getZ(), 5, 0.3, 0.3, 0.3, 0.0);
            }
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitBlock(result);
        if (!this.isReturning()) {
            this.setReturning(true);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ANVIL_LAND, SoundSource.HOSTILE, 0.5f, 1.5f);
            if (this.level() instanceof ServerLevel) {
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY(), this.getZ(), 10, 0.2, 0.2, 0.2, 0.1);
            }
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            super.addAdditionalSaveData(compound);
            compound.putInt("TicksExisted", this.ticksExisted);
            compound.putBoolean("Returning", this.isReturning());
            UUID uUID = this.ownerUUID;
            if (uUID == null) break block0;
            UUID it = uUID;
            boolean bl = false;
            compound.putUUID("OwnerUUID", it);
        }
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        this.ticksExisted = compound.getInt("TicksExisted");
        this.setReturning(compound.getBoolean("Returning"));
        if (compound.hasUUID("OwnerUUID")) {
            this.ownerUUID = compound.getUUID("OwnerUUID");
        }
    }

    @Nullable
    public Entity getOwner() {
        UUID uUID;
        block6: {
            block5: {
                Entity entity;
                uUID = this.ownerUUID;
                if (uUID == null) break block5;
                UUID uuid = uUID;
                boolean bl = false;
                if (this.level() instanceof ServerLevel) {
                    Level level = this.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    entity = ((ServerLevel)level).getEntity(uuid);
                } else {
                    entity = super.getOwner();
                }
                uUID = entity;
                if (entity != null) break block6;
            }
            uUID = super.getOwner();
        }
        return uUID;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return false;
    }

    private static final boolean checkEntityCollisions$lambda$0(ScytheThrownEntity this$0, Entity entity) {
        return entity instanceof LivingEntity && !Intrinsics.areEqual((Object)entity, (Object)this$0.getOwner()) && ((LivingEntity)entity).isAlive() && !this$0.lastHitEntities.contains(((LivingEntity)entity).getId());
    }

    private static final boolean checkEntityCollisions$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(ScytheThrownEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_ROTATION_YAW = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(ScytheThrownEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        DATA_RETURNING = entityDataAccessor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/content/entity/ScytheThrownEntity$Companion;", "", "<init>", "()V", "DATA_ROTATION_YAW", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "DATA_RETURNING", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

