/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.AbstractSpectralEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0005'()*+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006,"}, d2={"Ldev/sterner/witchery/content/entity/SpectreEntity;", "Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "ignoredUUIDs", "", "Ljava/util/UUID;", "getIgnoredUUIDs", "()Ljava/util/Set;", "summonPos", "Lnet/minecraft/world/phys/Vec3;", "getSummonPos", "()Lnet/minecraft/world/phys/Vec3;", "setSummonPos", "(Lnet/minecraft/world/phys/Vec3;)V", "attackCount", "", "getAttackCount", "()I", "setAttackCount", "(I)V", "attackTicksRemaining", "getAttackTicksRemaining", "setAttackTicksRemaining", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "save", "", "compound", "Lnet/minecraft/nbt/CompoundTag;", "load", "isInvulnerableTo", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "Companion", "GhostMoveControl", "RandomFloatAroundGoal", "TargetNearbyPlayersGoal", "AttackAndReturnGoal", "witchery"})
public final class SpectreEntity
extends AbstractSpectralEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<UUID> ignoredUUIDs;
    @NotNull
    private Vec3 summonPos;
    private int attackCount;
    private int attackTicksRemaining;
    @NotNull
    private static final EntityDataAccessor<Boolean> REVEALED;

    public SpectreEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getSPECTRE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((EntityType<? extends FlyingMob>)((EntityType)object), level);
        this.ignoredUUIDs = new LinkedHashSet();
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.summonPos = vec3;
        this.moveControl = new GhostMoveControl(this);
    }

    @NotNull
    public final Set<UUID> getIgnoredUUIDs() {
        return this.ignoredUUIDs;
    }

    @NotNull
    public final Vec3 getSummonPos() {
        return this.summonPos;
    }

    public final void setSummonPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.summonPos = vec3;
    }

    public final int getAttackCount() {
        return this.attackCount;
    }

    public final void setAttackCount(int n) {
        this.attackCount = n;
    }

    public final int getAttackTicksRemaining() {
        return this.attackTicksRemaining;
    }

    public final void setAttackTicksRemaining(int n) {
        this.attackTicksRemaining = n;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomFloatAroundGoal(this));
        this.targetSelector.addGoal(1, (Goal)new TargetNearbyPlayersGoal(this, 32.0));
        this.goalSelector.addGoal(2, (Goal)new AttackAndReturnGoal(this));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(REVEALED, (Object)false);
        super.defineSynchedData(builder);
    }

    public boolean save(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Object object = this.entityData.get(REVEALED);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        compound.putBoolean("Revealed", ((Boolean)object).booleanValue());
        return super.save(compound);
    }

    public void load(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.entityData.set(REVEALED, (Object)compound.getBoolean("Revealed"));
        super.load(compound);
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.is(DamageTypeTags.IS_PROJECTILE) || super.isInvulnerableTo(source);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(SpectreEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        REVEALED = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/SpectreEntity$AttackAndReturnGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "spectre", "Ldev/sterner/witchery/content/entity/SpectreEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/SpectreEntity;)V", "returning", "", "maxAttacks", "", "canUse", "canContinueToUse", "tick", "", "start", "witchery"})
    public static final class AttackAndReturnGoal
    extends Goal {
        @NotNull
        private final SpectreEntity spectre;
        private boolean returning;
        private final int maxAttacks;

        public AttackAndReturnGoal(@NotNull SpectreEntity spectre) {
            Intrinsics.checkNotNullParameter((Object)((Object)spectre), (String)"spectre");
            this.spectre = spectre;
            this.maxAttacks = 5;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.spectre.getTarget() != null || this.returning;
        }

        public boolean canContinueToUse() {
            return !this.returning || this.spectre.distanceToSqr(this.spectre.getSummonPos()) > 1.0;
        }

        public void tick() {
            int n;
            SpectreEntity spectreEntity;
            LivingEntity target = this.spectre.getTarget();
            if (!this.returning && target != null && target.isAlive() && this.spectre.getAttackCount() < this.maxAttacks) {
                this.spectre.lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                this.spectre.moveControl.setWantedPosition(target.getX(), target.getY(), target.getZ(), 1.1);
                if (this.spectre.getBoundingBox().inflate(1.2).intersects(target.getBoundingBox()) && this.spectre.getAttackTicksRemaining() <= 0) {
                    this.spectre.doHurtTarget((Entity)target);
                    spectreEntity = this.spectre;
                    n = spectreEntity.getAttackCount();
                    spectreEntity.setAttackCount(n + 1);
                    this.spectre.setAttackTicksRemaining(20);
                }
            } else {
                this.returning = true;
                this.spectre.setTarget(null);
                this.spectre.moveControl.setWantedPosition(this.spectre.getSummonPos().x, this.spectre.getSummonPos().y, this.spectre.getSummonPos().z, 1.0);
                if (this.spectre.distanceToSqr(this.spectre.getSummonPos()) < 1.0) {
                    this.spectre.discard();
                }
            }
            if (this.spectre.getAttackTicksRemaining() > 0) {
                spectreEntity = this.spectre;
                n = spectreEntity.getAttackTicksRemaining();
                spectreEntity.setAttackTicksRemaining(n + -1);
            }
        }

        public void start() {
            this.returning = false;
            this.spectre.setAttackCount(0);
            this.spectre.setAttackTicksRemaining(0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/entity/SpectreEntity$Companion;", "", "<init>", "()V", "summonSpectre", "Ldev/sterner/witchery/content/entity/SpectreEntity;", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "ignoredUUIDs", "", "Ljava/util/UUID;", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "REVEALED", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getREVEALED", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpectreEntity summonSpectre(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Set<UUID> ignoredUUIDs) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(ignoredUUIDs, (String)"ignoredUUIDs");
            SpectreEntity spectre = new SpectreEntity((Level)level);
            spectre.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            spectre.getIgnoredUUIDs().addAll((Collection<UUID>)ignoredUUIDs);
            Vec3 vec3 = spectre.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            spectre.setSummonPos(vec3);
            level.addFreshEntity((Entity)spectre);
            return spectre;
        }

        public static /* synthetic */ SpectreEntity summonSpectre$default(Companion companion, ServerLevel serverLevel, BlockPos blockPos, Set set, int n, Object object) {
            if ((n & 4) != 0) {
                set = SetsKt.emptySet();
            }
            return companion.summonSpectre(serverLevel, blockPos, set);
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = FlyingMob.createMobAttributes().add(Attributes.FLYING_SPEED, 0.35).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getREVEALED() {
            return REVEALED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/entity/SpectreEntity$GhostMoveControl;", "Lnet/minecraft/world/entity/ai/control/MoveControl;", "ghost", "Ldev/sterner/witchery/content/entity/SpectreEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/SpectreEntity;)V", "floatDuration", "", "tick", "", "canReach", "", "pos", "Lnet/minecraft/world/phys/Vec3;", "length", "rotateTowards", "", "currentYaw", "targetYaw", "maxTurn", "witchery"})
    public static final class GhostMoveControl
    extends MoveControl {
        @NotNull
        private final SpectreEntity ghost;
        private int floatDuration;

        public GhostMoveControl(@NotNull SpectreEntity ghost) {
            Intrinsics.checkNotNullParameter((Object)((Object)ghost), (String)"ghost");
            super((Mob)ghost);
            this.ghost = ghost;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                int n = this.floatDuration;
                this.floatDuration = n + -1;
                if (n <= 0) {
                    this.floatDuration = this.floatDuration + this.ghost.random.nextInt(5) + 2;
                    Vec3 vec3 = new Vec3(this.wantedX - this.ghost.getX(), this.wantedY - this.ghost.getY(), this.wantedZ - this.ghost.getZ());
                    double d = vec3.length();
                    Vec3 vec32 = vec3.normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
                    vec3 = vec32;
                    if (this.canReach(vec3, Mth.ceil((double)d))) {
                        this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().add(vec3.scale(0.1)));
                    } else {
                        this.operation = MoveControl.Operation.WAIT;
                    }
                    if (d > 0.1) {
                        float targetYaw = (float)(Mth.atan2((double)vec3.z, (double)vec3.x) * 57.29577951308232) - 90.0f;
                        this.ghost.setYRot(this.rotateTowards(this.ghost.getYRot(), targetYaw, 25.0f));
                    }
                }
            }
        }

        private final boolean canReach(Vec3 pos, int length) {
            AABB aABB = this.ghost.getBoundingBox();
            for (int i = 1; i < length; ++i) {
                aABB = aABB.move(pos);
                if (this.ghost.level().noCollision((Entity)this.ghost, aABB)) continue;
                return false;
            }
            return true;
        }

        private final float rotateTowards(float currentYaw, float targetYaw, float maxTurn) {
            float deltaYaw = Mth.wrapDegrees((float)(targetYaw - currentYaw));
            return currentYaw + Mth.clamp((float)deltaYaw, (float)(-maxTurn), (float)maxTurn);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/SpectreEntity$RandomFloatAroundGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "spectreEntity", "Ldev/sterner/witchery/content/entity/SpectreEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/SpectreEntity;)V", "canUse", "", "canContinueToUse", "start", "", "witchery"})
    public static final class RandomFloatAroundGoal
    extends Goal {
        @NotNull
        private final SpectreEntity spectreEntity;

        public RandomFloatAroundGoal(@NotNull SpectreEntity spectreEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)spectreEntity), (String)"spectreEntity");
            this.spectreEntity = spectreEntity;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double f;
            double e;
            MoveControl moveControl = this.spectreEntity.moveControl;
            if (!moveControl.hasWanted()) {
                return true;
            }
            double d = moveControl.getWantedX() - this.spectreEntity.getX();
            double g = d * d + (e = moveControl.getWantedY() - this.spectreEntity.getY()) * e + (f = moveControl.getWantedZ() - this.spectreEntity.getZ()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            RandomSource randomSource = this.spectreEntity.random;
            double d = this.spectreEntity.getX() + (double)((randomSource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double e = (double)randomSource.nextFloat() < 0.6 ? this.spectreEntity.getY() - (double)(randomSource.nextFloat() * 8.0f) : this.spectreEntity.getY() + (double)(randomSource.nextFloat() * 8.0f);
            double f = this.spectreEntity.getZ() + (double)((randomSource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.spectreEntity.moveControl.setWantedPosition(d, e, f, 1.0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/content/entity/SpectreEntity$TargetNearbyPlayersGoal;", "Lnet/minecraft/world/entity/ai/goal/target/TargetGoal;", "spectre", "Ldev/sterner/witchery/content/entity/SpectreEntity;", "range", "", "<init>", "(Ldev/sterner/witchery/content/entity/SpectreEntity;D)V", "canUse", "", "witchery"})
    @SourceDebugExtension(value={"SMAP\nSpectreEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpectreEntity.kt\ndev/sterner/witchery/content/entity/SpectreEntity$TargetNearbyPlayersGoal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n774#2:263\n865#2,2:264\n*S KotlinDebug\n*F\n+ 1 SpectreEntity.kt\ndev/sterner/witchery/content/entity/SpectreEntity$TargetNearbyPlayersGoal\n*L\n192#1:263\n192#1:264,2\n*E\n"})
    public static final class TargetNearbyPlayersGoal
    extends TargetGoal {
        @NotNull
        private final SpectreEntity spectre;
        private final double range;

        public TargetNearbyPlayersGoal(@NotNull SpectreEntity spectre, double range) {
            Intrinsics.checkNotNullParameter((Object)((Object)spectre), (String)"spectre");
            super((Mob)spectre, false);
            this.spectre = spectre;
            this.range = range;
        }

        /*
         * WARNING - void declaration
         */
        public boolean canUse() {
            void $this$filterTo$iv$iv;
            Level level = this.spectre.level();
            List list = level.players();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Player player = (Player)element$iv$iv;
                boolean bl = false;
                if (!(!player.isSpectator() && !this.spectre.getIgnoredUUIDs().contains(player.getUUID()) && player.distanceToSqr((Entity)this.spectre) <= this.range * this.range)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List potentialTargets = (List)destination$iv$iv;
            if (!((Collection)potentialTargets).isEmpty()) {
                this.spectre.setTarget((LivingEntity)CollectionsKt.random((Collection)potentialTargets, (Random)((Random)Random.Default)));
                return true;
            }
            return false;
        }
    }
}

