/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.item.brew.BrewItem;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.familiar.FamiliarHandler;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001dH\u0014J \u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0015H\u0002J \u0010\u001e\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u000bH\u0014\u00a8\u0006."}, d2={"Ldev/sterner/witchery/content/entity/ThrownBrewEntity;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "Lnet/minecraft/world/entity/projectile/ItemSupplier;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "x", "", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "setIsQuartzSphere", "isQuartz", "", "isQuartzSphere", "onHitBlock", "result", "Lnet/minecraft/world/phys/BlockHitResult;", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "onHit", "Lnet/minecraft/world/phys/HitResult;", "applySplash", "item", "Ldev/sterner/witchery/content/item/brew/BrewItem;", "hasFrog", "effects", "", "Lnet/minecraft/world/effect/MobEffectInstance;", "pEntity", "Lnet/minecraft/world/entity/Entity;", "calculateHorizontalHurtKnockbackDirection", "Lit/unimi/dsi/fastutil/doubles/DoubleDoubleImmutablePair;", "entity", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "getDefaultGravity", "Companion", "witchery"})
public final class ThrownBrewEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Boolean> DATA_IS_QUARTZ_SPHERE;

    public ThrownBrewEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getTHROWN_BREW().get(), level);
    }

    public ThrownBrewEntity(@NotNull Level level, @NotNull LivingEntity shooter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getTHROWN_BREW().get(), shooter, level);
    }

    public ThrownBrewEntity(@NotNull Level level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getTHROWN_BREW().get(), x, y, z, level);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_IS_QUARTZ_SPHERE, (Object)false);
    }

    public final void setIsQuartzSphere(boolean isQuartz) {
        this.entityData.set(DATA_IS_QUARTZ_SPHERE, (Object)isQuartz);
    }

    public final boolean isQuartzSphere() {
        Object object = this.entityData.get(DATA_IS_QUARTZ_SPHERE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitBlock(result);
    }

    @NotNull
    protected Item getDefaultItem() {
        Item item = Items.SPLASH_POTION;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"SPLASH_POTION");
        return item;
    }

    /*
     * Unable to fully structure code
     */
    protected void onHit(@NotNull HitResult result) {
        block7: {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    super.onHit(result);
                    if (this.level().isClientSide) break block7;
                    itemStack = this.getItem();
                    if (!(itemStack.getItem() instanceof BrewItem)) break block8;
                    if (!(this.getOwner() instanceof Player)) ** GOTO lbl-1000
                    v0 = this.getOwner();
                    Intrinsics.checkNotNull((Object)v0);
                    v1 = v0.getUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getUUID(...)");
                    v2 = this.level();
                    Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    if (Intrinsics.areEqual(FamiliarHandler.INSTANCE.getFamiliarEntityType(v1, (ServerLevel)v2), (Object)EntityType.FROG)) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    frog = v3;
                    v4 = itemStack.getItem();
                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.item.brew.BrewItem");
                    brew = (BrewItem)v4;
                    if (result.getType() == HitResult.Type.BLOCK && brew.getPredicate().test((Object)((BlockHitResult)result).getDirection())) {
                        this.applySplash(brew, result, frog);
                        color = brew.getColor();
                        this.level().levelEvent(2002, this.blockPosition(), color);
                    } else if (result.getType() != HitResult.Type.BLOCK) {
                        this.applySplash(brew, result, frog);
                        color = brew.getColor();
                        this.level().levelEvent(2002, this.blockPosition(), color);
                    } else {
                        Containers.dropItemStack((Level)this.level(), (double)result.getLocation().x, (double)result.getLocation().y, (double)result.getLocation().z, (ItemStack)itemStack);
                    }
                    break block9;
                }
                if (itemStack.getItem() instanceof PotionItem) {
                    potionContents = (PotionContents)this.getItem().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                    v5 = potionContents.getAllEffects();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getAllEffects(...)");
                    this.applySplash(v5, result.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)result).getEntity() : null);
                    i = potionContents.potion().isPresent() != false && ((Potion)((Holder)potionContents.potion().get()).value()).hasInstantEffects() != false ? 2007 : 2002;
                    this.level().levelEvent(i, this.blockPosition(), potionContents.getColor());
                }
            }
            this.discard();
        }
    }

    private final void applySplash(BrewItem item, HitResult result, boolean hasFrog) {
        AABB aABB = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aABB);
        Intrinsics.checkNotNull((Object)list);
        if (!((Collection)list).isEmpty()) {
            for (LivingEntity livingEntity : list) {
                Level level = this.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                Intrinsics.checkNotNull((Object)livingEntity);
                item.applyEffectOnEntities(level, livingEntity, hasFrog);
            }
        }
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Vec3 vec3 = result.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLocation(...)");
        item.applyEffectOnHitLocation(level, vec3, hasFrog);
        if (result.getType() == HitResult.Type.BLOCK) {
            Level level2 = this.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type net.minecraft.world.phys.BlockHitResult");
            item.applyEffectOnBlock(level2, (BlockHitResult)result, hasFrog);
        }
    }

    private final void applySplash(Iterable<? extends MobEffectInstance> effects, Entity pEntity) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            Entity entity = this.getEffectSource();
            for (LivingEntity livingEntity : list) {
                double d0;
                if (livingEntity == null || !livingEntity.isAffectedByPotions() || !((d0 = this.distanceToSqr((Entity)livingEntity)) < 16.0)) continue;
                double d1 = livingEntity == pEntity ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                for (MobEffectInstance mobEffectInstance : effects) {
                    Holder holder = mobEffectInstance.getEffect();
                    if (((MobEffect)holder.value()).isInstantenous()) {
                        ((MobEffect)holder.value()).applyInstantenousEffect((Entity)this, this.getOwner(), livingEntity, mobEffectInstance.getAmplifier(), d1);
                        continue;
                    }
                    int i = mobEffectInstance.mapDuration(arg_0 -> ThrownBrewEntity.applySplash$lambda$0(d1, arg_0));
                    MobEffectInstance mobEffectInstance1 = new MobEffectInstance(holder, i, mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible());
                    if (mobEffectInstance1.endsWithin(20)) continue;
                    livingEntity.addEffect(mobEffectInstance1, entity);
                }
            }
        }
    }

    @NotNull
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(@NotNull LivingEntity entity, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        double d = entity.position().x - this.position().x;
        double e = entity.position().z - this.position().z;
        DoubleDoubleImmutablePair doubleDoubleImmutablePair = DoubleDoubleImmutablePair.of((double)d, (double)e);
        Intrinsics.checkNotNullExpressionValue((Object)doubleDoubleImmutablePair, (String)"of(...)");
        return doubleDoubleImmutablePair;
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    private static final int applySplash$lambda$0(double $d1, int p_267930_) {
        return (int)($d1 * (double)p_267930_ + 0.5);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(ThrownBrewEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_IS_QUARTZ_SPHERE = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/sterner/witchery/content/entity/ThrownBrewEntity$Companion;", "", "<init>", "()V", "DATA_IS_QUARTZ_SPHERE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

