/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.block.blood_crucible.BloodCrucibleBlockEntity;
import dev.sterner.witchery.content.entity.goal.DrinkBloodTargetingGoal;
import dev.sterner.witchery.content.entity.goal.NightHuntGoal;
import dev.sterner.witchery.content.entity.goal.VampireEscapeSunGoal;
import dev.sterner.witchery.content.entity.goal.VampireHurtByTargetGoal;
import dev.sterner.witchery.core.registry.WitcheryDamageSources;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.vampire.VampireChildrenHuntHandler;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.mixin.DamageSourcesInvoker;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 F2\u00020\u0001:\u0001FB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020-H\u0016J\b\u00102\u001a\u00020-H\u0002J\b\u00103\u001a\u00020-H\u0002J\b\u00104\u001a\u00020-H\u0002J\b\u00105\u001a\u00020-H\u0002J\b\u00106\u001a\u00020-H\u0002J\u0006\u00107\u001a\u00020-J\u000e\u00108\u001a\u00020-2\u0006\u00109\u001a\u00020\u001fJ\b\u0010:\u001a\u00020\u0007H\u0002J\u0010\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020=H\u0014J\b\u0010>\u001a\u0004\u0018\u00010?J\u0010\u0010@\u001a\u00020-2\b\u0010A\u001a\u0004\u0018\u00010?J\u0010\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020-2\u0006\u0010C\u001a\u00020DH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Ldev/sterner/witchery/content/entity/VampireEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "lastHuntTimestamp", "", "getLastHuntTimestamp", "()J", "setLastHuntTimestamp", "(J)V", "huntedLastNight", "", "getHuntedLastNight", "()Z", "setHuntedLastNight", "(Z)V", "creationPos", "Lnet/minecraft/core/BlockPos;", "getCreationPos", "()Lnet/minecraft/core/BlockPos;", "setCreationPos", "(Lnet/minecraft/core/BlockPos;)V", "coffinPos", "getCoffinPos", "setCoffinPos", "altarPos", "getAltarPos", "setAltarPos", "collectedBlood", "", "getCollectedBlood", "()I", "setCollectedBlood", "(I)V", "inSunTick", "masterPlayer", "Lnet/minecraft/world/entity/player/Player;", "hasMaster", "getWalkTargetValue", "", "pos", "Lnet/minecraft/world/level/LevelReader;", "registerGoals", "", "doHurtTarget", "target", "Lnet/minecraft/world/entity/Entity;", "baseTick", "handleSunlightDamage", "handleBloodHealing", "updateHuntStatus", "tryDepositBloodAtAltar", "updateMasterPlayerReference", "tryStartHunt", "returnFromHunt", "bloodAmount", "nightDuration", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "getOwnerUUID", "Ljava/util/UUID;", "setOwnerUUID", "uuid", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "Companion", "witchery"})
public final class VampireEntity
extends PathfinderMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastHuntTimestamp;
    private boolean huntedLastNight;
    @Nullable
    private BlockPos creationPos;
    @Nullable
    private BlockPos coffinPos;
    @Nullable
    private BlockPos altarPos;
    private int collectedBlood;
    private int inSunTick;
    @Nullable
    private Player masterPlayer;
    private boolean hasMaster;
    @NotNull
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID;

    public VampireEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getVAMPIRE().get(), level);
    }

    public final long getLastHuntTimestamp() {
        return this.lastHuntTimestamp;
    }

    public final void setLastHuntTimestamp(long l) {
        this.lastHuntTimestamp = l;
    }

    public final boolean getHuntedLastNight() {
        return this.huntedLastNight;
    }

    public final void setHuntedLastNight(boolean bl) {
        this.huntedLastNight = bl;
    }

    @Nullable
    public final BlockPos getCreationPos() {
        return this.creationPos;
    }

    public final void setCreationPos(@Nullable BlockPos blockPos) {
        this.creationPos = blockPos;
    }

    @Nullable
    public final BlockPos getCoffinPos() {
        return this.coffinPos;
    }

    public final void setCoffinPos(@Nullable BlockPos blockPos) {
        this.coffinPos = blockPos;
    }

    @Nullable
    public final BlockPos getAltarPos() {
        return this.altarPos;
    }

    public final void setAltarPos(@Nullable BlockPos blockPos) {
        this.altarPos = blockPos;
    }

    public final int getCollectedBlood() {
        return this.collectedBlood;
    }

    public final void setCollectedBlood(int n) {
        this.collectedBlood = n;
    }

    public float getWalkTargetValue(@NotNull BlockPos pos, @NotNull LevelReader level) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return -level.getPathfindingCostFromLightLevels(pos);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new VampireEscapeSunGoal(this, 1.4));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(5, (Goal)new NightHuntGoal(this));
        this.targetSelector.addGoal(3, (Goal)new DrinkBloodTargetingGoal<Mob>((Mob)this, Mob.class, true));
        this.targetSelector.addGoal(0, (Goal)new VampireHurtByTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        super.registerGoals();
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        BloodPoolLivingEntityAttachment.Data targetBlood;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean bl = super.doHurtTarget(target);
        BloodPoolLivingEntityAttachment.Data pool = BloodPoolLivingEntityAttachment.getData((LivingEntity)this);
        if (bl && target instanceof LivingEntity && pool.getBloodPool() < pool.getMaxBlood() && (targetBlood = BloodPoolLivingEntityAttachment.getData((LivingEntity)target)).getMaxBlood() > 0) {
            int bloodAmount = 10;
            BloodPoolHandler.increaseBlood((LivingEntity)this, bloodAmount);
            BloodPoolHandler.decreaseBlood((LivingEntity)target, bloodAmount);
            this.collectedBlood += bloodAmount;
        }
        return bl;
    }

    public void baseTick() {
        super.baseTick();
        this.handleSunlightDamage();
        this.handleBloodHealing();
        this.updateHuntStatus();
        this.tryDepositBloodAtAltar();
        if (this.hasMaster && this.level() instanceof ServerLevel) {
            this.updateMasterPlayerReference();
        }
    }

    private final void handleSunlightDamage() {
        boolean isInSunlight;
        boolean canSeeSky = this.level().canSeeSky(this.blockPosition());
        boolean isDay = this.level().isDay();
        boolean bl = isInSunlight = canSeeSky && isDay;
        if (isInSunlight) {
            int n = this.inSunTick;
            this.inSunTick = n + 1;
            this.inSunTick = Math.min(this.inSunTick, 80);
            if (this.inSunTick >= 80 && this.tickCount % 20 == 0) {
                DamageSources damageSources = this.level().damageSources();
                Intrinsics.checkNotNull((Object)damageSources, (String)"null cannot be cast to non-null type dev.sterner.witchery.mixin.DamageSourcesInvoker");
                DamageSource sunDamageSource = ((DamageSourcesInvoker)damageSources).invokeSource(WitcheryDamageSources.INSTANCE.getIN_SUN());
                this.hurt(sunDamageSource, 1.0f);
                BloodPoolHandler.decreaseBlood((LivingEntity)this, 10);
                this.setRemainingFireTicks(20);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        } else {
            this.inSunTick = 0;
            if (this.getRemainingFireTicks() > 0 && !isDay) {
                this.clearFire();
            }
        }
    }

    private final void handleBloodHealing() {
        BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)this);
        if (bloodData.getBloodPool() >= 75 && this.level().random.nextBoolean() && this.getHealth() < this.getMaxHealth() && this.getHealth() > 0.0f) {
            BloodPoolHandler.decreaseBlood((LivingEntity)this, 75);
            this.heal(1.0f);
        }
    }

    private final void updateHuntStatus() {
        long currentTime = this.level().getDayTime();
        if (currentTime - this.lastHuntTimestamp >= this.nightDuration()) {
            this.huntedLastNight = false;
        }
    }

    private final void tryDepositBloodAtAltar() {
        if (this.level() instanceof ServerLevel && this.collectedBlood > 0 && this.altarPos != null) {
            Level level = this.level();
            BlockPos blockPos = this.altarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof BloodCrucibleBlockEntity) {
                BlockPos blockPos2 = this.altarPos;
                Intrinsics.checkNotNull((Object)blockPos2);
                double d = blockPos2.getX();
                BlockPos blockPos3 = this.altarPos;
                Intrinsics.checkNotNull((Object)blockPos3);
                double d2 = blockPos3.getY();
                BlockPos blockPos4 = this.altarPos;
                Intrinsics.checkNotNull((Object)blockPos4);
                if (this.distanceToSqr(d, d2, blockPos4.getZ()) < 4.0) {
                    Level level2 = this.level();
                    BlockPos blockPos5 = this.altarPos;
                    Intrinsics.checkNotNull((Object)blockPos5);
                    if (!level2.canSeeSky(blockPos5) || !this.level().isDay()) {
                        int masterBloodAmount;
                        ((BloodCrucibleBlockEntity)blockEntity).addBlood(this.collectedBlood);
                        if (this.hasMaster && this.masterPlayer != null && (masterBloodAmount = (int)((double)this.collectedBlood * 0.2)) > 0) {
                            Player player = this.masterPlayer;
                            Intrinsics.checkNotNull((Object)player);
                            BloodPoolHandler.increaseBlood((LivingEntity)player, masterBloodAmount);
                        }
                        this.collectedBlood = 0;
                    }
                }
            }
        }
    }

    private final void updateMasterPlayerReference() {
        ServerPlayer player;
        Level level = this.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        UUID uuid = this.getOwnerUUID();
        if (uuid != null && (player = serverLevel.getServer().getPlayerList().getPlayer(uuid)) != null) {
            AfflictionPlayerAttachment.Data vampireData = AfflictionPlayerAttachment.getData((Player)player);
            if (vampireData.getVampireLevel() >= 10) {
                this.masterPlayer = (Player)player;
                this.hasMaster = true;
            } else {
                this.hasMaster = false;
                this.masterPlayer = null;
            }
        }
    }

    public final void tryStartHunt() {
        if (this.level() instanceof ServerLevel && !this.huntedLastNight && !this.level().isDay()) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            UUID ownerUUID = this.getOwnerUUID();
            if (ownerUUID != null) {
                VampireChildrenHuntHandler.tryStartHunt(serverLevel, this, ownerUUID);
                this.huntedLastNight = true;
                this.lastHuntTimestamp = this.level().getDayTime();
            }
        }
    }

    public final void returnFromHunt(int bloodAmount) {
        this.collectedBlood += bloodAmount;
        this.huntedLastNight = true;
    }

    private final long nightDuration() {
        return 10000L;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    public final void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
        if (uuid != null && this.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.Data vampireData;
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerPlayer player = ((ServerLevel)level).getServer().getPlayerList().getPlayer(uuid);
            if (player != null && (vampireData = AfflictionPlayerAttachment.getData((Player)player)).getVampireLevel() >= 10) {
                this.masterPlayer = (Player)player;
                this.hasMaster = true;
            }
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        if (this.getOwnerUUID() != null) {
            UUID uUID = this.getOwnerUUID();
            Intrinsics.checkNotNull((Object)uUID);
            compound.putUUID("Owner", uUID);
        }
        compound.putInt("InSun", this.inSunTick);
        if (this.coffinPos != null) {
            BlockPos blockPos = this.coffinPos;
            Intrinsics.checkNotNull((Object)blockPos);
            compound.put("CoffinPos", NbtUtils.writeBlockPos((BlockPos)blockPos));
        }
        if (this.creationPos != null) {
            BlockPos blockPos = this.creationPos;
            Intrinsics.checkNotNull((Object)blockPos);
            compound.put("CreationPos", NbtUtils.writeBlockPos((BlockPos)blockPos));
        }
        if (this.altarPos != null) {
            BlockPos blockPos = this.altarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            compound.put("AltarPos", NbtUtils.writeBlockPos((BlockPos)blockPos));
        }
        compound.putLong("HuntTimeStamp", this.lastHuntTimestamp);
        compound.putBoolean("HuntedLastNight", this.huntedLastNight);
        compound.putInt("CollectedBlood", this.collectedBlood);
        compound.putBoolean("HasMaster", this.hasMaster);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        UUID uUID = null;
        if (compound.hasUUID("Owner")) {
            uUID = compound.getUUID("Owner");
        } else {
            String string = compound.getString("Owner");
            uUID = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)string);
        }
        if (uUID != null) {
            this.setOwnerUUID(uUID);
        }
        this.inSunTick = compound.getInt("InSun");
        this.coffinPos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"CoffinPos").orElse(null);
        this.creationPos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"CreationPos").orElse(null);
        this.altarPos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"AltarPos").orElse(null);
        this.huntedLastNight = compound.getBoolean("HuntedLastNight");
        this.lastHuntTimestamp = compound.getLong("LastHuntTimestamp");
        this.collectedBlood = compound.getInt("CollectedBlood");
        this.hasMaster = compound.getBoolean("HasMaster");
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(VampireEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_OWNERUUID_ID = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/entity/VampireEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "DATA_OWNERUUID_ID", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Ljava/util/Optional;", "Ljava/util/UUID;", "getDATA_OWNERUUID_ID", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Optional<UUID>> getDATA_OWNERUUID_ID() {
            return DATA_OWNERUUID_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

