/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.content.item.potion.WitcheryPotionItem;
import dev.sterner.witchery.core.api.SpecialPotion;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.core.registry.WitcherySpecialPotionEffects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 [2\u00020\u00012\u00020\u0002:\u0001[B+\u0012\u0010\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000bB1\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0010J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0014J\b\u00108\u001a\u000205H\u0016J\u0014\u0010<\u001a\u0002052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\b\u0010=\u001a\u000205H\u0002J\b\u0010K\u001a\u000205H\u0016J\u0010\u0010L\u001a\u0002052\b\u00100\u001a\u0004\u0018\u000101J\n\u0010M\u001a\u0004\u0018\u000101H\u0016J\u0010\u0010N\u001a\u0002052\u0006\u0010O\u001a\u00020PH\u0014J\u0010\u0010Q\u001a\u0002052\u0006\u0010O\u001a\u00020PH\u0014J\u0014\u0010R\u001a\u0002052\n\u0010S\u001a\u0006\u0012\u0002\b\u00030TH\u0016J\b\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u000e\u0010#\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001d\"\u0004\b&\u0010\u001fR\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00109\u001a\u00020(2\u0006\u00109\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010*\"\u0004\b;\u0010,R$\u0010@\u001a\u00020?2\u0006\u0010>\u001a\u00020?8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR$\u0010G\u001a\u00020F2\u0006\u0010E\u001a\u00020F8F@DX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010H\"\u0004\bI\u0010J\u00a8\u0006\\"}, d2={"Ldev/sterner/witchery/content/entity/WitcheryAreaEffectCloud;", "Lnet/minecraft/world/entity/Entity;", "Lnet/minecraft/world/entity/TraceableEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "hitResult", "Lnet/minecraft/world/phys/HitResult;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/HitResult;)V", "(Lnet/minecraft/world/level/Level;)V", "x", "", "y", "z", "(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/phys/HitResult;)V", "getHitResult", "()Lnet/minecraft/world/phys/HitResult;", "setHitResult", "(Lnet/minecraft/world/phys/HitResult;)V", "potionContents", "", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient;", "victims", "", "", "duration", "getDuration", "()I", "setDuration", "(I)V", "waitTime", "getWaitTime", "setWaitTime", "reapplicationDelay", "durationOnUse", "getDurationOnUse", "setDurationOnUse", "radiusOnUse", "", "getRadiusOnUse", "()F", "setRadiusOnUse", "(F)V", "radiusPerTick", "getRadiusPerTick", "setRadiusPerTick", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "ownerUUID", "Ljava/util/UUID;", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "refreshDimensions", "radius", "getRadius", "setRadius", "setPotionContents", "updateColor", "particleOption", "Lnet/minecraft/core/particles/ParticleOptions;", "particle", "getParticle", "()Lnet/minecraft/core/particles/ParticleOptions;", "setParticle", "(Lnet/minecraft/core/particles/ParticleOptions;)V", "waiting", "", "isWaiting", "()Z", "setWaiting", "(Z)V", "tick", "setOwner", "getOwner", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "onSyncedDataUpdated", "dataAccessor", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getPistonPushReaction", "Lnet/minecraft/world/level/material/PushReaction;", "getDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nWitcheryAreaEffectCloud.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryAreaEffectCloud.kt\ndev/sterner/witchery/content/entity/WitcheryAreaEffectCloud\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1869#2,2:405\n1761#2,3:407\n1761#2,3:414\n126#3:410\n153#3,3:411\n1#4:417\n*S KotlinDebug\n*F\n+ 1 WitcheryAreaEffectCloud.kt\ndev/sterner/witchery/content/entity/WitcheryAreaEffectCloud\n*L\n137#1:405,2\n196#1:407,3\n249#1:414,3\n215#1:410\n215#1:411,3\n*E\n"})
public final class WitcheryAreaEffectCloud
extends Entity
implements TraceableEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HitResult hitResult;
    @NotNull
    private List<WitcheryPotionIngredient> potionContents;
    @NotNull
    private final Map<Entity, Integer> victims;
    private int duration;
    private int waitTime;
    private int reapplicationDelay;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final EntityDataAccessor<Float> DATA_RADIUS;
    @NotNull
    private static final EntityDataAccessor<Boolean> DATA_WAITING;
    @NotNull
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE;

    public WitcheryAreaEffectCloud(@NotNull EntityType<? extends WitcheryAreaEffectCloud> entityType, @NotNull Level level, @Nullable HitResult hitResult) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.hitResult = hitResult;
        this.potionContents = new ArrayList();
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        this.victims = hashMap;
        this.duration = 600;
        this.waitTime = 20;
        this.reapplicationDelay = 20;
        this.noPhysics = true;
    }

    @Nullable
    public final HitResult getHitResult() {
        return this.hitResult;
    }

    public final void setHitResult(@Nullable HitResult hitResult) {
        this.hitResult = hitResult;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int n) {
        this.duration = n;
    }

    public final int getWaitTime() {
        return this.waitTime;
    }

    public final void setWaitTime(int n) {
        this.waitTime = n;
    }

    public final int getDurationOnUse() {
        return this.durationOnUse;
    }

    public final void setDurationOnUse(int n) {
        this.durationOnUse = n;
    }

    public final float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public final void setRadiusOnUse(float f) {
        this.radiusOnUse = f;
    }

    public final float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public final void setRadiusPerTick(float f) {
        this.radiusPerTick = f;
    }

    public WitcheryAreaEffectCloud(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getAREA_EFFECT_CLOUD().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType<? extends WitcheryAreaEffectCloud>)((EntityType)object), level, null);
    }

    public WitcheryAreaEffectCloud(@NotNull Level level, double x, double y, double z, @NotNull HitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        Object object = WitcheryEntityTypes.INSTANCE.getAREA_EFFECT_CLOUD().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType<? extends WitcheryAreaEffectCloud>)((EntityType)object), level, hitResult);
        this.setPos(x, y, z);
        this.hitResult = hitResult;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        builder.define(DATA_WAITING, (Object)false);
        builder.define(DATA_PARTICLE, (Object)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1));
    }

    public void refreshDimensions() {
        double d = this.getX();
        double e = this.getY();
        double f = this.getZ();
        super.refreshDimensions();
        this.setPos(d, e, f);
    }

    public final float getRadius() {
        Object object = this.getEntityData().get(DATA_RADIUS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    public final void setRadius(float radius) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(Mth.clamp((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public final void setPotionContents(@NotNull List<WitcheryPotionIngredient> potionContents) {
        Intrinsics.checkNotNullParameter(potionContents, (String)"potionContents");
        this.potionContents = potionContents;
        this.updateColor();
    }

    private final void updateColor() {
        ParticleOptions particleOptions = (ParticleOptions)this.entityData.get(DATA_PARTICLE);
        if (particleOptions instanceof ColorParticleOption) {
            int i = this.potionContents.isEmpty() ? 0 : ((WitcheryPotionIngredient)CollectionsKt.last(this.potionContents)).getColor();
            this.entityData.set(DATA_PARTICLE, (Object)ColorParticleOption.create((ParticleType)((ColorParticleOption)particleOptions).getType(), (int)FastColor.ARGB32.opaque((int)i)));
        }
    }

    @NotNull
    public final ParticleOptions getParticle() {
        Object object = this.getEntityData().get(DATA_PARTICLE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ParticleOptions)object;
    }

    public final void setParticle(@NotNull ParticleOptions particleOption) {
        Intrinsics.checkNotNullParameter((Object)particleOption, (String)"particleOption");
        this.getEntityData().set(DATA_PARTICLE, (Object)particleOption);
    }

    public final boolean isWaiting() {
        Object object = this.getEntityData().get(DATA_WAITING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    protected final void setWaiting(boolean waiting) {
        this.getEntityData().set(DATA_WAITING, (Object)waiting);
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        block35: {
            boolean bl;
            List list;
            float f;
            block32: {
                boolean bl2;
                boolean bl3;
                block34: {
                    super.tick();
                    bl3 = this.isWaiting();
                    f = this.getRadius();
                    if (!this.level().isClientSide) break block34;
                    if (bl3 && this.random.nextBoolean()) {
                        return;
                    }
                    ParticleOptions particleOptions = this.getParticle();
                    int i = 0;
                    float g = 0.0f;
                    if (bl3) {
                        i = 2;
                        g = 0.2f;
                    } else {
                        i = Mth.ceil((float)((float)Math.PI * f * f));
                        g = f;
                    }
                    Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)i);
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int j = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl4 = false;
                        float h = this.random.nextFloat() * ((float)Math.PI * 2);
                        float k = Mth.sqrt((float)this.random.nextFloat()) * g;
                        double d = this.getX() + (double)(Mth.cos((float)h) * k);
                        double e = this.getY();
                        double l = this.getZ() + (double)(Mth.sin((float)h) * k);
                        if (particleOptions.getType() == ParticleTypes.ENTITY_EFFECT) {
                            if (bl3 && this.random.nextBoolean()) {
                                this.level().addAlwaysVisibleParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1), d, e, l, 0.0, 0.0, 0.0);
                                continue;
                            }
                            this.level().addAlwaysVisibleParticle(particleOptions, d, e, l, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (bl3) {
                            this.level().addAlwaysVisibleParticle(particleOptions, d, e, l, 0.0, 0.0, 0.0);
                            continue;
                        }
                        this.level().addAlwaysVisibleParticle(particleOptions, d, e, l, (0.5 - this.random.nextDouble()) * 0.15, 0.01, (0.5 - this.random.nextDouble()) * 0.15);
                    }
                    break block35;
                }
                if (this.tickCount >= this.waitTime + this.duration) {
                    this.discard();
                    return;
                }
                boolean bl5 = bl2 = this.tickCount < this.waitTime;
                if (bl3 != bl2) {
                    this.setWaiting(bl2);
                }
                if (bl2) {
                    return;
                }
                if (!(this.radiusPerTick == 0.0f)) {
                    if ((f += this.radiusPerTick) < 0.5f) {
                        this.discard();
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.tickCount % 5 != 0) break block35;
                this.victims.entrySet().removeIf(arg_0 -> WitcheryAreaEffectCloud.tick$lambda$2(arg_0 -> WitcheryAreaEffectCloud.tick$lambda$1(this, arg_0), arg_0));
                ArrayList arrayList = Lists.newArrayList();
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
                list = arrayList;
                Iterable $this$any$iv = this.potionContents;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        WitcheryPotionIngredient it = (WitcheryPotionIngredient)element$iv;
                        boolean bl6 = false;
                        if (!it.getGeneralModifier().contains((Object)WitcheryPotionIngredient.GeneralModifier.NO_PARTICLE)) continue;
                        bl = true;
                        break block32;
                    }
                    bl = false;
                }
            }
            boolean visible = !bl;
            boolean shouldInvertNext = false;
            for (WitcheryPotionIngredient ingredient : this.potionContents) {
                Holder<MobEffect> holder;
                int duration = (ingredient.getBaseDuration() + ingredient.getEffectModifier().getDurationAddition()) * ingredient.getEffectModifier().getDurationMultiplier();
                int amplifier = ingredient.getEffectModifier().getPowerAddition();
                if (ingredient.getSpecialEffect().isPresent()) {
                    if (this.hitResult != null) {
                        boolean bl7 = false;
                        SpecialPotion specialPotion = (SpecialPotion)WitcherySpecialPotionEffects.INSTANCE.getSPECIAL_REGISTRY().get(ingredient.getSpecialEffect().get());
                        if (specialPotion != null) {
                            Level level;
                            Collection<Entity> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            HitResult hitResult1;
                            Intrinsics.checkNotNullExpressionValue((Object)this.level(), (String)"level(...)");
                            Map<Entity, Integer> e = this.victims;
                            HitResult hitResult = hitResult1;
                            Entity entity = (Entity)this.owner;
                            SpecialPotion specialPotion2 = specialPotion;
                            boolean $i$f$map = false;
                            void var22_49 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                            boolean $i$f$mapTo = false;
                            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                void it;
                                Map.Entry item$iv$iv;
                                Map.Entry entry = item$iv$iv = iterator.next();
                                collection = destination$iv$iv;
                                boolean bl8 = false;
                                collection.add((Entity)it.getKey());
                            }
                            collection = (List)destination$iv$iv;
                            specialPotion2.onActivated(level, entity, hitResult, CollectionsKt.toMutableList((Collection)collection), WitcheryPotionItem.Companion.getMergedDisperseModifier(this.potionContents), duration, amplifier);
                        }
                    }
                }
                if (ingredient.getGeneralModifier().contains((Object)WitcheryPotionIngredient.GeneralModifier.INVERT_NEXT)) {
                    shouldInvertNext = true;
                }
                if (shouldInvertNext) {
                    shouldInvertNext = false;
                    holder = WitcheryMobEffects.INSTANCE.invertEffect(ingredient.getEffect());
                } else {
                    holder = ingredient.getEffect();
                }
                Holder<MobEffect> effect = holder;
                list.add(new MobEffectInstance(effect, duration, amplifier, false, visible));
            }
            List list2 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
            Intrinsics.checkNotNull((Object)list2);
            if (!((Collection)list2).isEmpty()) {
                for (LivingEntity livingEntity : list2) {
                    double n;
                    double m;
                    double o;
                    boolean bl9;
                    block33: {
                        if (this.victims.containsKey(livingEntity) || !livingEntity.isAffectedByPotions()) continue;
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl9 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                MobEffectInstance it = (MobEffectInstance)element$iv;
                                boolean bl10 = false;
                                if (!livingEntity.canBeAffected(it)) continue;
                                bl9 = true;
                                break block33;
                            }
                            bl9 = false;
                        }
                    }
                    if (!bl9 || !((o = (m = livingEntity.getX() - this.getX()) * m + (n = livingEntity.getZ() - this.getZ()) * n) <= (double)(f * f))) continue;
                    this.victims.put((Entity)livingEntity, this.tickCount + this.reapplicationDelay);
                    for (MobEffectInstance mobEffectInstance2 : list) {
                        if (((MobEffect)mobEffectInstance2.getEffect().value()).isInstantenous()) {
                            ((MobEffect)mobEffectInstance2.getEffect().value()).applyInstantenousEffect((Entity)this, (Entity)this.getOwner(), livingEntity, mobEffectInstance2.getAmplifier(), 0.5);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)mobEffectInstance2, WitcheryMobEffects.INSTANCE.getEMPTY())) continue;
                        livingEntity.addEffect(new MobEffectInstance(mobEffectInstance2), (Entity)this);
                    }
                    if (!(this.radiusOnUse == 0.0f)) {
                        if ((f += this.radiusOnUse) < 0.5f) {
                            this.discard();
                            return;
                        }
                        this.setRadius(f);
                    }
                    if (this.durationOnUse == 0) continue;
                    this.duration += this.durationOnUse;
                    if (this.duration > 0) continue;
                    this.discard();
                    return;
                }
            }
        }
    }

    public final void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        LivingEntity livingEntity = owner;
        this.ownerUUID = livingEntity != null ? livingEntity.getUUID() : null;
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uUID = this.ownerUUID;
            Intrinsics.checkNotNull((Object)uUID);
            Entity entity = serverLevel.getEntity(uUID);
            if (entity instanceof LivingEntity) {
                this.owner = (LivingEntity)entity;
            }
        }
        return this.owner;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            this.tickCount = compound.getInt("Age");
            this.duration = compound.getInt("Duration");
            this.waitTime = compound.getInt("WaitTime");
            this.reapplicationDelay = compound.getInt("ReapplicationDelay");
            this.durationOnUse = compound.getInt("DurationOnUse");
            this.radiusOnUse = compound.getFloat("RadiusOnUse");
            this.radiusPerTick = compound.getFloat("RadiusPerTick");
            this.setRadius(compound.getFloat("Radius"));
            if (compound.hasUUID("Owner")) {
                this.ownerUUID = compound.getUUID("Owner");
            }
            RegistryOps registryOps = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            if (compound.contains("Particle", 10)) {
                ParticleTypes.CODEC.parse((DynamicOps)registryOps, (Object)compound.get("Particle")).resultOrPartial(WitcheryAreaEffectCloud::readAdditionalSaveData$lambda$0).ifPresent(arg_0 -> WitcheryAreaEffectCloud.readAdditionalSaveData$lambda$2(arg_0 -> WitcheryAreaEffectCloud.readAdditionalSaveData$lambda$1(this, arg_0), arg_0));
            }
            if (!compound.contains("witcheryPotionItemCache", 9)) break block3;
            ListTag listTag = compound.getList("witcheryPotionItemCache", 10);
            DataResult decodeResult = WitcheryPotionIngredient.Companion.getCODEC().listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)listTag);
            Optional optional = decodeResult.resultOrPartial(WitcheryAreaEffectCloud::readAdditionalSaveData$lambda$3);
            if (optional != null) {
                Optional it = optional;
                boolean bl = false;
                Object t = it.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                this.potionContents = CollectionsKt.toMutableList((Collection)((Collection)t));
            }
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            compound.putInt("Age", this.tickCount);
            compound.putInt("Duration", this.duration);
            compound.putInt("WaitTime", this.waitTime);
            compound.putInt("ReapplicationDelay", this.reapplicationDelay);
            compound.putInt("DurationOnUse", this.durationOnUse);
            compound.putFloat("RadiusOnUse", this.radiusOnUse);
            compound.putFloat("RadiusPerTick", this.radiusPerTick);
            compound.putFloat("Radius", this.getRadius());
            RegistryOps registryOps = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            compound.put("Particle", (Tag)ParticleTypes.CODEC.encodeStart((DynamicOps)registryOps, (Object)this.getParticle()).getOrThrow());
            if (this.ownerUUID != null) {
                UUID uUID = this.ownerUUID;
                Intrinsics.checkNotNull((Object)uUID);
                compound.putUUID("Owner", uUID);
            }
            DataResult listResult = WitcheryPotionIngredient.Companion.getCODEC().listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.potionContents);
            Optional optional = listResult.resultOrPartial(WitcheryAreaEffectCloud::addAdditionalSaveData$lambda$0);
            if (optional == null) break block1;
            Optional it = optional;
            boolean bl = false;
            compound.put("witcheryPotionItemCache", (Tag)it.get());
        }
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataAccessor) {
        Intrinsics.checkNotNullParameter(dataAccessor, (String)"dataAccessor");
        if (Intrinsics.areEqual(DATA_RADIUS, dataAccessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    @NotNull
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        EntityDimensions entityDimensions = EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)0.5f);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"scalable(...)");
        return entityDimensions;
    }

    private static final boolean tick$lambda$1(WitcheryAreaEffectCloud this$0, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return this$0.tickCount >= ((Number)entry.getValue()).intValue();
    }

    private static final boolean tick$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void readAdditionalSaveData$lambda$0(String string) {
        LOGGER.warn("Failed to parse area effect cloud particle options: '{}'", (Object)string);
    }

    private static final Unit readAdditionalSaveData$lambda$1(WitcheryAreaEffectCloud this$0, ParticleOptions particleOption) {
        Intrinsics.checkNotNullParameter((Object)particleOption, (String)"particleOption");
        this$0.setParticle(particleOption);
        return Unit.INSTANCE;
    }

    private static final void readAdditionalSaveData$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void readAdditionalSaveData$lambda$3(String string) {
    }

    private static final void addAdditionalSaveData$lambda$0(String string) {
    }

    static {
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(WitcheryAreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_RADIUS = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(WitcheryAreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        DATA_WAITING = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(WitcheryAreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.PARTICLE);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        DATA_PARTICLE = entityDataAccessor3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/content/entity/WitcheryAreaEffectCloud$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "DATA_RADIUS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "DATA_WAITING", "", "DATA_PARTICLE", "Lnet/minecraft/core/particles/ParticleOptions;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

