/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.WitcheryAreaEffectCloud;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.content.item.potion.WitcheryPotionItem;
import dev.sterner.witchery.core.api.SpecialPotion;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.core.registry.WitcherySpecialPotionEffects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0014J\u001e\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0012\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\"\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\b\u0010\u001e\u001a\u0004\u0018\u00010+2\u0006\u0010\u0012\u001a\u00020\u0017H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/content/entity/WitcheryThrownPotion;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "Lnet/minecraft/world/entity/projectile/ItemSupplier;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "lingering", "", "getLingering", "()Z", "setLingering", "(Z)V", "onHitBlock", "", "result", "Lnet/minecraft/world/phys/BlockHitResult;", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "onHit", "Lnet/minecraft/world/phys/HitResult;", "makeAreaOfEffectCloud", "potionContentList", "", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient;", "calculateHorizontalHurtKnockbackDirection", "Lit/unimi/dsi/fastutil/doubles/DoubleDoubleImmutablePair;", "entity", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "getDefaultGravity", "", "calculateEffectDuration", "", "potionContent", "effectData", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient$EffectModifier;", "applySplash", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/entity/Entity;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nWitcheryThrownPotion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryThrownPotion.kt\ndev/sterner/witchery/content/entity/WitcheryThrownPotion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1563#2:210\n1634#2,3:211\n808#2,11:215\n1761#2,3:226\n1#3:214\n*S KotlinDebug\n*F\n+ 1 WitcheryThrownPotion.kt\ndev/sterner/witchery/content/entity/WitcheryThrownPotion\n*L\n51#1:210\n51#1:211,3\n169#1:215,11\n185#1:226,3\n*E\n"})
public final class WitcheryThrownPotion
extends ThrowableItemProjectile
implements ItemSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean lingering;

    public final boolean getLingering() {
        return this.lingering;
    }

    public final void setLingering(boolean bl) {
        this.lingering = bl;
    }

    public WitcheryThrownPotion(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getTHROWN_POTION().get(), level);
    }

    public WitcheryThrownPotion(@NotNull Level level, @NotNull LivingEntity shooter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getTHROWN_POTION().get(), shooter, level);
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitBlock(result);
    }

    @NotNull
    protected Item getDefaultItem() {
        Item item = Items.SPLASH_POTION;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"SPLASH_POTION");
        return item;
    }

    /*
     * WARNING - void declaration
     */
    protected void onHit(@NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHit(result);
        if (!this.level().isClientSide) {
            ItemStack itemStack = this.getItem();
            if (itemStack.getItem() instanceof WitcheryPotionItem) {
                List potionContentList = (List)itemStack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get());
                if (this.lingering) {
                    List list = potionContentList;
                    if (list != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        List potionContent = list;
                        boolean bl = false;
                        Iterable iterable = potionContent;
                        WitcheryThrownPotion witcheryThrownPotion = this;
                        boolean $i$f$map = false;
                        void var9_11 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            WitcheryPotionIngredient witcheryPotionIngredient = (WitcheryPotionIngredient)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it);
                        }
                        witcheryThrownPotion.makeAreaOfEffectCloud(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)), result);
                    }
                } else {
                    Intrinsics.checkNotNull((Object)itemStack);
                    this.applySplash(itemStack, result.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)result).getEntity() : null, result);
                }
                List list = potionContentList;
                if (list != null) {
                    int color;
                    List it = list;
                    boolean bl = false;
                    int it2 = color = ((WitcheryPotionIngredient)CollectionsKt.last((List)potionContentList)).getColor();
                    boolean bl3 = false;
                    this.level().levelEvent(2002, this.blockPosition(), it2);
                }
            }
            this.discard();
        }
    }

    private final void makeAreaOfEffectCloud(List<WitcheryPotionIngredient> potionContentList, HitResult result) {
        Comparable comparable;
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        WitcheryAreaEffectCloud areaEffectCloud = new WitcheryAreaEffectCloud(level, this.getX(), this.getY(), this.getZ(), result);
        areaEffectCloud.setRadius(3.0f + (float)Companion.getRangeBonus(potionContentList));
        areaEffectCloud.setRadiusOnUse(-0.5f);
        areaEffectCloud.setWaitTime(10);
        areaEffectCloud.setHitResult(result);
        int baseDuration = areaEffectCloud.getDuration();
        Iterator iterator = ((Iterable)potionContentList).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            WitcheryPotionIngredient it = (WitcheryPotionIngredient)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getDispersalModifier().getLingeringDurationModifier());
            while (iterator.hasNext()) {
                WitcheryPotionIngredient it2 = (WitcheryPotionIngredient)iterator.next();
                $i$a$-maxOfOrNull-WitcheryThrownPotion$makeAreaOfEffectCloud$lingeringModifier$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getDispersalModifier().getLingeringDurationModifier());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int lingeringModifier = n != null ? n : 1;
        areaEffectCloud.setDuration(baseDuration * lingeringModifier);
        areaEffectCloud.setRadiusPerTick(-areaEffectCloud.getRadius() / (float)areaEffectCloud.getDuration());
        areaEffectCloud.setPotionContents(potionContentList);
        this.level().addFreshEntity((Entity)areaEffectCloud);
    }

    @NotNull
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(@NotNull LivingEntity entity, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        double d = entity.position().x - this.position().x;
        double e = entity.position().z - this.position().z;
        DoubleDoubleImmutablePair doubleDoubleImmutablePair = DoubleDoubleImmutablePair.of((double)d, (double)e);
        Intrinsics.checkNotNullExpressionValue((Object)doubleDoubleImmutablePair, (String)"of(...)");
        return doubleDoubleImmutablePair;
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    private final int calculateEffectDuration(WitcheryPotionIngredient potionContent, WitcheryPotionIngredient.EffectModifier effectData) {
        return (potionContent.getBaseDuration() + effectData.getDurationAddition()) * effectData.getDurationMultiplier();
    }

    /*
     * WARNING - void declaration
     */
    private final void applySplash(ItemStack stack, Entity entity, HitResult result) {
        List potionContentList;
        int scaleBonus = Companion.getRangeBonus(stack);
        AABB aABB = this.getBoundingBox().inflate(4.0 * (double)scaleBonus, 2.0 * (double)scaleBonus, 4.0 * (double)scaleBonus);
        List list = this.level().getEntitiesOfClass(Entity.class, aABB);
        if (stack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get()) && (potionContentList = (List)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get())) != null) {
            boolean shouldInvertNext = false;
            WitcheryPotionIngredient.EffectModifier globalModifier = WitcheryPotionItem.Companion.getMergedEffectModifier(potionContentList);
            Iterator iterator = ((Iterable)potionContentList).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                void $this$filterIsInstanceTo$iv$iv;
                Holder<MobEffect> effect;
                Holder<MobEffect> holder;
                int i = n++;
                WitcheryPotionIngredient potionContent = (WitcheryPotionIngredient)iterator.next();
                if (i == 0) continue;
                int duration = this.calculateEffectDuration(potionContent, globalModifier);
                int amplifier = globalModifier.getPowerAddition();
                if (potionContent.getSpecialEffect().isPresent()) {
                    SpecialPotion special;
                    SpecialPotion specialPotion = special = (SpecialPotion)WitcherySpecialPotionEffects.INSTANCE.getSPECIAL_REGISTRY().get(potionContent.getSpecialEffect().get());
                    if (specialPotion != null) {
                        Level level = this.level();
                        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                        Entity entity2 = this.getOwner();
                        Intrinsics.checkNotNull((Object)list);
                        specialPotion.onActivated(level, entity2, result, list, WitcheryPotionItem.Companion.getMergedDisperseModifier(potionContentList), duration, amplifier);
                    }
                }
                if (potionContent.getGeneralModifier().contains((Object)WitcheryPotionIngredient.GeneralModifier.INVERT_NEXT)) {
                    shouldInvertNext = true;
                    continue;
                }
                if (shouldInvertNext) {
                    shouldInvertNext = false;
                    holder = WitcheryMobEffects.INSTANCE.invertEffect(potionContent.getEffect());
                } else {
                    holder = potionContent.getEffect();
                }
                if (Intrinsics.areEqual(effect = holder, WitcheryMobEffects.INSTANCE.getEMPTY())) continue;
                Intrinsics.checkNotNull((Object)list);
                if (!(!((Collection)list).isEmpty())) continue;
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LivingEntity)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List livingList = (List)destination$iv$iv;
                for (LivingEntity livingEntity : livingList) {
                    boolean visible;
                    MobEffectInstance mobEffectInstance;
                    boolean bl;
                    block13: {
                        double e;
                        double d;
                        if (!livingEntity.isAffectedByPotions() || !((d = this.distanceToSqr((Entity)livingEntity)) < 16.0)) continue;
                        double d2 = e = livingEntity == entity ? 1.0 : 1.0 - Math.sqrt(d) / 4.0;
                        if (((MobEffect)effect.value()).isInstantenous()) {
                            ((MobEffect)effect.value()).applyInstantenousEffect((Entity)this, this.getOwner(), livingEntity, amplifier, e);
                            continue;
                        }
                        Iterable $this$any$iv = potionContentList;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                WitcheryPotionIngredient it = (WitcheryPotionIngredient)element$iv;
                                boolean bl2 = false;
                                if (!it.getGeneralModifier().contains((Object)WitcheryPotionIngredient.GeneralModifier.NO_PARTICLE)) continue;
                                bl = true;
                                break block13;
                            }
                            bl = false;
                        }
                    }
                    if ((mobEffectInstance = new MobEffectInstance(effect, duration, amplifier, false, visible = !bl)).endsWithin(20)) continue;
                    livingEntity.addEffect(mobEffectInstance, this.getEffectSource());
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/WitcheryThrownPotion$Companion;", "", "<init>", "()V", "getRangeBonus", "", "potion", "", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient;", "stack", "Lnet/minecraft/world/item/ItemStack;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nWitcheryThrownPotion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryThrownPotion.kt\ndev/sterner/witchery/content/entity/WitcheryThrownPotion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getRangeBonus(@NotNull List<WitcheryPotionIngredient> potion) {
            Comparable comparable;
            Intrinsics.checkNotNullParameter(potion, (String)"potion");
            Iterator iterator = ((Iterable)potion).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                WitcheryPotionIngredient it = (WitcheryPotionIngredient)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getDispersalModifier().getRangeModifier());
                while (iterator.hasNext()) {
                    WitcheryPotionIngredient it2 = (WitcheryPotionIngredient)iterator.next();
                    $i$a$-maxOfOrNull-WitcheryThrownPotion$Companion$getRangeBonus$1 = false;
                    Comparable comparable3 = Integer.valueOf(it2.getDispersalModifier().getRangeModifier());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            return n != null ? n : 1;
        }

        public final int getRangeBonus(@NotNull ItemStack stack) {
            Comparable comparable;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            List list = (List)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get());
            if (list == null) {
                return 1;
            }
            List potionContentList = list;
            Iterator iterator = ((Iterable)potionContentList).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                WitcheryPotionIngredient it = (WitcheryPotionIngredient)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getDispersalModifier().getRangeModifier());
                while (iterator.hasNext()) {
                    WitcheryPotionIngredient it2 = (WitcheryPotionIngredient)iterator.next();
                    $i$a$-maxOfOrNull-WitcheryThrownPotion$Companion$getRangeBonus$2 = false;
                    Comparable comparable3 = Integer.valueOf(it2.getDispersalModifier().getRangeModifier());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            return n != null ? n : 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

