/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import dev.sterner.witchery.network.OpenTarotScreenS2CPayload;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/content/item/TarotDeckItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "", "stack", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "witchery"})
public final class TarotDeckItem
extends Item {
    public TarotDeckItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            if (WitcheryApi.INSTANCE.isWitchy(player)) {
                TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData(player);
                if (data2.getDrawnCards().isEmpty()) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenTarotScreenS2CPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC};
                    ((ServerPlayer)player).displayClientMessage((Component)Component.literal((String)"Your fortune this week has already been decided.").withStyle(chatFormattingArray), true);
                }
            } else {
                ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC};
                ((ServerPlayer)player).displayClientMessage((Component)Component.literal((String)"You don't know how to use this.").withStyle(chatFormattingArray), true);
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC};
        MutableComponent mutableComponent = Component.translatable((String)"item.witchery.tarot_deck.desc").withStyle(chatFormattingArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        tooltipComponents.add((Component)mutableComponent);
        MutableComponent mutableComponent2 = Component.literal((String)"Draw 3 cards from the Major Arcana").withStyle(ChatFormatting.DARK_PURPLE);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
        tooltipComponents.add((Component)mutableComponent2);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

