/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import com.google.common.base.Predicate;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.features.familiar.FamiliarHandler;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0016J \u0010)\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'H\u0016J \u0010,\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewItem;", "Lnet/minecraft/world/item/Item;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "predicate", "Lcom/google/common/base/Predicate;", "Lnet/minecraft/core/Direction;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;Lcom/google/common/base/Predicate;)V", "getColor", "()I", "getPredicate", "()Lcom/google/common/base/Predicate;", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "getUseDuration", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "applyEffectOnSelf", "", "hasFrog", "", "applyEffectOnEntities", "applyEffectOnBlock", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "applyEffectOnHitLocation", "location", "Lnet/minecraft/world/phys/Vec3;", "Companion", "witchery"})
public class BrewItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int color;
    @NotNull
    private final Predicate<Direction> predicate;
    private static final int DRINK_DURATION = 32;

    public BrewItem(int color, @NotNull Item.Properties properties, @NotNull Predicate<Direction> predicate) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        super(properties);
        this.color = color;
        this.predicate = predicate;
    }

    public /* synthetic */ BrewItem(int n, Item.Properties properties, Predicate predicate, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            predicate = BrewItem::_init_$lambda$0;
        }
        this(n, properties, (Predicate<Direction>)predicate);
    }

    public int getColor() {
        return this.color;
    }

    @NotNull
    public final Predicate<Direction> getPredicate() {
        return this.predicate;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Player player2 = player = livingEntity instanceof Player ? (Player)livingEntity : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        if (!level.isClientSide && player != null) {
            UUID uUID = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            boolean frog = Intrinsics.areEqual(FamiliarHandler.INSTANCE.getFamiliarEntityType(uUID, (ServerLevel)level), (Object)EntityType.FROG);
            WitcheryApi.INSTANCE.makePlayerWitchy(player);
            this.applyEffectOnSelf(player, frog);
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)player);
        }
        if (player == null || !player.hasInfiniteMaterials()) {
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            Player player3 = player;
            if (player3 != null && (player3 = player3.getInventory()) != null) {
                player3.add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        livingEntity.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return InteractionResult.PASS;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
        return interactionResultHolder;
    }

    public void applyEffectOnSelf(@NotNull Player player, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    public void applyEffectOnEntities(@NotNull Level level, @NotNull LivingEntity livingEntity, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
    }

    public void applyEffectOnBlock(@NotNull Level level, @NotNull BlockHitResult blockHit, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockHit, (String)"blockHit");
    }

    public void applyEffectOnHitLocation(@NotNull Level level, @NotNull Vec3 location, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
    }

    private static final boolean _init_$lambda$0(Direction it) {
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewItem$Companion;", "", "<init>", "()V", "DRINK_DURATION", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

