/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfWastingItem;", "Ldev/sterner/witchery/content/item/brew/ThrowableBrewItem;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;)V", "applyEffectOnEntities", "", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "hasFrog", "", "applyEffectOnBlock", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "applyEffectOnHitLocation", "location", "Lnet/minecraft/world/phys/Vec3;", "witchery"})
public final class BrewOfWastingItem
extends ThrowableBrewItem {
    public BrewOfWastingItem(int color, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(color, properties, null, 4, null);
    }

    @Override
    public void applyEffectOnEntities(@NotNull Level level, @NotNull LivingEntity livingEntity, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity instanceof Player) {
            int hungerDuration = hasFrog ? 600 : 300;
            int hungerAmplifier = hasFrog ? 2 : 1;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.HUNGER, hungerDuration, hungerAmplifier));
            level.playSound(null, ((Player)livingEntity).getX(), ((Player)livingEntity).getY(), ((Player)livingEntity).getZ(), SoundEvents.WITCH_DRINK, SoundSource.PLAYERS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        } else {
            int witherDuration = hasFrog ? 200 : 100;
            int witherAmplifier = hasFrog ? 1 : 0;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, witherDuration, witherAmplifier));
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, livingEntity.getX(), livingEntity.getY() + (double)(livingEntity.getBbHeight() / (float)2), livingEntity.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void applyEffectOnBlock(@NotNull Level level, @NotNull BlockHitResult blockHit, boolean hasFrog) {
        boolean isPlant;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockHit, (String)"blockHit");
        BlockPos pos = blockHit.getBlockPos();
        BlockState state = level.getBlockState(pos);
        boolean bl = isPlant = state.getBlock() instanceof CropBlock || state.getBlock() instanceof FlowerBlock || state.getBlock() instanceof BushBlock || state.getBlock() instanceof LeavesBlock || state.getBlock() instanceof SaplingBlock;
        if (isPlant) {
            level.destroyBlock(pos, false);
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            if (hasFrog) {
                for (int dx = -1; dx < 2; ++dx) {
                    for (int dy = -1; dy < 2; ++dy) {
                        for (int dz = -1; dz < 2; ++dz) {
                            boolean isNearbyPlant;
                            if (dx == 0 && dy == 0 && dz == 0) continue;
                            BlockPos nearbyPos = pos.offset(dx, dy, dz);
                            BlockState nearbyState = level.getBlockState(nearbyPos);
                            boolean bl2 = isNearbyPlant = nearbyState.getBlock() instanceof CropBlock || nearbyState.getBlock() instanceof FlowerBlock || nearbyState.getBlock() instanceof BushBlock || nearbyState.getBlock() instanceof LeavesBlock || nearbyState.getBlock() instanceof SaplingBlock;
                            if (!isNearbyPlant) continue;
                            level.destroyBlock(nearbyPos, true);
                        }
                    }
                }
            }
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WITHER_AMBIENT, SoundSource.BLOCKS, 0.5f, 0.8f + level.random.nextFloat() * 0.4f);
        }
    }

    @Override
    public void applyEffectOnHitLocation(@NotNull Level level, @NotNull Vec3 location, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        double radius = hasFrog ? 4.0 : 2.5;
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(location.x - radius, location.y - radius, location.z - radius, location.x + radius, location.y + radius, location.z + radius));
        for (LivingEntity entity : entities) {
            Intrinsics.checkNotNull((Object)entity);
            this.applyEffectOnEntities(level, entity, hasFrog);
        }
        int blockRadius = hasFrog ? 5 : 4;
        int dx = -blockRadius;
        if (dx <= blockRadius) {
            while (true) {
                int dy;
                if ((dy = -blockRadius) <= blockRadius) {
                    while (true) {
                        int dz;
                        if ((dz = -blockRadius) <= blockRadius) {
                            while (true) {
                                BlockPos pos = new BlockPos((int)location.x + dx, (int)location.y + dy, (int)location.z + dz);
                                double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                                double chance = 1.0 - distance / (double)blockRadius;
                                if (level.random.nextDouble() < chance) {
                                    boolean isPlant;
                                    BlockState state = level.getBlockState(pos);
                                    boolean bl = isPlant = state.getBlock() instanceof CropBlock || state.getBlock() instanceof FlowerBlock || state.getBlock() instanceof BushBlock || state.getBlock() instanceof LeavesBlock || state.getBlock() instanceof SaplingBlock;
                                    if (isPlant) {
                                        BlockHitResult fakeHit = new BlockHitResult(location, Direction.UP, pos, false);
                                        this.applyEffectOnBlock(level, fakeHit, hasFrog);
                                    }
                                }
                                if (dz == blockRadius) break;
                                ++dz;
                            }
                        }
                        if (dy == blockRadius) break;
                        ++dy;
                    }
                }
                if (dx == blockRadius) break;
                ++dx;
            }
        }
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)new Color(145, 80, 40).getRGB()), location.x, location.y, location.z, 0.3, 0.3, 0.0);
    }
}

